/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.utils.LRUCache;
import tigase.pubsub.utils.LRUCacheWithFuture;
import tigase.stats.StatisticsList;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Ignore
public class CacheTest {
    private static String[][] nodes = new String[0][];

    @BeforeClass
    public static void prepareNodes() {
        Random random = new Random();
        nodes = new String[10][];
        for (int j = 0; j < 10; ++j) {
            CacheTest.nodes[j] = new String[100000];
            for (int i = 0; i < 100000; ++i) {
                CacheTest.nodes[j][i] = "node-" + String.valueOf(random.nextInt(8000));
            }
        }
    }

    @Test
    public void testLRUCache() throws TigaseStringprepException, InterruptedException {
        long avgTime = 0L;
        for (int y = 0; y < 1; ++y) {
            System.gc();
            LRUCache cache = new LRUCache(2000);
            BareJID serviceJid = BareJID.bareJIDInstance((String)"test@test.com");
            long start = System.currentTimeMillis();
            ExecutorService service = Executors.newFixedThreadPool(10);
            for (int j = 0; j < 10; ++j) {
                String[] nodes = CacheTest.nodes[j];
                service.submit(() -> {
                    for (int i = 0; i < 100000; ++i) {
                        try {
                            CachedPubSubRepository.NodeKey key = new CachedPubSubRepository.NodeKey(serviceJid, nodes[i]);
                            this.sleep();
                            cache.putIfAbsent((Object)key, (Object)String.valueOf(i));
                            cache.get((Object)key);
                            continue;
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                        }
                    }
                });
            }
            service.shutdown();
            while (!service.isTerminated()) {
                service.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            long end = System.currentTimeMillis();
            System.out.println("lru done in:" + (end - start) + "ms, size:" + cache.size());
            cache.everyMinute();
            StatisticsList list = new StatisticsList(Level.FINEST);
            cache.getStatistics("tmp", list);
            System.out.println(list.toString());
            avgTime += end - start;
        }
        System.out.println("avg lru done in:" + avgTime / 3L + "ms");
    }

    @Test
    public void testLRUCacheWithFuture() throws TigaseStringprepException, InterruptedException {
        long avgTime = 0L;
        for (int y = 0; y < 1; ++y) {
            System.gc();
            LRUCacheWithFuture cache = new LRUCacheWithFuture(2000);
            BareJID serviceJid = BareJID.bareJIDInstance((String)"test@test.com");
            long start = System.currentTimeMillis();
            ExecutorService service = Executors.newFixedThreadPool(10);
            for (int j = 0; j < 10; ++j) {
                String[] nodes = CacheTest.nodes[j];
                service.submit(() -> {
                    for (int i = 0; i < 100000; ++i) {
                        int x = i;
                        CachedPubSubRepository.NodeKey key = new CachedPubSubRepository.NodeKey(serviceJid, nodes[i]);
                        try {
                            cache.computeIfAbsent((Object)key, () -> {
                                this.sleep();
                                return String.valueOf(x);
                            });
                            cache.get((Object)key);
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            Assert.assertNull((String)"Got exception:", (Object)e);
                        }
                    }
                });
            }
            service.shutdown();
            while (!service.isTerminated()) {
                service.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            long end = System.currentTimeMillis();
            System.out.println("lru future done in:" + (end - start) + "ms, size:" + cache.size());
            cache.everyMinute();
            StatisticsList list = new StatisticsList(Level.FINEST);
            cache.getStatistics("tmp", list);
            System.out.println(list.toString());
            avgTime += end - start;
        }
        System.out.println("avg lru future done in:" + avgTime / 3L + "ms");
    }

    @Test
    public void testSizedCache() throws TigaseStringprepException, InterruptedException {
        long avgTime = 0L;
        for (int y = 0; y < 1; ++y) {
            System.gc();
            CachedPubSubRepository.SizedCache cache = new CachedPubSubRepository.SizedCache(2000);
            Map map = Collections.synchronizedMap(cache);
            BareJID serviceJid = BareJID.bareJIDInstance((String)"test@test.com");
            ExecutorService service = Executors.newFixedThreadPool(10);
            long start = System.currentTimeMillis();
            for (int j = 0; j < 10; ++j) {
                String[] nodes = CacheTest.nodes[j];
                service.submit(() -> {
                    for (int i = 0; i < 100000; ++i) {
                        CachedPubSubRepository.NodeKey key = new CachedPubSubRepository.NodeKey(serviceJid, nodes[i]);
                        this.sleep();
                        map.put(key, String.valueOf(i));
                        map.get(key);
                    }
                });
            }
            service.shutdown();
            while (!service.isTerminated()) {
                service.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            long end = System.currentTimeMillis();
            System.out.println("sized done in:" + (end - start) + "ms, size:" + cache.size());
            cache.everyMinute();
            StatisticsList list = new StatisticsList(Level.FINEST);
            cache.getStatistics("tmp", list);
            System.out.println(list.toString());
            avgTime += end - start;
        }
        System.out.println("avg sized done in:" + avgTime / 3L + "ms");
    }

    private void sleep() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

