/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.kernel.core.Kernel;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.PubSubLogic;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;
import tigase.xmpp.rsm.RSM;

public class CachedPubSubRepositoryTest {
    private Kernel kernel;

    @Before
    public void setUp() {
        this.kernel = new Kernel();
    }

    @After
    public void tearDown() {
        this.kernel = null;
    }

    @Test
    public void test_lazyLoadingOfRootCollections() throws Exception {
        String node;
        DummyPubSubDAO dao = new DummyPubSubDAO();
        dao.withDelay = true;
        CachedPubSubRepository cachedPubSubRepository = this.createCachedPubSubRepository(dao);
        this.setDelayedRootCollectionLoading(cachedPubSubRepository, true);
        BareJID serviceJid = BareJID.bareJIDInstanceNS((String)("pubsub." + UUID.randomUUID() + ".local"));
        Object[] nodes = new String[10];
        for (int i = 0; i < 10; ++i) {
            node = "node-" + UUID.randomUUID().toString();
            nodes[i] = node;
            dao.createNode(serviceJid, node, serviceJid, null, NodeType.leaf, null, true);
        }
        try {
            String[] result = cachedPubSubRepository.getRootCollection(serviceJid);
            Assert.assertFalse((boolean)true);
        }
        catch (CachedPubSubRepository.RootCollectionSet.IllegalStateException ex) {
            Assert.assertTrue((boolean)true);
        }
        for (int i = 0; i < 2; ++i) {
            dao.rootCollections.get(serviceJid).remove(nodes[i]);
            cachedPubSubRepository.removeFromRootCollection(serviceJid, (String)nodes[i]);
            node = "node-" + UUID.randomUUID().toString();
            nodes[i] = node;
            cachedPubSubRepository.addToRootCollection(serviceJid, node);
        }
        Arrays.sort(nodes);
        Thread.sleep(1000L);
        Object[] result = cachedPubSubRepository.getRootCollection(serviceJid);
        Arrays.sort(result);
        Assert.assertArrayEquals((Object[])nodes, (Object[])result);
    }

    @Test
    public void test_eagerLoadingOfRootCollections() throws Exception {
        DummyPubSubDAO dao = new DummyPubSubDAO();
        dao.withDelay = true;
        CachedPubSubRepository cachedPubSubRepository = this.createCachedPubSubRepository(dao);
        BareJID serviceJid = BareJID.bareJIDInstanceNS((String)("pubsub." + UUID.randomUUID() + ".local"));
        Object[] nodes = new String[10];
        for (int i = 0; i < 10; ++i) {
            String node = "node-" + UUID.randomUUID().toString();
            nodes[i] = node;
            dao.createNode(serviceJid, node, serviceJid, null, NodeType.leaf, null, true);
        }
        Arrays.sort(nodes);
        new Thread(() -> CachedPubSubRepositoryTest.lambda$test_eagerLoadingOfRootCollections$0(cachedPubSubRepository, serviceJid, (String[])nodes));
        Object[] result = cachedPubSubRepository.getRootCollection(serviceJid);
        Arrays.sort(result);
        Assert.assertArrayEquals((Object[])nodes, (Object[])result);
    }

    @Test
    public void test_userRemoved_lazy() throws Exception {
        DummyPubSubDAO dao = new DummyPubSubDAO();
        dao.withDelay = true;
        CachedPubSubRepository cachedPubSubRepository = this.createCachedPubSubRepository(dao);
        this.setDelayedRootCollectionLoading(cachedPubSubRepository, true);
        BareJID serviceJid = BareJID.bareJIDInstanceNS((String)("pubsub." + UUID.randomUUID() + ".local"));
        String[] nodes = new String[10];
        for (int i = 0; i < 10; ++i) {
            String node = "node-" + UUID.randomUUID().toString();
            nodes[i] = node;
            dao.createNode(serviceJid, node, serviceJid, null, NodeType.leaf, null, true);
        }
        try {
            cachedPubSubRepository.getRootCollection(serviceJid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)10L, (long)cachedPubSubRepository.getRootCollection(serviceJid).length);
        cachedPubSubRepository.deleteService(serviceJid);
        try {
            cachedPubSubRepository.getRootCollection(serviceJid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)cachedPubSubRepository.getRootCollection(serviceJid).length);
        Assert.assertNull((Object)dao.getChildNodes(serviceJid, null));
    }

    @Test
    public void test_userRemoved_eager() throws Exception {
        DummyPubSubDAO dao = new DummyPubSubDAO();
        dao.withDelay = true;
        CachedPubSubRepository cachedPubSubRepository = this.createCachedPubSubRepository(dao);
        BareJID serviceJid = BareJID.bareJIDInstanceNS((String)("pubsub." + UUID.randomUUID() + ".local"));
        String[] nodes = new String[10];
        for (int i = 0; i < 10; ++i) {
            String node = "node-" + UUID.randomUUID().toString();
            nodes[i] = node;
            dao.createNode(serviceJid, node, serviceJid, null, NodeType.leaf, null, true);
        }
        Assert.assertEquals((long)10L, (long)cachedPubSubRepository.getRootCollection(serviceJid).length);
        cachedPubSubRepository.deleteService(serviceJid);
        Assert.assertEquals((long)0L, (long)cachedPubSubRepository.getRootCollection(serviceJid).length);
        Assert.assertNull((Object)dao.getChildNodes(serviceJid, null));
    }

    protected CachedPubSubRepository createCachedPubSubRepository(PubSubDAO dao) {
        this.kernel.registerBean("pubsubDao").asInstance((Object)dao).exec();
        this.kernel.registerBean("logic").asInstance((Object)new PubSubLogic(){

            public boolean isServiceAutoCreated() {
                return true;
            }

            public void checkNodeConfig(AbstractNodeConfig nodeConfig) throws PubSubException {
            }

            public void checkPermission(BareJID serviceJid, String nodeName, JID senderJid, PubSubLogic.Action action) throws PubSubException, RepositoryException {
            }

            public Stream<JID> subscribersOfNotifications(BareJID serviceJid, String nodeName) throws RepositoryException {
                return null;
            }

            public boolean hasSenderSubscription(BareJID bareJid, IAffiliations affiliations) throws RepositoryException {
                return false;
            }

            public boolean isSenderInRosterGroup(BareJID bareJid, AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
                return false;
            }

            public Element prepareNotificationMessage(JID from, String id, String uuid, String nodeName, Element items, String expireAt, Map<String, String> headers, StanzaType stanzaType) {
                return null;
            }

            public boolean isServiceJidPEP(BareJID serivceJid) {
                return serivceJid.getLocalpart() != null;
            }

            public boolean isMAMEnabled(BareJID serviceJid, String node) throws RepositoryException {
                return false;
            }

            public String validateItemId(BareJID toJid, String nodeName, String id) {
                return null;
            }
        }).exec();
        this.kernel.registerBean("config").asInstance((Object)new PubSubConfig()).exec();
        this.kernel.registerBean("cachedRepository").asClass(CachedPubSubRepository.class).exec();
        return (CachedPubSubRepository)this.kernel.getInstance(CachedPubSubRepository.class);
    }

    protected void setDelayedRootCollectionLoading(CachedPubSubRepository cachedPubSubRepository, boolean value) throws NoSuchFieldException, IllegalAccessException {
        Field f = CachedPubSubRepository.class.getDeclaredField("delayedRootCollectionLoading");
        f.setAccessible(true);
        f.set(cachedPubSubRepository, value);
    }

    private static /* synthetic */ void lambda$test_eagerLoadingOfRootCollections$0(CachedPubSubRepository cachedPubSubRepository, BareJID serviceJid, String[] nodes) {
        try {
            Object[] result = cachedPubSubRepository.getRootCollection(serviceJid);
            Assert.assertArrayEquals((Object[])nodes, (Object[])result);
        }
        catch (Exception ex) {
            Assert.assertFalse((boolean)true);
        }
    }

    public static class DummyPubSubDAO
    extends PubSubDAO {
        protected Map<BareJID, Set<String>> rootCollections = new ConcurrentHashMap<BareJID, Set<String>>();
        protected boolean withDelay;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, Object collectionId, boolean autocreateService) throws RepositoryException {
            Map<BareJID, Set<String>> map = this.rootCollections;
            synchronized (map) {
                Set nodes = this.rootCollections.computeIfAbsent(serviceJid, bareJID -> new HashSet());
                nodes.add(nodeName);
            }
            return null;
        }

        public void createService(BareJID serviceJID, boolean isPublic) throws RepositoryException {
        }

        public List<BareJID> getServices(BareJID domain, Boolean isPublic) throws RepositoryException {
            return null;
        }

        public void deleteItem(BareJID serviceJid, Object nodeId, String id) throws RepositoryException {
        }

        public void deleteNode(BareJID serviceJid, Object nodeId) throws RepositoryException {
        }

        public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
            return new String[0];
        }

        public IItems.IItem getItem(BareJID serviceJid, Object nodeId, String id) throws RepositoryException {
            return null;
        }

        public List<MAMRepository.Item> getItems(BareJID serviceJid, List nodeIds, Date after, Date before, RSM rsm, CollectionItemsOrdering ordering) throws RepositoryException {
            return null;
        }

        public String[] getItemsIds(BareJID serviceJid, Object nodeId, CollectionItemsOrdering order) throws RepositoryException {
            return new String[0];
        }

        public String[] getItemsIdsSince(BareJID serviceJid, Object nodeId, CollectionItemsOrdering order, Date since) throws RepositoryException {
            return new String[0];
        }

        public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, Object nodeId, String nodeName) throws RepositoryException {
            return null;
        }

        public Map<BareJID, UsersAffiliation> getNodeAffiliations(BareJID serviceJid, Object nodeId) throws RepositoryException {
            return null;
        }

        public INodeMeta getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
            return null;
        }

        public long getNodesCount(BareJID serviceJid) throws RepositoryException {
            return 0L;
        }

        public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
            return new String[0];
        }

        public Map<BareJID, UsersSubscription> getNodeSubscriptions(BareJID serviceJid, Object nodeId) throws RepositoryException {
            return null;
        }

        public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
            Set<String> nodes = this.rootCollections.get(serviceJid);
            this.sleep();
            return nodes == null ? null : nodes.toArray(new String[nodes.size()]);
        }

        public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
            return null;
        }

        public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
            return null;
        }

        public void addMAMItem(BareJID serviceJid, Object nodeId, String uuid, Element itemData, String itemId) throws RepositoryException {
        }

        public void queryItems(Query query, Object nodeId, MAMRepository.ItemHandler itemHandler) throws RepositoryException, ComponentException {
        }

        public void deleteService(BareJID serviceJid) throws RepositoryException {
            this.rootCollections.remove(serviceJid);
        }

        public void removeNodeSubscription(BareJID serviceJid, Object nodeId, BareJID jid) throws RepositoryException {
        }

        public void updateNodeConfig(BareJID serviceJid, Object nodeId, String serializedData, Object collectionId) throws RepositoryException {
        }

        public void updateNodeAffiliation(BareJID serviceJid, Object nodeId, String nodeName, UsersAffiliation userAffiliation) throws RepositoryException {
        }

        public void updateNodeSubscription(BareJID serviceJid, Object nodeId, String nodeName, UsersSubscription userSubscription) throws RepositoryException {
        }

        public void writeItem(BareJID serviceJid, Object nodeId, long timeInMilis, String id, String publisher, Element item, String uuid) throws RepositoryException {
        }

        public void setDataSource(DataSource dataSource) {
        }

        protected void sleep() {
            if (!this.withDelay) {
                return;
            }
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException ex) {
                Assert.assertFalse((boolean)true);
            }
        }
    }
}

