/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.exceptions.RepositoryException;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.PubSubLogic;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="logic", parent=PubSubComponent.class, active=true)
public class DefaultPubSubLogic
implements PubSubLogic {
    @Inject
    private EventBus eventBus;
    @Inject(bean="service")
    private PubSubComponent component;
    @Inject
    private IPubSubConfig pubSubConfig;
    @Inject
    private IPubSubRepository repository;
    @Inject
    private PresenceCollectorModule presenceCollectorModule;
    @Inject
    private XsltTool xslTransformer;
    private static final Logger log = Logger.getLogger(DefaultPubSubLogic.class.getCanonicalName());

    @Override
    public void checkPermission(BareJID serviceJid, String nodeName, JID senderJid, PubSubLogic.Action action) throws PubSubException, RepositoryException {
        if (nodeName == null || nodeName.isEmpty()) {
            if (this.isServiceJidPEP(serviceJid) && !serviceJid.equals((Object)senderJid.getBareJID())) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            return;
        }
        AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(serviceJid, nodeName);
        if (nodeConfig == null) {
            if (action == PubSubLogic.Action.publishItems && this.isServiceJidPEP(serviceJid)) {
                return;
            }
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (this.pubSubConfig.isAdmin(senderJid)) {
            return;
        }
        if (nodeConfig.getNodeAccessModel() == AccessModel.open && !Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains())) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(serviceJid, nodeName);
        UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID());
        if (senderAffiliation.getAffiliation() == Affiliation.outcast) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        switch (action) {
            case subscribe: {
                if (!senderAffiliation.getAffiliation().isSubscribe()) {
                    throw new PubSubException(Authorization.FORBIDDEN, "Not enough privileges to subscribe");
                }
                Subscription subscription = this.repository.getNodeSubscriptions(serviceJid, nodeName).getSubscription(senderJid.getBareJID());
                if (subscription != null && subscription == Subscription.pending && !this.getPubSubConfig().isAdmin(senderJid) && senderAffiliation.getAffiliation() != Affiliation.owner) {
                    throw new PubSubException(Authorization.FORBIDDEN, PubSubErrorCondition.PENDING_SUBSCRIPTION, "Subscription is pending");
                }
                switch (nodeConfig.getNodeAccessModel()) {
                    case presence: {
                        if (this.hasSenderSubscription(senderJid.getBareJID(), nodeAffiliations)) break;
                        throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.PRESENCE_SUBSCRIPTION_REQUIRED);
                    }
                    case roster: {
                        if (this.isSenderInRosterGroup(senderJid.getBareJID(), nodeConfig, nodeAffiliations, this.repository.getNodeSubscriptions(serviceJid, nodeName))) break;
                        throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_IN_ROSTER_GROUP);
                    }
                    case whitelist: {
                        switch (senderAffiliation.getAffiliation()) {
                            case none: 
                            case outcast: {
                                throw new PubSubException(Authorization.NOT_ALLOWED, PubSubErrorCondition.CLOSED_NODE);
                            }
                        }
                    }
                }
                break;
            }
            case retrieveItems: {
                switch (nodeConfig.getNodeAccessModel()) {
                    case open: {
                        break;
                    }
                    case whitelist: {
                        if (senderAffiliation.getAffiliation().isRetrieveItem()) break;
                        throw new PubSubException(Authorization.NOT_ALLOWED, PubSubErrorCondition.CLOSED_NODE);
                    }
                    case authorize: {
                        Subscription senderSubscription = this.repository.getNodeSubscriptions(serviceJid, nodeName).getSubscription(senderJid.getBareJID());
                        if (senderSubscription == Subscription.subscribed && senderAffiliation.getAffiliation().isRetrieveItem()) break;
                        throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_SUBSCRIBED);
                    }
                    case presence: {
                        if (this.hasSenderSubscription(senderJid.getBareJID(), nodeAffiliations)) break;
                        throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.PRESENCE_SUBSCRIPTION_REQUIRED);
                    }
                    case roster: {
                        boolean allowed = this.isSenderInRosterGroup(senderJid.getBareJID(), nodeConfig, nodeAffiliations, this.repository.getNodeSubscriptions(serviceJid, nodeName));
                        if (allowed) break;
                        throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_IN_ROSTER_GROUP);
                    }
                }
                break;
            }
            case retractItems: {
                if (senderAffiliation.getAffiliation().isDeleteItem()) break;
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            case publishItems: {
                if (senderAffiliation.getAffiliation().isPublishItem()) break;
                switch (nodeConfig.getPublisherModel()) {
                    case open: {
                        break;
                    }
                    case publishers: {
                        throw new PubSubException(Authorization.FORBIDDEN);
                    }
                    case subscribers: {
                        if (this.repository.getNodeSubscriptions(serviceJid, nodeName).getSubscription(senderJid.getBareJID()) == Subscription.subscribed) break;
                        throw new PubSubException(Authorization.FORBIDDEN);
                    }
                }
                break;
            }
            case purgeNode: {
                switch (senderAffiliation.getAffiliation()) {
                    case publisher: 
                    case owner: {
                        break;
                    }
                    default: {
                        throw new PubSubException(Authorization.FORBIDDEN);
                    }
                }
            }
            case manageNode: {
                if (senderAffiliation.getAffiliation() == Affiliation.owner) break;
                throw new PubSubException(Authorization.FORBIDDEN);
            }
        }
    }

    @Override
    public Element prepareNotificationMessage(JID from, String id, String uuid, String nodeName, Element items, String expireAt, Map<String, String> headers, StanzaType stanzaType) {
        Element message = new Element("message", new String[]{"xmlns", "from", "id"}, new String[]{"jabber:client", from.toString(), id});
        if (stanzaType != null && stanzaType != StanzaType.normal) {
            message.setAttribute("type", stanzaType.name());
        }
        Element event = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
        if (uuid != null) {
            message.addChild((XMLNodeIfc)new Element("stanza-id", new String[]{"xmlns", "id", "by"}, new String[]{"urn:xmpp:sid:0", uuid, from.getBareJID().toString()}));
        }
        event.addChild((XMLNodeIfc)items);
        if (expireAt != null) {
            Element amp = new Element("amp");
            amp.setXMLNS("http://jabber.org/protocol/amp");
            amp.addChild((XMLNodeIfc)new Element("rule", new String[]{"condition", "action", "value"}, new String[]{"expire-at", "drop", expireAt}));
            message.addChild((XMLNodeIfc)amp);
        }
        message.addChild((XMLNodeIfc)event);
        if (headers != null && headers.size() > 0) {
            Element headElem = new Element("headers", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/shim"});
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                Element h = new Element("header", entry.getValue(), new String[]{"name"}, new String[]{entry.getKey()});
                headElem.addChild((XMLNodeIfc)h);
            }
            message.addChild((XMLNodeIfc)headElem);
        }
        try {
            List itemsToSend;
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(from.getBareJID(), nodeName);
            if (this.xslTransformer != null && nodeConfig != null && (itemsToSend = items.getChildren(el -> el.getName() == "item")) != null) {
                for (Element itemToSend : itemsToSend) {
                    try {
                        List<Element> elems = this.xslTransformer.transform(itemToSend, nodeConfig);
                        if (elems == null) continue;
                        message.addChildren(elems);
                    }
                    catch (Exception e) {
                        log.log(Level.WARNING, "Problem with generating BODY", e);
                    }
                }
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return message;
    }

    @Override
    public boolean isServiceAutoCreated() {
        return true;
    }

    @Override
    public void checkNodeConfig(AbstractNodeConfig nodeConfig) throws PubSubException {
    }

    @Override
    public boolean hasSenderSubscription(BareJID bareJid, IAffiliations affiliations) throws RepositoryException {
        for (UsersAffiliation affiliation : affiliations.getAffiliations()) {
            if (affiliation.getAffiliation() != Affiliation.owner) continue;
            if (bareJid.equals((Object)affiliation.getJid())) {
                return true;
            }
            Map<BareJID, RosterElement> buddies = this.repository.getUserRoster(affiliation.getJid());
            RosterElement re = buddies.get(bareJid);
            if (re == null || re.getSubscription() != RosterAbstract.SubscriptionType.both && re.getSubscription() != RosterAbstract.SubscriptionType.from && re.getSubscription() != RosterAbstract.SubscriptionType.from_pending_out) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSenderInRosterGroup(BareJID bareJid, AbstractNodeConfig nodeConfig, IAffiliations affiliations, ISubscriptions subscriptions) throws RepositoryException {
        Stream<BareJID> subscribers = subscriptions.getSubscriptions().map(UsersSubscription::getJid);
        String[] groupsAllowed = nodeConfig.getRosterGroupsAllowed();
        if (groupsAllowed == null || groupsAllowed.length == 0) {
            return true;
        }
        List owners = subscribers.filter(owner -> affiliations.getSubscriberAffiliation((BareJID)owner).getAffiliation() == Affiliation.owner).collect(Collectors.toList());
        if (owners.contains(bareJid)) {
            return true;
        }
        for (BareJID owner2 : owners) {
            Map<BareJID, RosterElement> buddies = this.repository.getUserRoster(owner2);
            RosterElement re = buddies.get(bareJid);
            if (re == null || re.getGroups() == null) continue;
            for (String group : groupsAllowed) {
                if (!Utils.contain(group, groupsAllowed)) continue;
                return true;
            }
        }
        return false;
    }

    protected Stream<JID> getActiveSubscribers(ISubscriptions subscriptions, IAffiliations affiliations) {
        if (subscriptions == null) {
            return Stream.empty();
        }
        Stream<UsersSubscription> stream = subscriptions.getSubscriptionsForPublish();
        return stream.filter(subscription -> subscription.getSubscription() == Subscription.subscribed).map(UsersSubscription::getJid).filter(jid -> affiliations.getSubscriberAffiliation((BareJID)jid).getAffiliation() != Affiliation.outcast).map(JID::jidInstance);
    }

    @Override
    public Stream<JID> subscribersOfNotifications(BareJID serviceJid, String nodeName) throws RepositoryException {
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJid, nodeName);
        if (nodeConfig == null) {
            return Stream.empty();
        }
        IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(serviceJid, nodeName);
        ISubscriptions nodesSubscriptions = this.getRepository().getNodeSubscriptions(serviceJid, nodeName);
        Stream<Object> stream = this.getActiveSubscribers(nodesSubscriptions, nodeAffiliations);
        if (nodeConfig.isPresenceExpired()) {
            AtomicBoolean updateSubscriptions = new AtomicBoolean(false);
            JID[] filtered = (JID[])stream.filter(jid -> {
                boolean available = this.presenceCollectorModule.isJidAvailable(serviceJid, jid.getBareJID());
                UsersAffiliation afi = nodeAffiliations.getSubscriberAffiliation(jid.getBareJID());
                if (afi == null || !available && afi.getAffiliation() == Affiliation.member) {
                    nodesSubscriptions.changeSubscription(jid.getBareJID(), Subscription.none);
                    updateSubscriptions.set(true);
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Subscriptione expired. Node: " + nodeConfig.getNodeName() + ", jid: " + jid);
                    }
                    return false;
                }
                return true;
            }).toArray(JID[]::new);
            if (updateSubscriptions.get()) {
                this.getRepository().update(serviceJid, nodeConfig.getNodeName(), nodesSubscriptions);
            }
            stream = Arrays.stream(filtered);
        }
        if (nodeConfig.isDeliverPresenceBased()) {
            stream = stream.flatMap(jid -> this.presenceCollectorModule.getAllAvailableResources(serviceJid, jid.getBareJID()).stream());
            boolean pep = this.isServiceJidPEP(serviceJid);
            if (pep || this.getPubSubConfig().isSubscribeByPresenceFilteredNotifications()) {
                switch (nodeConfig.getNodeAccessModel()) {
                    case presence: 
                    case open: {
                        stream = Stream.concat(stream, this.presenceCollectorModule.getAllAvailableJidsWithFeature(serviceJid, nodeConfig.getNodeName() + "+notify").stream());
                        break;
                    }
                    case roster: {
                        Object[] allowedGroups = nodeConfig.getRosterGroupsAllowed();
                        if (allowedGroups == null || allowedGroups.length <= 0) break;
                        Arrays.sort(allowedGroups);
                        List<JID> jids = this.presenceCollectorModule.getAllAvailableJidsWithFeature(serviceJid, nodeConfig.getNodeName() + "+notify");
                        if (jids.isEmpty()) break;
                        Map<BareJID, RosterElement> roster = this.getRepository().getUserRoster(serviceJid);
                        stream = Stream.concat(stream, jids.stream().filter(arg_0 -> DefaultPubSubLogic.lambda$subscribersOfNotifications$8(roster, (String[])allowedGroups, arg_0)));
                        break;
                    }
                }
            }
            if (pep) {
                stream = Stream.concat(this.presenceCollectorModule.getAllAvailableJidsWithFeature(serviceJid, nodeConfig.getNodeName() + "+notify").stream().filter(jid -> jid.getBareJID().equals((Object)serviceJid)), stream);
            }
        }
        return stream;
    }

    @Override
    public boolean isMAMEnabled(BareJID serviceJid, String node) throws RepositoryException {
        if (this.pubSubConfig.isMAMEnabled()) {
            if (this.pubSubConfig.isMAMEnabledForGenericService()) {
                return true;
            }
            if (this.isServiceJidPEP(serviceJid)) {
                return true;
            }
        }
        return false;
    }

    protected IPubSubConfig getPubSubConfig() {
        return this.pubSubConfig;
    }

    protected IPubSubRepository getRepository() {
        return this.repository;
    }

    @Override
    public boolean isServiceJidPEP(BareJID serivceJid) {
        return this.pubSubConfig.isPepPeristent() && serivceJid.getLocalpart() != null && !serivceJid.getDomain().startsWith(this.component.getName() + ".");
    }

    @Override
    public String validateItemId(BareJID toJid, String nodeName, String id) {
        if (id != null) {
            return id;
        }
        return Utils.createUID();
    }

    private static /* synthetic */ boolean lambda$subscribersOfNotifications$8(Map roster, String[] allowedGroups, JID jid) {
        RosterElement re = (RosterElement)roster.get(jid.getBareJID());
        return re != null && re.getGroups() != null && Arrays.stream(re.getGroups()).anyMatch(group -> Arrays.binarySearch(allowedGroups, group) < 0);
    }
}

