/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Stream;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.cached.ISubscriptionsCached;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xmpp.jid.BareJID;

public class NodeSubscriptions
extends tigase.pubsub.repository.NodeSubscriptions
implements ISubscriptionsCached {
    protected final ThreadLocal<Map<BareJID, UsersSubscription>> changedSubs = new ThreadLocal();

    public NodeSubscriptions() {
    }

    public NodeSubscriptions(Map<BareJID, UsersSubscription> subscriptions) {
        super(subscriptions);
    }

    @Override
    public String addSubscriberJid(BareJID bareJid, Subscription subscription) {
        String subid = Utils.createUID(bareJid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        this.changedSubs().put(bareJid, s);
        return subid;
    }

    @Override
    public void changeSubscription(BareJID bareJid, Subscription subscription) {
        UsersSubscription s = (UsersSubscription)this.subs.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
            this.changedSubs().put(s.getJid(), s);
        }
    }

    @Override
    public void changeSubscription(UsersSubscription subscription) {
        this.changedSubs().put(subscription.getJid(), subscription);
    }

    @Override
    public Map<BareJID, UsersSubscription> getChanged() {
        return Collections.unmodifiableMap(this.changedSubs());
    }

    @Override
    public Stream<UsersSubscription> getSubscriptions() {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.subs.values());
        result.addAll(this.changedSubs().values());
        return result.stream();
    }

    @Override
    public boolean isChanged() {
        return this.changedSubs().size() > 0;
    }

    @Override
    public void merge() {
        Map<BareJID, UsersSubscription> changedSubs = this.changedSubs();
        for (Map.Entry<BareJID, UsersSubscription> entry : changedSubs.entrySet()) {
            if (entry.getValue().getSubscription() == Subscription.none) {
                this.subs.remove(entry.getKey());
                continue;
            }
            this.subs.put(entry.getKey(), entry.getValue());
        }
        changedSubs.clear();
    }

    @Override
    public void resetChangedFlag() {
        this.changedSubs().clear();
    }

    @Override
    protected UsersSubscription get(BareJID bareJid) {
        UsersSubscription us = null;
        us = this.changedSubs().get(bareJid);
        if (us == null && (us = (UsersSubscription)this.subs.get(bareJid)) != null) {
            try {
                return us.clone();
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Cloning failed, us: " + us, e);
                return null;
            }
        }
        return us;
    }

    private Map<BareJID, UsersSubscription> changedSubs() {
        Map<BareJID, UsersSubscription> changedSubs = this.changedSubs.get();
        if (changedSubs == null) {
            changedSubs = new HashMap<BareJID, UsersSubscription>();
            this.changedSubs.set(changedSubs);
        }
        return changedSubs;
    }
}

