/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.ext.presence;

import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.ext.presence.PresencePerNodeExtension;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="presenceNotifierModule", parent=PubSubComponent.class, active=false)
public class PresenceNotifierModule
extends AbstractPubSubModule
implements Initializable,
UnregisterAware {
    @Inject
    private EventBus eventBus;
    @Inject
    private PresencePerNodeExtension presencePerNodeExtension;
    @Inject
    private PublishItemModule publishItemModule;

    public String[] getFeatures() {
        return new String[]{"tigase:pubsub:1"};
    }

    public Criteria getModuleCriteria() {
        return null;
    }

    public PresencePerNodeExtension getPresencePerNodeExtension() {
        return this.presencePerNodeExtension;
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
    }

    @HandleEvent
    public void onLoginToNode(PresencePerNodeExtension.LoginToNodeEvent event) {
        if (!event.componentName.equals(this.config.getComponentName())) {
            return;
        }
        this.onLoginToNode(event.serviceJID, event.node, event.occupantJID, event.presenceStanza);
    }

    @HandleEvent
    public void onLogoffFromNodeH(PresencePerNodeExtension.LogoffFromNodeEvent event) {
        if (!event.componentName.equals(this.config.getComponentName())) {
            return;
        }
        this.onLogoffFromNode(event.serviceJID, event.node, event.occupantJID, event.presenceStanza);
    }

    @HandleEvent
    public void onUpdatePresence(PresencePerNodeExtension.UpdatePresenceEvent event) {
        if (!event.componentName.equals(this.config.getComponentName())) {
            return;
        }
        this.onPresenceUpdate(event.serviceJID, event.node, event.occupantJID, event.presenceStanza);
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    protected Element createPresenceNotificationItem(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
        Element notification = new Element("presence");
        notification.setAttribute("xmlns", "tigase:pubsub:1");
        notification.setAttribute("node", node);
        notification.setAttribute("jid", occupantJID.toString());
        if (presenceStanza == null || presenceStanza.getType() == StanzaType.unavailable) {
            notification.setAttribute("type", "unavailable");
        } else if (presenceStanza.getType() == StanzaType.available) {
            notification.setAttribute("type", "available");
        }
        return notification;
    }

    protected void onLoginToNode(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
        try {
            Element notification = this.createPresenceNotificationItem(serviceJID, node, occupantJID, presenceStanza);
            this.publish(serviceJID, node, notification);
            this.publishToOne(serviceJID, node, occupantJID);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem on sending LoginToNodeEvent", e);
        }
    }

    protected void onLogoffFromNode(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
        try {
            Element notification = this.createPresenceNotificationItem(serviceJID, node, occupantJID, presenceStanza);
            this.publish(serviceJID, node, notification);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem on sending LogoffFromNodeEvent", e);
        }
    }

    protected void onPresenceUpdate(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
    }

    protected void publish(BareJID serviceJID, String nodeName, Element itemToSend) throws RepositoryException {
        Element item = new Element("item");
        item.addChild((XMLNodeIfc)itemToSend);
        this.publishItemModule.generateItemsNotifications(serviceJID, nodeName, Collections.singletonList(item), null, false);
    }

    protected void publishToOne(BareJID serviceJID, String nodeName, JID destinationJID) throws RepositoryException {
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJID, nodeName);
        Collection<JID> occupants = this.presencePerNodeExtension.getNodeOccupants(serviceJID, nodeName);
        if (occupants.contains(destinationJID)) {
            Packet p = this.presencePerNodeExtension.getPresence(serviceJID, nodeName, destinationJID);
            if (p == null) {
                return;
            }
            Element item = new Element("item");
            item.addChild((XMLNodeIfc)this.createPresenceNotificationItem(serviceJID, nodeName, destinationJID, p));
            this.publishItemModule.sendNotification(serviceJID, nodeName, item, null, null, destinationJID, StanzaType.headline);
        }
    }
}

