/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Queue;
import java.util.logging.Level;
import javax.script.Bindings;
import tigase.component.AbstractKernelBasedComponent;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.component.modules.impl.XmppPingModule;
import tigase.conf.Configurable;
import tigase.db.UserRepository;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.pubsub.IPubSubConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.modules.commands.DefaultConfigCommand;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.stats.StatisticHolder;
import tigase.stats.StatisticsList;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.mam.modules.GetFormModule;

@Bean(name="pubsub", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
@ClusterModeRequired(active=false)
public class PubSubComponent
extends AbstractKernelBasedComponent
implements Configurable,
DisableDisco {
    public static final String DEFAULT_LEAF_NODE_CONFIG_KEY = "default-node-config";
    public static final String EVENT_XMLNS = "tigase:events:pubsub";
    private static final String COMPONENT = "component";
    @Inject(bean="defaultNodeConfig")
    protected LeafNodeConfig defaultNodeConfig;
    protected Integer maxRepositoryCacheSize;
    @Inject
    private IPubSubRepository pubsubRepository;
    @Inject
    private PacketHashCodeGenerator packetHashCodeGenerator;
    private XsltTool xslTransformer;

    public void everyHour() {
        super.everyHour();
        if (this.pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)this.pubsubRepository).everyHour();
        }
    }

    public void everyMinute() {
        super.everyMinute();
        if (this.pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)this.pubsubRepository).everyMinute();
        }
    }

    public void everySecond() {
        super.everySecond();
        if (this.pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)this.pubsubRepository).everySecond();
        }
    }

    public String getComponentVersion() {
        String version = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    public String getDiscoCategory() {
        return "pubsub";
    }

    public String getDiscoCategoryType() {
        return "service";
    }

    public String getDiscoDescription() {
        return "PubSub";
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        IPubSubRepository pubsubRepository = (IPubSubRepository)this.kernel.getInstance(IPubSubRepository.class);
        if (pubsubRepository instanceof StatisticHolder) {
            ((StatisticHolder)pubsubRepository).getStatistics(this.getName(), list);
        }
    }

    public int hashCodeForPacket(Packet packet) {
        return this.packetHashCodeGenerator.hashCodeForPacket(packet);
    }

    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(COMPONENT, (Object)this);
    }

    public boolean isDiscoNonAdmin() {
        return true;
    }

    public boolean isSubdomain() {
        return true;
    }

    @HandleEvent
    public void onChangeDefaultNodeConfig(DefaultConfigCommand.DefaultNodeConfigurationChangedEvent event) {
        if (!event.componentName.equals(this.getName())) {
            return;
        }
        try {
            IPubSubConfig componentConfig = (IPubSubConfig)this.kernel.getInstance(IPubSubConfig.class);
            UserRepository userRepository = (UserRepository)this.kernel.getInstance(UserRepository.class);
            this.defaultNodeConfig.read(userRepository, componentConfig, DEFAULT_LEAF_NODE_CONFIG_KEY);
            this.log.info("Node " + this.getComponentId() + " read default node configuration.");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Reading default config error", e);
        }
    }

    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public void processPacket(Packet packet) {
        if (!this.checkPubSubServiceJid(packet)) {
            return;
        }
        super.processPacket(packet);
    }

    public boolean processScriptCommand(Packet pc, Queue<Packet> results) {
        if (!this.checkPubSubServiceJid(pc)) {
            return true;
        }
        return super.processScriptCommand(pc, results);
    }

    public void setName(String name) {
        super.setName(name);
    }

    public void setPubsubRepository(IPubSubRepository pubsubRepository) {
        this.pubsubRepository = pubsubRepository;
    }

    public void start() {
        super.start();
        this.eventBus.registerAll((Object)this);
    }

    public void stop() {
        super.stop();
        this.eventBus.unregisterAll((Object)this);
    }

    @HandleEvent
    public void onUserRemoved(UserRepository.UserRemovedEvent event) {
        try {
            IPubSubRepository pubsubRepository = (IPubSubRepository)this.kernel.getInstance(IPubSubRepository.class);
            pubsubRepository.deleteService(event.jid);
        }
        catch (RepositoryException ex) {
            this.log.log(Level.WARNING, "could not remove PubSub data for removed user " + event.jid, ex);
        }
    }

    protected void registerModules(Kernel kernel) {
        kernel.registerBean(AdHocCommandModule.class).exec();
        kernel.registerBean(JabberVersionModule.class).exec();
        kernel.registerBean(XmppPingModule.class).exec();
        kernel.registerBean(GetFormModule.class).exec();
    }

    protected boolean checkPubSubServiceJid(Packet packet) {
        if (packet.getStanzaTo() != null && this.getName().equals(packet.getStanzaTo().getLocalpart()) && packet.getType() != StanzaType.result) {
            try {
                Packet result = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, null, true);
                this.addOutPacket(result);
            }
            catch (PacketErrorTypeException ex) {
                this.log.log(Level.FINE, "Packet already of type=error, while preparing error response", ex);
            }
            return false;
        }
        return true;
    }

    public static interface PacketHashCodeGenerator {
        public int hashCodeForPacket(Packet var1);
    }
}

