/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DerbyPubSubDAOTest {
    private static final String uri = "jdbc:derby:memory:myDB;create=true";
    private static Connection[] connections;
    private static PreparedStatement[] preparedStatements;

    @Ignore
    @Test
    public void test() throws SQLException, InterruptedException {
        connections = new Connection[10];
        for (int i = 0; i < 10; ++i) {
            DerbyPubSubDAOTest.connections[i] = DriverManager.getConnection(uri);
        }
        Statement stmt = connections[0].createStatement();
        stmt.execute("create table tig_pubsub_jids (\n\tjid_id bigint generated by default as identity not null,\n\tjid varchar(2049) not null,\n\tjid_sha1 varchar(50),\n\n\tprimary key ( jid_id )\n)");
        stmt.execute("create table tig_pubsub_items (\n\tnode_id bigint not null,\n\tid varchar(1024) not null,\n\tcreation_date timestamp,\n\tpublisher_id bigint references tig_pubsub_jids ( jid_id ),\n\tupdate_date timestamp,\n\tdata varchar(32672),\n\n\tprimary key ( node_id, id )\n)");
        stmt.execute("create procedure TigPubSubWriteItem(node_id bigint, item_id varchar(1024),\n\tpublisher varchar(2049), item_data varchar(32672), ts timestamp)\n\tPARAMETER STYLE JAVA\n\tLANGUAGE JAVA\n\tMODIFIES SQL DATA\n\tDYNAMIC RESULT SETS 1\n\tEXTERNAL NAME 'tigase.pubsub.repository.derby.StoredProcedures.tigPubSubWriteItem'");
        stmt.close();
        preparedStatements = new PreparedStatement[connections.length];
        for (int i = 0; i < preparedStatements.length; ++i) {
            DerbyPubSubDAOTest.preparedStatements[i] = connections[i].prepareCall("{ call TigPubSubWriteItem(?, ?, ?, ?, ?) }");
        }
        ArrayList<1> tasks = new ArrayList<1>();
        for (int j = 0; j < 10; ++j) {
            final long nodeId = j;
            final String id = UUID.randomUUID().toString();
            String publisher = "publisher@test.com";
            String nodeItem = "item-" + j;
            for (int i = 0; i < preparedStatements.length; ++i) {
                final String item = nodeItem + "-" + i;
                final PreparedStatement write_item_sp = preparedStatements[i];
                tasks.add(new Callable<Exception>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Exception call() throws Exception {
                        try {
                            PreparedStatement preparedStatement = write_item_sp;
                            synchronized (preparedStatement) {
                                write_item_sp.setLong(1, nodeId);
                                write_item_sp.setString(2, id);
                                write_item_sp.setString(3, "publisher@test.com");
                                write_item_sp.setString(4, item);
                                write_item_sp.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                                System.out.println("executing query for " + item);
                                write_item_sp.execute();
                            }
                            return null;
                        }
                        catch (Exception ex) {
                            return ex;
                        }
                    }
                });
            }
        }
        ExecutorService executorService = Executors.newFixedThreadPool(connections.length);
        List futures = executorService.invokeAll(tasks);
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            System.out.println("awaiting termination...");
            Thread.sleep(1000L);
        }
        List list = futures.stream().map(f -> {
            try {
                return (Exception)f.get();
            }
            catch (Exception x) {
                return x;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        Assert.assertEquals((Object)Collections.EMPTY_LIST, list);
    }
}

