/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.xml.XMLRepository;
import tigase.kernel.core.Kernel;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.MAMRepository;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractPubSubDAOTest<DS extends DataSource>
extends AbstractDataSourceAwareTestCase<DS, IPubSubDAO> {
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    protected boolean checkEmoji = true;
    protected IPubSubDAO dao;
    private String nodeNameWithoutEmoji;
    private String nodeName = this.nodeNameWithoutEmoji = "test-node";
    private JID senderJid = JID.jidInstanceNS((String)"owner@tigase/tigase-1");
    private BareJID serviceJid = BareJID.bareJIDInstanceNS((String)"pubsub.tigase");
    private JID subscriberJid = JID.jidInstanceNS((String)"subscriber@tigase/tigase-1");

    @Before
    public void setup() throws RepositoryException, DBInitException, IllegalAccessException, InstantiationException {
        if (this.checkEmoji) {
            this.nodeName = this.nodeName + emoji;
        }
        this.dao = (IPubSubDAO)this.getDataSourceAware();
    }

    @After
    public void tearDown() {
        if (this.dao != null) {
            this.dao.destroy();
        }
        this.dao = null;
    }

    @Test
    public void test00_testNodesCount() throws RepositoryException {
        long value = this.dao.getNodesCount(null);
        Assert.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void test01_createNode() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        if (node != null) {
            this.dao.deleteNode(this.serviceJid, node.getNodeId());
        }
        LeafNodeConfig nodeCfg = new LeafNodeConfig(this.nodeName);
        this.dao.createNode(this.serviceJid, this.nodeName, this.senderJid.getBareJID(), (AbstractNodeConfig)nodeCfg, NodeType.leaf, null, true);
        node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not retrieve nodeId for newly created node", (Object)node);
    }

    @Test
    public void test02_subscribeNode() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        UsersSubscription subscr = new UsersSubscription(this.subscriberJid.getBareJID(), "sub-1", Subscription.subscribed);
        this.dao.updateNodeSubscription(this.serviceJid, node.getNodeId(), this.nodeName, subscr);
        Map nodeSubscr = this.dao.getNodeSubscriptions(this.serviceJid, node.getNodeId());
        Assert.assertNotNull((String)"Not found subscriptions for node", (Object)nodeSubscr);
        UsersSubscription usersSubscription = (UsersSubscription)nodeSubscr.get(this.subscriberJid.getBareJID());
        Assert.assertNotNull((Object)usersSubscription);
        Assert.assertEquals((String)"Bad subscription type for user", (Object)Subscription.subscribed, (Object)usersSubscription.getSubscription());
    }

    @Test
    public void test03_affiliateNode() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        UsersAffiliation affil = new UsersAffiliation(this.subscriberJid.getBareJID(), Affiliation.publisher);
        this.dao.updateNodeAffiliation(this.serviceJid, node.getNodeId(), this.nodeName, affil);
        Map nodeAffils = this.dao.getNodeAffiliations(this.serviceJid, node.getNodeId());
        Assert.assertNotNull((String)"Not found affiliations for node", (Object)nodeAffils);
        affil = (UsersAffiliation)nodeAffils.get(this.subscriberJid.getBareJID());
        Assert.assertNotNull((String)"Not found affiliation for user", (Object)affil);
        Affiliation affiliation = affil.getAffiliation();
        Assert.assertEquals((String)"Bad affiliation type for user", (Object)Affiliation.publisher, (Object)affiliation);
    }

    @Test
    public void test04_userSubscriptions() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        Map map = this.dao.getUserSubscriptions(this.serviceJid, this.subscriberJid.getBareJID());
        Assert.assertNotNull((String)"No subscriptions for user", (Object)map);
        UsersSubscription subscr = (UsersSubscription)map.get(this.nodeName);
        Assert.assertNotNull((String)"No subscription for user for node", (Object)subscr);
        Assert.assertEquals((String)"Bad subscription for user for node", (Object)Subscription.subscribed, (Object)subscr.getSubscription());
    }

    @Test
    public void test05_userAffiliations() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        Map map = this.dao.getUserAffiliations(this.serviceJid, this.subscriberJid.getBareJID());
        Assert.assertNotNull((String)"No affiliation for user", (Object)map);
        UsersAffiliation affil = (UsersAffiliation)map.get(this.nodeName);
        Assert.assertNotNull((String)"No affiliation for user for node", (Object)affil);
        Assert.assertEquals((String)"Bad affiliation for user for node", (Object)Affiliation.publisher, (Object)affil.getAffiliation());
    }

    @Test
    public void test06_allNodes() throws RepositoryException {
        Object[] allNodes = this.dao.getAllNodesList(this.serviceJid);
        Arrays.sort(allNodes);
        Assert.assertNotEquals((String)"Node name not listed in list of all root nodes", (long)-1L, (long)Arrays.binarySearch(allNodes, this.nodeName));
    }

    @Test
    public void test06_getNodeMeta() throws RepositoryException {
        INodeMeta meta = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((Object)meta);
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((Object)node.getNodeId(), (Object)meta.getNodeId());
        Assert.assertEquals((Object)this.nodeName, (Object)meta.getNodeConfig().getNodeName());
        Assert.assertEquals((Object)this.senderJid.getBareJID(), (Object)meta.getCreator());
        Assert.assertNotNull((Object)meta.getCreationTime());
    }

    @Test
    public void test07_nodeItems() throws RepositoryException {
        String itemId = "item-1";
        Element item = new Element("item", new String[]{"id"}, new String[]{itemId});
        Object payloadCData = "test-payload";
        if (this.checkEmoji) {
            payloadCData = (String)payloadCData + emoji;
        }
        item.addChild((XMLNodeIfc)new Element("payload", (String)payloadCData, new String[]{"xmlns"}, new String[]{"test-xmlns"}));
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        this.dao.writeItem(this.serviceJid, node.getNodeId(), System.currentTimeMillis(), itemId, this.nodeNameWithoutEmoji, item, null);
        Object[] itemsIds = this.dao.getItemsIds(this.serviceJid, node.getNodeId(), CollectionItemsOrdering.byUpdateDate);
        Assert.assertArrayEquals((String)"Added item id not listed in list of item ids", (Object[])new String[]{itemId}, (Object[])itemsIds);
        Element el = Optional.ofNullable(this.dao.getItem(this.serviceJid, node.getNodeId(), itemId)).map(IItems.IItem::getItem).orElse(null);
        Assert.assertEquals((String)"Element retrieved from store do not match to element added to store", (Object)item, (Object)el);
        this.dao.deleteItem(this.serviceJid, node.getNodeId(), itemId);
        el = Optional.ofNullable(this.dao.getItem(this.serviceJid, node.getNodeId(), itemId)).map(IItems.IItem::getItem).orElse(null);
        Assert.assertNull((String)"Element still available in store after removal", (Object)el);
    }

    @Test
    public void test09_subscribeNodeRemoval() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        UsersSubscription subscr = new UsersSubscription(this.subscriberJid.getBareJID(), "sub-1", Subscription.none);
        this.dao.updateNodeSubscription(this.serviceJid, node.getNodeId(), this.nodeName, subscr);
        Map nodeSubscr = this.dao.getNodeSubscriptions(this.serviceJid, node.getNodeId());
        Assert.assertNotNull((String)"Not found subscriptions for node", (Object)nodeSubscr);
        UsersSubscription subscription = (UsersSubscription)nodeSubscr.get(this.subscriberJid.getBareJID());
        Assert.assertEquals((String)"Bad subscription type for user", (Object)Subscription.none, (Object)subscription.getSubscription());
    }

    @Test
    public void test09_affiliateNodeRemoval() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        UsersAffiliation affil = new UsersAffiliation(this.subscriberJid.getBareJID(), Affiliation.none);
        this.dao.updateNodeAffiliation(this.serviceJid, node.getNodeId(), this.nodeName, affil);
        Map nodeAffils = this.dao.getNodeAffiliations(this.serviceJid, node.getNodeId());
        Assert.assertNotNull((String)"Not found affiliations for node", (Object)nodeAffils);
        affil = (UsersAffiliation)nodeAffils.get(this.subscriberJid.getBareJID());
        Assert.assertEquals((String)"Bad affiliation for user", (Object)Affiliation.none, (Object)Optional.ofNullable(affil).map(UsersAffiliation::getAffiliation).orElse(Affiliation.none));
    }

    @Test
    public void test09_servicesRetrieval() throws RepositoryException {
        List services = this.dao.getServices(BareJID.bareJIDInstanceNS((String)this.serviceJid.getDomain()), null);
        Assert.assertNotNull((Object)services);
        Assert.assertEquals(Arrays.asList(this.serviceJid), (Object)services);
    }

    @Test
    public void test10_nodeRemoval() throws RepositoryException {
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        this.dao.deleteNode(this.serviceJid, node.getNodeId());
        node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNull((String)"Node not removed", (Object)node);
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return IPubSubDAO.class;
    }

    @Test
    public void test08_queryNodeItems() throws RepositoryException, InterruptedException, ComponentException {
        MAMRepository.Item item2;
        int i;
        MAMRepository.Item item3;
        int i2;
        ArrayList<Element> publishedItems = new ArrayList<Element>();
        INodeMeta node = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)node);
        HashMap<CallSite, String> uuids = new HashMap<CallSite, String>();
        for (int i3 = 0; i3 < 20; ++i3) {
            String itemId = "item-" + i3;
            Object payloadCData = "test-payload";
            if (this.checkEmoji) {
                payloadCData = (String)payloadCData + emoji;
                itemId = itemId + emoji;
            }
            Element item4 = new Element("item", new String[]{"id"}, new String[]{itemId});
            item4.addChild((XMLNodeIfc)new Element("payload", (String)payloadCData + "-" + i3, new String[]{"xmlns"}, new String[]{"test-xmlns"}));
            String uuid = UUID.randomUUID().toString().toLowerCase();
            this.dao.writeItem(this.serviceJid, node.getNodeId(), System.currentTimeMillis(), itemId, this.senderJid.getBareJID().toString(), item4, uuid);
            this.dao.addMAMItem(this.serviceJid, node.getNodeId(), uuid, item4, itemId);
            uuids.put((CallSite)((Object)itemId), uuid);
            publishedItems.add(item4);
            Thread.sleep(1500L);
        }
        String[] publishedItemIds = (String[])publishedItems.stream().map(el -> el.getAttributeStaticStr("id")).toArray(String[]::new);
        ArrayList results = new ArrayList();
        Query query = new Query();
        query.setComponentJID(JID.jidInstance((BareJID)this.serviceJid));
        query.setQuestionerJID(this.senderJid);
        query.getRsm().setMax(10);
        results.clear();
        this.dao.queryItems(query, node.getNodeId(), (query1, item) -> results.add(item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i2 = 0; i2 < 10; ++i2) {
            item3 = (MAMRepository.Item)results.get(i2);
            Assert.assertEquals(uuids.get(publishedItemIds[i2]), (Object)item3.getId());
            Assert.assertEquals(publishedItems.get(i2), (Object)item3.getMessage());
        }
        query.setWith(this.senderJid.copyWithoutResource());
        results.clear();
        this.dao.queryItems(query, node.getNodeId(), (query1, item) -> results.add(item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i2 = 0; i2 < 10; ++i2) {
            item3 = (MAMRepository.Item)results.get(i2);
            Assert.assertEquals(uuids.get(publishedItemIds[i2]), (Object)item3.getId());
            Assert.assertEquals(publishedItems.get(i2), (Object)item3.getMessage());
        }
        query.setWith(null);
        String after = ((MAMRepository.Item)results.get(4)).getId();
        query.getRsm().setAfter(after);
        results.clear();
        this.dao.queryItems(query, node.getNodeId(), (query1, item) -> results.add(item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            item2 = (MAMRepository.Item)results.get(i);
            Assert.assertEquals(uuids.get(publishedItemIds[i + 5]), (Object)item2.getId());
            Assert.assertEquals(publishedItems.get(i + 5), (Object)item2.getMessage());
        }
        query.getRsm().setAfter(null);
        query.getRsm().setHasBefore(true);
        results.clear();
        this.dao.queryItems(query, node.getNodeId(), (query1, item) -> results.add(item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            item2 = (MAMRepository.Item)results.get(i);
            Assert.assertEquals(uuids.get(publishedItemIds[i + 10]), (Object)item2.getId());
            Assert.assertEquals(publishedItems.get(i + 10), (Object)item2.getMessage());
        }
        Object[] itemsIds = this.dao.getItemsIds(this.serviceJid, node.getNodeId(), CollectionItemsOrdering.byUpdateDate);
        Arrays.sort(itemsIds);
        Object[] tmp = Arrays.copyOf(publishedItemIds, publishedItemIds.length);
        Arrays.sort(tmp);
        Assert.assertArrayEquals((String)"Added item id not listed in list of item ids", (Object[])tmp, (Object[])itemsIds);
        for (String itemId : publishedItemIds) {
            this.dao.deleteItem(this.serviceJid, node.getNodeId(), itemId);
            Element el2 = Optional.ofNullable(this.dao.getItem(this.serviceJid, node.getNodeId(), itemId)).map(IItems.IItem::getItem).orElse(null);
            Assert.assertNull((String)"Element still available in store after removal", (Object)el2);
        }
    }

    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        try {
            String xmlRepositoryURI = "memory://xmlRepo?autoCreateUser=true";
            XMLRepository repository = new XMLRepository();
            repository.initRepository(xmlRepositoryURI, null);
            kernel.registerBean("userAuthRepository").asInstance((Object)repository).exportable().exec();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize user/auth repository", ex);
        }
    }
}

