/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

class Items<T>
implements IItems {
    private static final Logger log = Logger.getLogger(Items.class.getName());
    private final IPubSubDAO<T, ?, ?> dao;
    private final T nodeId;
    private final String nodeName;
    private final BareJID serviceJid;

    public Items(T nodeId, BareJID serviceJid, String nodeName, IPubSubDAO dao) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Constructing Items, serviceJid: {0}, nodeName: {1}, nodeId: {2}, dao: {3}", new Object[]{serviceJid, nodeName, nodeId, dao});
        }
        this.nodeId = nodeId;
        this.dao = dao;
        this.nodeName = nodeName;
        this.serviceJid = serviceJid;
    }

    @Override
    public void deleteItem(String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Deleting item, serviceJid: {0}, id: {1}, nodeId: {2}, dao: {3}", new Object[]{this.serviceJid, id, this.nodeId, this.dao});
        }
        this.dao.deleteItem(this.serviceJid, this.nodeId, id);
    }

    @Override
    public Element getItem(String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItem, serviceJid: {0}, id: {1}, nodeId: {2}, dao: {3}", new Object[]{this.serviceJid, id, this.nodeId, this.dao});
        }
        return this.dao.getItem(this.serviceJid, this.nodeId, id);
    }

    @Override
    public Date getItemCreationDate(String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemCreationDate, serviceJid: {0}, id: {1}, nodeId: {2}, dao: {3}", new Object[]{this.serviceJid, id, this.nodeId, this.dao});
        }
        return this.dao.getItemCreationDate(this.serviceJid, this.nodeId, id);
    }

    @Override
    public String[] getItemsIds(CollectionItemsOrdering order) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemsIds, serviceJid: {0}, nodeId: {1}, dao: {2}, order: {3}", new Object[]{this.serviceJid, this.nodeId, this.dao, order});
        }
        return this.dao.getItemsIds(this.serviceJid, this.nodeId, order);
    }

    @Override
    public String[] getItemsIdsSince(CollectionItemsOrdering order, Date since) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemsIdsSince, serviceJid: {0}, nodeId: {1}, dao: {2}, order: {3}, since: {4}", new Object[]{this.serviceJid, this.nodeId, this.dao, order, since});
        }
        return this.dao.getItemsIdsSince(this.serviceJid, this.nodeId, order, since);
    }

    @Override
    public List<IItems.ItemMeta> getItemsMeta() throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemsIdsSince, serviceJid: {0}, nodeId: {1}, dao: {2}", new Object[]{this.serviceJid, this.nodeId, this.dao});
        }
        return this.dao.getItemsMeta(this.serviceJid, this.nodeId, this.nodeName);
    }

    @Override
    public Date getItemUpdateDate(String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getItemsIdsSince, serviceJid: {0}, nodeId: {1}, dao: {2}, id: {3}", new Object[]{this.serviceJid, this.nodeId, this.dao, id});
        }
        return this.dao.getItemUpdateDate(this.serviceJid, this.nodeId, id);
    }

    @Override
    public void writeItem(long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "writeItem, serviceJid: {0}, nodeId: {1}, dao: {2}, id: {3}, publisher: {4}, item: {5}", new Object[]{this.serviceJid, this.nodeId, this.dao, id, publisher, item});
        }
        this.dao.writeItem(this.serviceJid, this.nodeId, timeInMilis, id, publisher, item);
    }
}

