/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataSource;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.impl.roster.RosterFlat;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.mam.Query;
import tigase.xmpp.rsm.RSM;

public abstract class PubSubDAO<T, S extends DataSource, Q extends tigase.pubsub.modules.mam.Query>
implements IPubSubDAO<T, S, Q> {
    protected static final Logger log = Logger.getLogger(PubSubDAO.class.getCanonicalName());
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    @Inject
    private UserRepository repository;

    protected static <Q extends Query> void calculateOffsetAndPosition(Q query, int count, Integer before, Integer after) {
        RSM rsm = query.getRsm();
        int index = rsm.getIndex() == null ? 0 : rsm.getIndex();
        int limit = rsm.getMax();
        if (after != null) {
            index = after + 1;
        } else if (before != null) {
            index = before - rsm.getMax();
            if (index < 0) {
                index = 0;
                limit = before;
            }
        } else if (rsm.hasBefore() && (index = count - rsm.getMax()) < 0) {
            index = 0;
        }
        rsm.setIndex(Integer.valueOf(index));
        rsm.setMax(limit);
        rsm.setCount(Integer.valueOf(count));
    }

    protected PubSubDAO() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public String[] getBuddyGroups(BareJID owner, BareJID buddy) throws RepositoryException {
        try {
            return this.repository.getDataList(owner, "roster/" + buddy, "groups");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy groups error", (Throwable)e);
        }
    }

    @Override
    public String getBuddySubscription(BareJID owner, BareJID buddy) throws RepositoryException {
        try {
            return this.repository.getData(owner, "roster/" + buddy, "subscription");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy subscription status error", (Throwable)e);
        }
    }

    @Override
    public Map<BareJID, RosterElement> getUserRoster(BareJID owner) throws RepositoryException {
        try {
            String tmp = this.repository.getData(owner, "roster");
            HashMap<BareJID, RosterElement> roster = new HashMap<BareJID, RosterElement>();
            if (tmp != null) {
                RosterFlat.parseRosterUtil((String)tmp, roster, null);
            }
            return roster;
        }
        catch (UserNotFoundException ex) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "Cannot find roster of user {0}. Probably anonymous user.", new Object[]{owner});
            }
            return Collections.emptyMap();
        }
        catch (Exception e) {
            throw new RepositoryException("Getting user roster error", (Throwable)e);
        }
    }

    @Override
    public AbstractNodeConfig parseConfig(String nodeName, String data) throws RepositoryException {
        try {
            Form cnfForm = this.parseConfigForm(data);
            if (cnfForm == null) {
                return null;
            }
            NodeType type = NodeType.valueOf(cnfForm.getAsString("pubsub#node_type"));
            Class cl = null;
            switch (type) {
                case collection: {
                    cl = CollectionNodeConfig.class;
                    break;
                }
                case leaf: {
                    cl = LeafNodeConfig.class;
                    break;
                }
                default: {
                    throw new RepositoryException("Unknown node type " + (Object)((Object)type));
                }
            }
            CollectionNodeConfig nc = this.getNodeConfig(cl, nodeName, cnfForm);
            return nc;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", (Throwable)e);
        }
    }

    protected <T extends AbstractNodeConfig> T getNodeConfig(Class<T> nodeConfigClass, String nodeName, Form configForm) throws RepositoryException {
        try {
            Constructor<T> constructor = nodeConfigClass.getConstructor(String.class);
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)constructor.newInstance(nodeName);
            nodeConfig.copyFromForm(configForm);
            return (T)nodeConfig;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", (Throwable)e);
        }
    }

    protected Element itemDataToElement(String data) {
        return this.itemDataToElement(data.toCharArray());
    }

    protected Element itemDataToElement(char[] data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        return (Element)q.element();
    }

    protected Form parseConfigForm(String cnfData) {
        if (cnfData == null) {
            return null;
        }
        char[] data = cnfData.toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        if (q != null && q.size() > 0) {
            Form form = new Form((Element)q.element());
            return form;
        }
        return null;
    }

    public static class Item<T>
    implements IPubSubRepository.Item {
        private final String itemId;
        private final T nodeId;
        private final String nodeName;
        private final Date ts;
        private Element item;

        public Item(String nodeName, T nodeId, String itemId, Date ts, Element item) {
            this.nodeName = nodeName;
            this.nodeId = nodeId;
            this.itemId = itemId;
            this.ts = ts;
            this.item = item;
        }

        public String getId() {
            return this.nodeId.toString() + "," + this.itemId;
        }

        @Override
        public String getItemId() {
            return this.itemId;
        }

        public Element getMessage() {
            return this.item;
        }

        @Override
        public void setMessage(Element item) {
            this.item = item;
        }

        public Date getTimestamp() {
            return this.ts;
        }

        @Override
        public String getNode() {
            return this.nodeName;
        }
    }
}

