/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.converter;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import tigase.db.converter.RowEntity;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xmpp.jid.BareJID;

class PubSubNodeEntity
implements RowEntity {
    private final String node;
    private final IAffiliations nodeAffiliations = new NodeAffiliations();
    private final AbstractNodeConfig nodeConfig;
    private final ISubscriptions nodeSubscriptions = new NodeSubscriptions();
    private final NodeType nodeType;
    private final long nodeid;
    private final String parent;
    private final BareJID service;
    private Set<BareJID> owner = new ConcurrentSkipListSet<BareJID>();

    PubSubNodeEntity(BareJID service, String node, String parent, NodeType nodeType, long nodeid) {
        this.service = service;
        this.node = node;
        this.parent = parent;
        this.nodeid = nodeid;
        this.nodeType = nodeType;
        this.nodeConfig = NodeType.collection.equals((Object)nodeType) ? new CollectionNodeConfig(node) : new LeafNodeConfig(node);
        this.nodeConfig.setCollection(parent);
    }

    public String getID() {
        return this.service.toString() + " / " + this.node;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PubSubNodeEntity that = (PubSubNodeEntity)o;
        if (this.nodeid != that.nodeid) {
            return false;
        }
        if (!this.node.equals(that.node)) {
            return false;
        }
        if (this.nodeType != that.nodeType) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(that.parent) : that.parent != null) {
            return false;
        }
        return this.service.equals((Object)that.service);
    }

    public int hashCode() {
        int result = this.node.hashCode();
        result = 31 * result + this.nodeType.hashCode();
        result = 31 * result + (int)(this.nodeid ^ this.nodeid >>> 32);
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 31 * result + this.service.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PubSubNodeEntity{");
        sb.append("node='").append(this.node).append('\'');
        sb.append(", nodeid=").append(this.nodeid);
        sb.append(", nodeType=").append((Object)this.nodeType);
        sb.append(", parent=").append(this.parent);
        sb.append(", service=").append(this.service);
        sb.append(", owner=").append(this.owner);
        sb.append(", nodeAffiliations=").append(this.nodeAffiliations);
        sb.append(", nodeSubscriptions=").append(this.nodeSubscriptions);
        sb.append(", nodeConfig=").append(this.nodeConfig);
        sb.append('}');
        return sb.toString();
    }

    String getNode() {
        return this.node;
    }

    UsersAffiliation[] getNodeAffiliations() {
        return this.nodeAffiliations.getAffiliations();
    }

    AbstractNodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    UsersSubscription[] getNodeSubscriptions() {
        return this.nodeSubscriptions.getSubscriptions();
    }

    BareJID getService() {
        return this.service;
    }

    long getNodeid() {
        return this.nodeid;
    }

    Set<BareJID> getOwner() {
        return Collections.unmodifiableSet(this.owner);
    }

    void addOwner(BareJID owner) {
        this.owner.add(owner);
    }

    void addOwners(List<BareJID> owners) {
        this.owner.addAll(owners);
    }

    String getParent() {
        return this.parent != null ? this.parent : "";
    }

    void setConfigValue(String var, Object data) {
        this.nodeConfig.setValue("pubsub#" + var, data);
    }

    void setConfigValues(String option, String[] data) {
        this.nodeConfig.setValues("pubsub#" + option, data);
    }

    String addSubscription(BareJID jid, Subscription subscription) {
        return this.nodeSubscriptions.addSubscriberJid(jid, subscription);
    }

    void addAffiliation(BareJID bareJid, Affiliation affiliation) {
        this.nodeAffiliations.addAffiliation(bareJid, affiliation);
    }
}

