/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.Arrays;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.util.datetime.TimestampHelper;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="retrieveItemsCommand", parent=PubSubComponent.class, active=true)
public class RetrieveItemsCommand
implements AdHocCommand {
    public static final Logger log = Logger.getLogger(RetrieveItemsCommand.class.getName());
    public static final String TIGASE_PUBSUB_INTERNAL_KEY = "tigase-pubsub#internal";
    public static final String TIGASE_PUBSUB_ITEMID_KEY = "tigase-pubsub#item-id";
    public static final String TIGASE_PUBSUB_NODENAME_KEY = "tigase-pubsub#node-name";
    public static final String TIGASE_PUBSUB_SERVICE_KEY = "tigase-pubsub#service-name";
    public static final String TIGASE_PUBSUB_TIMESTAMP_KEY = "tigase-pubsub#timestamp";
    private final TimestampHelper dtf = new TimestampHelper();
    @Inject
    private PubSubConfig config;
    @Inject
    private IPubSubRepository repository;
    @Inject
    private UserRepository userRepo;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("result", "Retrieve items", null);
                form.addField(Field.fieldTextSingle((String)TIGASE_PUBSUB_SERVICE_KEY, (String)"", (String)"Service name"));
                form.addField(Field.fieldTextSingle((String)TIGASE_PUBSUB_NODENAME_KEY, (String)"", (String)"Node name"));
                form.addField(Field.fieldTextSingle((String)TIGASE_PUBSUB_ITEMID_KEY, (String)"", (String)"Item ID"));
                form.addField(Field.fieldTextSingle((String)TIGASE_PUBSUB_TIMESTAMP_KEY, (String)this.dtf.format(new Date()), (String)"Items since"));
                form.addField(Field.fieldHidden((String)TIGASE_PUBSUB_INTERNAL_KEY, (String)""));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    IItems nodeItems;
                    Boolean rebuild = form.getAsBoolean("tigase-pubsub#delete-all");
                    String serviceName = form.getAsString(TIGASE_PUBSUB_SERVICE_KEY);
                    String nodeName = form.getAsString(TIGASE_PUBSUB_NODENAME_KEY);
                    String nodeId = form.getAsString(TIGASE_PUBSUB_ITEMID_KEY);
                    String timeStr = form.getAsString(TIGASE_PUBSUB_TIMESTAMP_KEY);
                    Date timestamp = timeStr == null || timeStr.trim().length() == 0 ? null : this.dtf.parseTimestamp(timeStr);
                    String internalId = form.getAsString(TIGASE_PUBSUB_INTERNAL_KEY);
                    JID sender = request.getSender();
                    if (!this.config.isAdmin(sender) && !sender.getBareJID().toString().equals(serviceName)) {
                        throw new AdHocCommandException(Authorization.FORBIDDEN);
                    }
                    if (nodeName == null) {
                        throw new AdHocCommandException(Authorization.BAD_REQUEST, "Empty node name.");
                    }
                    if (timestamp == null && nodeId == null) {
                        throw new AdHocCommandException(Authorization.BAD_REQUEST, "Invalid timestamp.");
                    }
                    Element f = new Element("x", new String[]{"xmlns"}, new String[]{"jabber:x:data"});
                    if (null != serviceName) {
                        nodeItems = this.repository.getNodeItems(BareJID.bareJIDInstance((String)serviceName), nodeName);
                    } else {
                        f.addChild((XMLNodeIfc)new Element("title", "Items"));
                        Element reported = new Element("reported");
                        reported.addChild((XMLNodeIfc)new Element("field", new String[]{"var"}, new String[]{"id"}));
                        f.addChild((XMLNodeIfc)reported);
                        nodeItems = this.repository.getNodeItems(request.getIq().getTo().getBareJID(), nodeName);
                    }
                    if (null != nodeId) {
                        String[] itemsIds = nodeItems.getItemsIds();
                        if (null != itemsIds && Arrays.asList(itemsIds).contains(nodeId)) {
                            Element i = nodeItems.getItem(nodeId);
                            Element field = new Element("field", new String[]{"var"}, new String[]{"item"});
                            field.addChild((XMLNodeIfc)new Element("value", new Element[]{i}, null, null));
                            f.addChild((XMLNodeIfc)field);
                        }
                    } else {
                        String[] allItems;
                        for (String id : allItems = nodeItems.getItemsIdsSince(timestamp)) {
                            Element i = new Element("item");
                            Element fi = new Element("field", new String[]{"var"}, new String[]{"id"});
                            fi.addChild((XMLNodeIfc)new Element("value", id));
                            i.addChild((XMLNodeIfc)fi);
                            f.addChild((XMLNodeIfc)i);
                        }
                    }
                    if (null != internalId) {
                        Field fieldHidden = Field.fieldHidden((String)TIGASE_PUBSUB_INTERNAL_KEY, (String)internalId);
                        f.addChild((XMLNodeIfc)fieldHidden.getElement());
                    }
                    response.getElements().add(f);
                }
                response.completeSession();
            }
        }
        catch (AdHocCommandException e) {
            throw e;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing retrieve items packet", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getName() {
        return "Retrieve items";
    }

    public String getNode() {
        return "retrieve-items";
    }

    public boolean isAllowedFor(JID jid) {
        return Arrays.asList(this.config.getAdmins()).contains(jid.toString());
    }
}

