/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PublisherModel;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.impl.roster.RosterAbstract;
import tigase.xmpp.impl.roster.RosterElement;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="publishItemModule", parent=PubSubComponent.class, active=true)
public class PublishItemModule
extends AbstractPubSubModule
implements Initializable,
UnregisterAware {
    public static final String AMP_XMLNS = "http://jabber.org/protocol/amp";
    public static final String[] SUPPORTED_PEP_XMLNS = new String[]{"http://jabber.org/protocol/mood", "http://jabber.org/protocol/geoloc", "http://jabber.org/protocol/activity", "http://jabber.org/protocol/tune"};
    private static final Criteria CRIT_PUBLISH = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"publish"));
    private final LeafNodeConfig defaultPepNodeConfig;
    private final TimestampHelper dtf = new TimestampHelper();
    private final Set<String> pepNodes = new HashSet<String>();
    @Inject
    private EventBus eventBus;
    private long idCounter = 0L;
    @Inject
    private PresenceCollectorModule presenceCollector;
    @Inject(nullAllowed=false)
    private IPubSubRepository repository;
    @Inject
    private XsltTool xslTransformer;

    private static Collection<String> extractCDataItems(Element event, String[] path) {
        ArrayList<String> result = new ArrayList<String>();
        List z = event.getChildren(path);
        if (z != null) {
            for (Element element : z) {
                if (!element.getName().equals("item")) continue;
                result.add(element.getCData());
            }
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(".");
    }

    public PublishItemModule() {
        for (String xmlns : SUPPORTED_PEP_XMLNS) {
            this.pepNodes.add(xmlns);
        }
        this.defaultPepNodeConfig = new LeafNodeConfig("default-pep");
        this.defaultPepNodeConfig.setValue("pubsub#access_model", AccessModel.presence.name());
        this.defaultPepNodeConfig.setValue("pubsub#presence_based_delivery", true);
        this.defaultPepNodeConfig.setValue("pubsub#send_last_published_item", "on_sub_and_presence");
    }

    public void doPublishItems(BareJID serviceJID, String nodeName, LeafNodeConfig leafNodeConfig, String publisher, List<Element> itemsToSend) throws RepositoryException {
        if (leafNodeConfig.isPersistItem()) {
            IItems nodeItems = this.getRepository().getNodeItems(serviceJID, nodeName);
            for (Element item : itemsToSend) {
                String id = item.getAttributeStaticStr("id");
                if (!this.config.isPepRemoveEmptyGeoloc()) {
                    nodeItems.writeItem(System.currentTimeMillis(), id, publisher, item);
                    continue;
                }
                Element geoloc = item.findChildStaticStr(new String[]{"item", "geoloc"});
                if (geoloc != null && (geoloc.getChildren() == null || geoloc.getChildren().size() == 0)) {
                    nodeItems.deleteItem(id);
                    continue;
                }
                nodeItems.writeItem(System.currentTimeMillis(), id, publisher, item);
            }
            if (leafNodeConfig.getMaxItems() != null) {
                this.trimItems(nodeItems, leafNodeConfig.getMaxItems());
            }
        }
        this.eventBus.fire((Object)new ItemPublishedEvent(serviceJID, nodeName, publisher, itemsToSend));
        this.sendNotifications(serviceJID, nodeName, itemsToSend);
    }

    public void sendNotifications(BareJID serviceJID, String nodeName, List<Element> itemsToSend) throws RepositoryException {
        Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
        AbstractNodeConfig leafNodeConfig = this.getRepository().getNodeConfig(serviceJID, nodeName);
        IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(serviceJID, nodeName);
        ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(serviceJID, nodeName);
        items.addChildren(itemsToSend);
        this.sendNotifications(items, JID.jidInstance((BareJID)serviceJID), nodeName, this.getRepository().getNodeConfig(serviceJID, nodeName), nodeAffiliations, nodeSubscriptions);
        List<String> parents = this.getParents(serviceJID, nodeName);
        log.log(Level.FINEST, "Publishing item: {0}, node: {1}, conf: {2}, aff: {3}, subs: {4} ", new Object[]{items, nodeName, leafNodeConfig, nodeAffiliations, nodeSubscriptions});
        if (parents != null && parents.size() > 0) {
            for (int i = 1; i <= parents.size(); ++i) {
                String collection = parents.get(i - 1);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Collection", collection);
                AbstractNodeConfig colNodeConfig = this.getRepository().getNodeConfig(serviceJID, collection);
                ISubscriptions colNodeSubscriptions = this.getRepository().getNodeSubscriptions(serviceJID, collection);
                IAffiliations colNodeAffiliations = this.getRepository().getNodeAffiliations(serviceJID, collection);
                this.sendNotifications(items, JID.jidInstance((BareJID)serviceJID), nodeName, headers, colNodeConfig, colNodeAffiliations, colNodeSubscriptions, i);
            }
        }
    }

    public AbstractNodeConfig ensurePepNode(BareJID toJid, String nodeName, BareJID ownerJid) throws PubSubException {
        AbstractNodeConfig nodeConfig;
        try {
            IPubSubRepository repo = this.getRepository();
            nodeConfig = repo.getNodeConfig(toJid, nodeName);
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "Error occured during autocreation of node", (Exception)((Object)ex));
        }
        if (nodeConfig != null) {
            return nodeConfig;
        }
        return this.createPepNode(toJid, nodeName, ownerJid);
    }

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#publish"};
    }

    public Criteria getModuleCriteria() {
        return CRIT_PUBLISH;
    }

    public List<String> getParents(BareJID serviceJid, String nodeName) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJid, nodeName);
        String cn = nodeConfig.getCollection();
        while (cn != null && !"".equals(cn)) {
            result.add(cn);
            AbstractNodeConfig nc = this.getRepository().getNodeConfig(serviceJid, cn);
            cn = nc.getCollection();
        }
        return result;
    }

    public void initialize() {
        if (this.eventBus != null) {
            this.eventBus.registerAll((Object)this);
        } else {
            log.warning("EventBus is not injected!");
        }
    }

    public boolean isPEPNodeName(String nodeName) {
        if (this.config.isPepPeristent()) {
            return false;
        }
        return this.pepNodes.contains(nodeName);
    }

    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element publish = pubSub.getChild("publish");
        String nodeName = publish.getAttributeStaticStr("node");
        try {
            if (this.isPEPNodeName(nodeName)) {
                this.pepProcess(packet, pubSub, publish);
                return;
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                if (packet.getStanzaTo().getLocalpart() == null || !this.config.isPepPeristent()) {
                    throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
                }
                nodeConfig = this.createPepNode(toJid, nodeName, packet.getStanzaFrom().getBareJID());
            } else if (nodeConfig.getNodeType() == NodeType.collection) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "publish"));
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(packet.getStanzaFrom().getBareJID());
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            PublisherModel publisherModel = nodeConfig.getPublisherModel();
            if (!senderAffiliation.getAffiliation().isPublishItem() && !this.config.isAdmin(packet.getStanzaFrom()) && (publisherModel == PublisherModel.publishers || publisherModel == PublisherModel.subscribers && nodeSubscriptions.getSubscription(packet.getStanzaFrom().getBareJID()) != Subscription.subscribed)) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
            List<Element> itemsToSend = this.makeItemsToSend(publish);
            Packet resultIq = packet.okResult((Element)null, 0);
            if (leafNodeConfig.isPersistItem()) {
                Element resPubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                resultIq.getElement().addChild((XMLNodeIfc)resPubsub);
                Element resPublish = new Element("publish", new String[]{"node"}, new String[]{nodeName});
                resPubsub.addChild((XMLNodeIfc)resPublish);
                for (Element item : itemsToSend) {
                    String id = item.getAttributeStaticStr("id");
                    if (id == null) {
                        id = Utils.createUID();
                        item.setAttribute("id", id);
                    }
                    resPublish.addChild((XMLNodeIfc)new Element("item", new String[]{"id"}, new String[]{id}));
                }
            }
            this.packetWriter.write(resultIq);
            this.doPublishItems(toJid, nodeName, leafNodeConfig, element.getAttributeStaticStr("from"), itemsToSend);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing publish packet", e);
            throw new RuntimeException(e);
        }
    }

    public void publishLastItem(BareJID serviceJid, AbstractNodeConfig nodeConfig, JID destinationJID) throws RepositoryException {
        try {
            IAffiliations affiliations = this.getRepository().getNodeAffiliations(serviceJid, nodeConfig.getNodeName());
            ISubscriptions subscriptions = this.getRepository().getNodeSubscriptions(serviceJid, nodeConfig.getNodeName());
            this.logic.checkAccessPermission(serviceJid, nodeConfig, affiliations, subscriptions, destinationJID);
        }
        catch (Exception ex) {
            return;
        }
        IItems nodeItems = this.getRepository().getNodeItems(serviceJid, nodeConfig.getNodeName());
        String[] ids = nodeItems.getItemsIds();
        if (ids != null && ids.length > 0) {
            String lastID = ids[ids.length - 1];
            Element payload = nodeItems.getItem(lastID);
            Element items = new Element("items");
            items.addAttribute("node", nodeConfig.getNodeName());
            items.addChild((XMLNodeIfc)payload);
            this.sendNotifications(new JID[]{destinationJID}, items, JID.jidInstance((BareJID)serviceJid), nodeConfig, nodeConfig.getNodeName(), null);
        }
    }

    public void sendNotifications(Element itemToSend, JID jidFrom, String publisherNodeName, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodesSubscriptions) throws RepositoryException {
        this.sendNotifications(itemToSend, jidFrom, publisherNodeName, null, nodeConfig, nodeAffiliations, nodesSubscriptions, 0);
    }

    public void sendNotifications(Element itemToSend, JID jidFrom, String publisherNodeName, Map<String, String> headers, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodesSubscriptions, int depth) throws RepositoryException {
        if (depth > 1) {
            return;
        }
        this.beforePrepareNotification(nodeConfig, nodesSubscriptions);
        HashSet<JID> tmp = new HashSet<JID>();
        for (BareJID j : PublishItemModule.getActiveSubscribers(nodeConfig, nodeAffiliations, nodesSubscriptions)) {
            tmp.add(JID.jidInstance((BareJID)j));
        }
        boolean updateSubscriptions = false;
        log.log(Level.FINEST, "Sending notifications[1] item: {0}, node: {1}, conf: {2}, aff: {3}, subs: {4}, getActiveSubscribers: {5} ", new Object[]{itemToSend, publisherNodeName, nodeConfig, nodeAffiliations, nodesSubscriptions, tmp});
        if (nodeConfig.isPresenceExpired()) {
            Iterator it = tmp.iterator();
            while (it.hasNext()) {
                JID jid = (JID)it.next();
                boolean available = this.presenceCollector.isJidAvailable(jidFrom.getBareJID(), jid.getBareJID());
                UsersAffiliation afi = nodeAffiliations.getSubscriberAffiliation(jid.getBareJID());
                if (afi != null && (available || afi.getAffiliation() != Affiliation.member)) continue;
                it.remove();
                nodesSubscriptions.changeSubscription(jid.getBareJID(), Subscription.none);
                updateSubscriptions = true;
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Subscriptione expired. Node: " + nodeConfig.getNodeName() + ", jid: " + jid);
            }
        }
        if (updateSubscriptions) {
            this.getRepository().update(jidFrom.getBareJID(), nodeConfig.getNodeName(), nodesSubscriptions);
        }
        JID[] subscribers = tmp.toArray(new JID[0]);
        if (nodeConfig.isDeliverPresenceBased()) {
            HashSet<JID> s = new HashSet<JID>();
            for (JID jid : subscribers) {
                s.addAll(this.presenceCollector.getAllAvailableResources(jidFrom.getBareJID(), jid.getBareJID()));
            }
            if (jidFrom.getLocalpart() != null || this.config.isSubscribeByPresenceFilteredNotifications()) {
                switch (nodeConfig.getNodeAccessModel()) {
                    case open: 
                    case presence: {
                        s.addAll(this.presenceCollector.getAllAvailableJidsWithFeature(jidFrom.getBareJID(), nodeConfig.getNodeName() + "+notify"));
                        break;
                    }
                    case roster: {
                        Object[] allowedGroups = nodeConfig.getRosterGroupsAllowed();
                        Arrays.sort(allowedGroups);
                        List<JID> jids = this.presenceCollector.getAllAvailableJidsWithFeature(jidFrom.getBareJID(), nodeConfig.getNodeName() + "+notify");
                        if (jids.isEmpty() || allowedGroups == null || allowedGroups.length <= 0) break;
                        Map<BareJID, RosterElement> roster = this.getRepository().getUserRoster(jidFrom.getBareJID());
                        Iterator<JID> it = jids.iterator();
                        for (JID jid : jids) {
                            RosterElement re = roster.get(jid.getBareJID());
                            if (re == null) {
                                it.remove();
                                continue;
                            }
                            boolean notInGroups = true;
                            String[] groups = re.getGroups();
                            if (groups != null) {
                                for (String group : groups) {
                                    notInGroups &= Arrays.binarySearch(allowedGroups, group) < 0;
                                }
                            }
                            if (!notInGroups) continue;
                            it.remove();
                        }
                        break;
                    }
                }
            }
            subscribers = s.toArray(new JID[0]);
        }
        this.sendNotifications(subscribers, itemToSend, jidFrom, nodeConfig, publisherNodeName, headers);
    }

    public void sendNotifications(JID[] subscribers, Element itemToSend, JID jidFrom, AbstractNodeConfig nodeConfig, String publisherNodeName, Map<String, String> headers) {
        List<Element> body = null;
        log.log(Level.FINEST, "Sending notifications[2] item: {0}, node: {1}, conf: {2}, subs: {3} ", new Object[]{itemToSend, publisherNodeName, nodeConfig, Arrays.asList(subscribers)});
        if (this.xslTransformer != null && nodeConfig != null) {
            try {
                body = this.xslTransformer.transform(itemToSend, nodeConfig);
            }
            catch (Exception e) {
                body = null;
                log.log(Level.WARNING, "Problem with generating BODY", e);
            }
        }
        for (JID jid : subscribers) {
            long lowMemoryDelay;
            while ((lowMemoryDelay = this.config.getDelayOnLowMemory()) != 0L) {
                try {
                    System.gc();
                    Thread.sleep(lowMemoryDelay);
                }
                catch (Exception exception) {}
            }
            Element message = this.logic.prepareNotificationMessage(jidFrom, jid, String.valueOf(++this.idCounter), itemToSend, headers);
            if (body != null) {
                message.addChildren(body);
            }
            Packet packet = Packet.packetInstance((Element)message, (JID)jidFrom, (JID)jid);
            this.packetWriter.write(packet);
        }
    }

    public void trimItems(IItems nodeItems, Integer maxItems) throws RepositoryException {
        String[] ids = nodeItems.getItemsIds();
        if (ids == null || ids.length <= maxItems) {
            return;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (String id : ids) {
            Date updateDate = nodeItems.getItemUpdateDate(id);
            if (updateDate == null) continue;
            Item i = new Item(id, updateDate);
            items.add(i);
        }
        Collections.sort(items, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o2.updateDate.compareTo(o1.updateDate);
            }
        });
        for (int i = maxItems.intValue(); i < items.size(); ++i) {
            Item it = (Item)items.get(i);
            nodeItems.deleteItem(it.id);
        }
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    protected void beforePrepareNotification(AbstractNodeConfig nodeConfig, ISubscriptions nodesSubscriptions) {
        if (nodeConfig.isPresenceExpired()) {
            // empty if block
        }
    }

    protected JID[] getValidBuddies(BareJID id) throws RepositoryException {
        ArrayList<JID> result = new ArrayList<JID>();
        Map<BareJID, RosterElement> rosterJids = this.getRepository().getUserRoster(id);
        if (rosterJids != null) {
            for (Map.Entry<BareJID, RosterElement> e : rosterJids.entrySet()) {
                RosterAbstract.SubscriptionType sub = e.getValue().getSubscription();
                if (sub != RosterAbstract.SubscriptionType.both && sub != RosterAbstract.SubscriptionType.from && sub != RosterAbstract.SubscriptionType.from_pending_out) continue;
                result.add(JID.jidInstance((BareJID)e.getKey()));
            }
        }
        return result.toArray(new JID[0]);
    }

    @HandleEvent
    protected void onCapsChange(PresenceCollectorModule.CapsChangeEvent event) throws TigaseStringprepException {
        Set<String> newFeatures = event.newFeatures;
        if (newFeatures == null || newFeatures.isEmpty() || !this.config.isSendLastPublishedItemOnPresence()) {
            return;
        }
        for (String feature : newFeatures) {
            if (!feature.endsWith("+notify")) continue;
            String nodeName = feature.substring(0, feature.length() - "+notify".length());
            try {
                this.publishLastItem(event.serviceJid, nodeName, event.buddyJid);
            }
            catch (RepositoryException ex) {
                log.log(Level.WARNING, "Exception while sending last published item on on_sub_and_presence for service jid " + event.serviceJid + " and node " + nodeName);
            }
        }
    }

    protected void publishLastItem(BareJID serviceJid, String nodeName, JID buddyJid) throws RepositoryException {
        AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(serviceJid, nodeName);
        if (nodeConfig != null && nodeConfig.getSendLastPublishedItem() == SendLastPublishedItem.on_sub_and_presence) {
            String[] childNodes;
            if (nodeConfig instanceof LeafNodeConfig) {
                this.publishLastItem(serviceJid, nodeConfig, buddyJid);
            } else if (nodeConfig instanceof CollectionNodeConfig && (childNodes = this.repository.getChildNodes(serviceJid, nodeConfig.getNodeName())) != null) {
                for (String childNode : childNodes) {
                    try {
                        this.publishLastItem(serviceJid, childNode, buddyJid);
                    }
                    catch (RepositoryException ex) {
                        log.log(Level.WARNING, "Exception while sending last published item on on_sub_and_presence for service jid " + serviceJid + " and node " + childNode);
                    }
                }
            }
        }
    }

    @HandleEvent
    protected void onPresenceChangeEvent(PresenceCollectorModule.PresenceChangeEvent event) throws TigaseStringprepException {
        Packet packet = event.packet;
        if (packet.getStanzaTo() == null) {
            return;
        }
        if (!this.config.isSendLastPublishedItemOnPresence()) {
            return;
        }
        if (packet.getType() == null || packet.getType() == StanzaType.available) {
            BareJID serviceJid = packet.getStanzaTo().getBareJID();
            JID userJid = packet.getStanzaFrom();
            try {
                Map<String, UsersSubscription> subscrs = this.repository.getUserSubscriptions(serviceJid, userJid.getBareJID());
                log.log(Level.FINEST, "Sending last published items for subscribed nodes: {0}", subscrs);
                for (Map.Entry<String, UsersSubscription> e : subscrs.entrySet()) {
                    String nodeName;
                    AbstractNodeConfig nodeConfig;
                    if (e.getValue().getSubscription() != Subscription.subscribed || (nodeConfig = this.repository.getNodeConfig(serviceJid, nodeName = e.getKey())).getSendLastPublishedItem() != SendLastPublishedItem.on_sub_and_presence) continue;
                    this.publishLastItem(serviceJid, nodeConfig, userJid);
                }
            }
            catch (RepositoryException ex) {
                Logger.getLogger(PublishItemModule.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private AbstractNodeConfig createPepNode(BareJID toJid, String nodeName, BareJID ownerJid) throws PubSubException {
        AbstractNodeConfig nodeConfig;
        if (!toJid.equals((Object)ownerJid)) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        try {
            IPubSubRepository repo = this.getRepository();
            nodeConfig = new LeafNodeConfig(nodeName, this.defaultPepNodeConfig);
            repo.createNode(toJid, nodeName, ownerJid, nodeConfig, NodeType.leaf, "");
            nodeConfig = repo.getNodeConfig(toJid, nodeName);
            IAffiliations nodeaAffiliations = repo.getNodeAffiliations(toJid, nodeName);
            nodeaAffiliations.addAffiliation(ownerJid, Affiliation.owner);
            ISubscriptions nodeaSubscriptions = repo.getNodeSubscriptions(toJid, nodeName);
            if (this.config.isAutoSubscribeNodeCreator()) {
                nodeaSubscriptions.addSubscriberJid(toJid, Subscription.subscribed);
            }
            repo.update(toJid, nodeName, nodeaAffiliations);
            repo.addToRootCollection(toJid, nodeName);
            log.log(Level.FINEST, "Created new PEP node: {0}, conf: {1}, aff: {2}, subs: {3} ", new Object[]{nodeName, nodeConfig, nodeaAffiliations, nodeaSubscriptions});
        }
        catch (RepositoryException ex) {
            throw new PubSubException(Authorization.INTERNAL_SERVER_ERROR, "Error occured during autocreation of node", (Exception)((Object)ex));
        }
        return nodeConfig;
    }

    private List<Element> makeItemsToSend(Element publish) throws PubSubException {
        ArrayList<Element> items = new ArrayList<Element>();
        for (Element si : publish.getChildren()) {
            if (!"item".equals(si.getName())) continue;
            String expireAttr = si.getAttributeStaticStr("expire-at");
            if (expireAttr != null) {
                try {
                    Date parseDateTime = this.dtf.parseTimestamp(expireAttr);
                    if (null != parseDateTime) {
                        si.setAttribute("expire-at", this.dtf.format(parseDateTime));
                    } else {
                        si.removeAttribute("expire-at");
                    }
                }
                catch (ParseException e) {
                    throw new PubSubException(Authorization.BAD_REQUEST, "Invalid value for attribute expire-at");
                }
            }
            items.add(si);
        }
        return items;
    }

    private void pepProcess(Packet packet, Element pubSub, Element publish) throws RepositoryException {
        JID senderJid = packet.getStanzaFrom();
        JID[] subscribers = this.getValidBuddies(senderJid.getBareJID());
        Element item = publish.getChild("item");
        Element items = new Element("items", new String[]{"node"}, new String[]{publish.getAttributeStaticStr("node")});
        items.addChild((XMLNodeIfc)item);
        this.sendNotifications(subscribers, items, senderJid, null, publish.getAttributeStaticStr("node"), null);
        this.packetWriter.write(packet.okResult((Element)null, 0));
        this.sendNotifications(new JID[]{senderJid}, items, senderJid, null, publish.getAttributeStaticStr("node"), null);
    }

    public static class ItemPublishedEvent {
        public final List<Element> itemsToSend;
        public final String node;
        public final String publisher;
        public final BareJID serviceJid;

        public ItemPublishedEvent(BareJID serviceJid, String node, String publisher, List<Element> itemsToSend) {
            this.serviceJid = serviceJid;
            this.node = node;
            this.publisher = publisher;
            this.itemsToSend = itemsToSend;
        }
    }

    private static class Item {
        final String id;
        final Date updateDate;

        Item(String id, Date date) {
            this.updateDate = date;
            this.id = id;
        }
    }
}

