/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.server.xmppsession.SessionManager;
import tigase.util.dns.DNSResolverFactory;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;
import tigase.xmpp.impl.ServiceDiscovery;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="pep", parent=SessionManager.class, active=true)
public class PepPlugin
extends XMPPProcessor
implements XMPPProcessorIfc,
XMPPStopListenerIfc,
ServiceDiscovery.AccountServiceProvider {
    protected static final String PUBSUB_XMLNS = "http://jabber.org/protocol/pubsub";
    protected static final String PUBSUB_XMLNS_OWNER = "http://jabber.org/protocol/pubsub#owner";
    protected static final Element[] DISCO_FEATURES = new Element[]{new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#owner"}), new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub#publish"}), new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", "pep"})};
    protected static final String DISCO_INFO_XMLNS = "http://jabber.org/protocol/disco#info";
    protected static final String DISCO_ITEMS_XMLNS = "http://jabber.org/protocol/disco#items";
    protected static final String[][] ELEMENTS = new String[][]{Iq.IQ_PUBSUB_PATH, Iq.IQ_PUBSUB_PATH, {"presence"}};
    protected static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/pubsub#owner", "http://jabber.org/protocol/pubsub", "jabber:client"};
    private static final String CAPS_XMLNS = "http://jabber.org/protocol/caps";
    private static final String ID = "pep";
    private static final Logger log = Logger.getLogger(PepPlugin.class.getCanonicalName());
    private static final String[] PRESENCE_C_PATH = new String[]{"presence", "c"};
    private static final Set<StanzaType> TYPES = new HashSet<StanzaType>(Arrays.asList(null, StanzaType.available, StanzaType.unavailable, StanzaType.get, StanzaType.set, StanzaType.result, StanzaType.error));
    protected final Set<String> simpleNodes = new HashSet<String>(Arrays.asList("http://jabber.org/protocol/tune", "http://jabber.org/protocol/mood", "http://jabber.org/protocol/activity", "http://jabber.org/protocol/geoloc", "urn:xmpp:avatar:data", "urn:xmpp:avatar:metadata"));
    @ConfigField(desc="PubSub Component JID", alias="pubsub-jid")
    protected JID pubsubJid = JID.jidInstanceNS((String)"pubsub", (String)DNSResolverFactory.getInstance().getDefaultHost(), null);
    @ConfigField(desc="Enable simple PEP", alias="simple-pep-enabled")
    protected boolean simplePepEnabled = false;

    public String id() {
        return ID;
    }

    public int concurrentQueuesNo() {
        return super.concurrentQueuesNo() * 2;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        switch (packet.getElemName()) {
            case "iq": {
                this.processIq(packet, session, results);
                break;
            }
            case "presence": {
                this.processPresence(packet, session, results);
            }
        }
    }

    public Element[] supDiscoFeatures(XMPPResourceConnection session) {
        return DISCO_FEATURES;
    }

    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    public Set<StanzaType> supTypes() {
        return TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        XMPPResourceConnection xMPPResourceConnection = session;
        synchronized (xMPPResourceConnection) {
            block5: {
                try {
                    Packet packet = Presence.packetInstance((String)"presence", (String)session.getJID().toString(), (String)session.getJID().copyWithoutResource().toString(), (StanzaType)StanzaType.unavailable);
                    this.processPresence(packet, session, results);
                }
                catch (TigaseStringprepException | NotAuthorizedException e) {
                    if (!log.isLoggable(Level.FINER)) break block5;
                    log.log(Level.FINER, "Problem forwarding unavailable presence to PubSub component");
                }
            }
        }
    }

    public JID getServiceProviderComponentJid() {
        return this.pubsubJid;
    }

    protected JID getPubsubJid(XMPPResourceConnection session, JID serviceJid) {
        return this.pubsubJid;
    }

    protected void processIq(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws XMPPException {
        if (session != null && session.isServerSession()) {
            return;
        }
        Element pubsubEl = packet.getElement().findChildStaticStr(Iq.IQ_PUBSUB_PATH);
        if (pubsubEl != null && this.simplePepEnabled) {
            boolean simple;
            boolean bl = simple = pubsubEl.findChild(c -> this.simpleNodes.contains(c.getAttributeStaticStr("node"))) != null;
            if (simple) {
                return;
            }
        }
        if (packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
            if (pubsubEl != null && (pubsubEl.getXMLNS() == PUBSUB_XMLNS || pubsubEl.getXMLNS() == PUBSUB_XMLNS_OWNER)) {
                XMPPResourceConnection con;
                Packet result = null;
                if (session != null && (con = session.getParentSession().getResourceForResource(packet.getStanzaTo().getResource())) != null) {
                    result = packet.copyElementOnly();
                    result.setPacketTo(con.getConnectionId());
                    result.setPacketFrom(packet.getTo());
                }
                if (result == null) {
                    result = Authorization.RECIPIENT_UNAVAILABLE.getResponseMessage(packet, "The recipient is no longer available.", true);
                }
                results.offer(result);
            }
            return;
        }
        if (session != null && packet.getStanzaTo() != null && !session.isUserId(packet.getStanzaTo().getBareJID())) {
            results.offer(packet.copyElementOnly());
            return;
        }
        if (packet.getStanzaTo() == null) {
            if (pubsubEl == null || pubsubEl.getXMLNS() != PUBSUB_XMLNS && pubsubEl.getXMLNS() != PUBSUB_XMLNS_OWNER) {
                log.log(Level.FINEST, "got <iq/> packet with no 'to' attribute = {0}", packet);
                return;
            }
        } else if (packet.getStanzaTo().getResource() == null && packet.getType() == StanzaType.error && packet.getType() == StanzaType.result) {
            return;
        }
        Packet result = packet.copyElementOnly();
        if (packet.getStanzaTo() == null && session != null) {
            JID userJid = JID.jidInstance((BareJID)session.getBareJID());
            result.initVars(packet.getStanzaFrom() != null ? packet.getStanzaFrom() : session.getJID(), userJid);
        }
        if (packet.getStanzaFrom() == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "received <iq/> packet to forward to PubSub component without 'from' attribute, dropping packet = {0}", packet);
            }
            return;
        }
        result.setPacketFrom(packet.getFrom());
        result.setPacketTo(this.getPubsubJid(session, packet.getStanzaTo()));
        results.offer(result);
    }

    protected void processPresence(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        boolean forward = false;
        if (packet.getType() == null || packet.getType() == StanzaType.available) {
            forward = packet.getElement().getXMLNSStaticStr(PRESENCE_C_PATH) == CAPS_XMLNS;
        } else if (packet.getType() == StanzaType.unavailable) {
            forward = true;
        }
        if (!forward) {
            return;
        }
        if (packet.getStanzaTo() == null && session != null && session.isAuthorized() || packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null && (session == null || !session.isAuthorized() || session.isUserId(packet.getStanzaTo().getBareJID()))) {
            Packet result = packet.copyElementOnly();
            if (packet.getStanzaTo() == null || packet.getStanzaFrom() == null) {
                if (session == null || packet.getStanzaTo() != null && session.isUserId(packet.getStanzaTo().getBareJID())) {
                    return;
                }
                JID userJid = JID.jidInstance((BareJID)session.getBareJID());
                result.initVars(session.getJID(), userJid);
            }
            result.setPacketTo(this.getPubsubJid(session, packet.getStanzaTo()));
            results.offer(result);
        }
    }
}

