/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.Comparator;
import tigase.pubsub.repository.IItems;

public enum CollectionItemsOrdering {
    byCreationDate("Sort items by creation time", new Comparator<IItems.ItemMeta>(){

        @Override
        public int compare(IItems.ItemMeta o1, IItems.ItemMeta o2) {
            return o1.getCreationDate().compareTo(o2.getCreationDate()) * -1;
        }
    }),
    byUpdateDate("Sort items by last update time", new Comparator<IItems.ItemMeta>(){

        @Override
        public int compare(IItems.ItemMeta o1, IItems.ItemMeta o2) {
            return o1.getItemUpdateDate().compareTo(o2.getItemUpdateDate()) * -1;
        }
    });

    private final Comparator<IItems.ItemMeta> comparator;
    private final String description;

    public static String[] descriptions() {
        String[] result = new String[CollectionItemsOrdering.values().length];
        int i = 0;
        for (CollectionItemsOrdering item : CollectionItemsOrdering.values()) {
            result[i++] = item.description;
        }
        return result;
    }

    private CollectionItemsOrdering(String description, Comparator<IItems.ItemMeta> cmp) {
        this.description = description;
        this.comparator = cmp;
    }

    public Comparator<IItems.ItemMeta> getComparator() {
        return this.comparator;
    }
}

