/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import tigase.pubsub.Utils;

public class UtilsTest {
    @Ignore
    @Test
    public void test() throws NoSuchAlgorithmException {
        int i;
        Utils.Spi spi = new Utils.Spi(new Random());
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (i = 0; i < 1000; ++i) {
            byte[] bytes = new byte[13];
            spi.engineNextBytes(bytes, 1);
            list.add(bytes);
        }
        for (i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                if (i == j) continue;
                String x1 = new BigInteger((byte[])list.get(i)).toString(36);
                String x2 = new BigInteger((byte[])list.get(j)).toString(36);
                Assert.assertNotEquals((String)("At possitions " + i + ", " + j + "found collision!"), (Object)x1, (Object)x2);
            }
        }
    }

    @Ignore
    @Test
    public void concurrencyTest() throws NoSuchAlgorithmException, InterruptedException {
        final Utils.Spi spi = new Utils.Spi(new Random());
        ArrayList<1> tasks = new ArrayList<1>();
        for (int i = 0; i < 1000; ++i) {
            tasks.add(new Callable<byte[]>(){

                @Override
                public byte[] call() throws Exception {
                    byte[] bytes = new byte[13];
                    spi.engineNextBytes(bytes, 1);
                    return bytes;
                }
            });
        }
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 4);
        List futures = executorService.invokeAll(tasks);
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            Thread.sleep(1000L);
        }
        List list = futures.stream().map(f -> {
            try {
                return (byte[])f.get();
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }).collect(Collectors.toList());
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                if (i == j) continue;
                String x1 = new BigInteger((byte[])list.get(i)).toString(36);
                String x2 = new BigInteger((byte[])list.get(j)).toString(36);
                Assert.assertNotEquals((String)("At possitions " + i + ", " + j + "found collision!"), (Object)x1, (Object)x2);
            }
        }
    }
}

