/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Field;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="rebuildDatabaseCommand", parent=PubSubComponent.class, active=true)
public class RebuildDatabaseCommand
implements AdHocCommand {
    private static final Logger log = Logger.getLogger(RebuildDatabaseCommand.class.getName());
    @Inject
    private PubSubConfig config;
    @Inject
    private IPubSubDAO dao;

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("result", "Rebuild nodes tree", "To rebuild tree of nodes please check checkbox.");
                form.addField(Field.fieldBoolean((String)"tigase-pubsub#rebuild", (Boolean)Boolean.FALSE, (String)"Rebuild nodes tree?"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    Boolean rebuild = form.getAsBoolean("tigase-pubsub#rebuild");
                    if (rebuild != null && rebuild.booleanValue()) {
                        this.startRebuild(request.getIq().getStanzaTo().getBareJID());
                        Form f = new Form("result", "Info", "Nodes tree has been rebuild");
                        response.getElements().add(f.getElement());
                    } else {
                        Form f = new Form("result", "Info", "Rebuild cancelled.");
                        response.getElements().add(f.getElement());
                    }
                }
                response.completeSession();
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error during rebuild database", e);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    public String getName() {
        return "Rebuild database";
    }

    public String getNode() {
        return "rebuild-db";
    }

    public boolean isAllowedFor(JID jid) {
        return Arrays.asList(this.config.getAdmins()).contains(jid.toString());
    }

    private void startRebuild(BareJID serviceJid) throws RepositoryException {
        Object nodeId;
        String[] allNodesId = this.dao.getAllNodesList(serviceJid);
        HashSet rootCollection = new HashSet();
        HashMap<String, AbstractNodeConfig> nodeConfigs = new HashMap<String, AbstractNodeConfig>();
        for (String nodeName : allNodesId) {
            nodeId = this.dao.getNodeId(serviceJid, nodeName);
            String nodeConfigData = this.dao.getNodeConfig(serviceJid, nodeId);
            AbstractNodeConfig nodeConfig = this.dao.parseConfig(nodeName, nodeConfigData);
            nodeConfigs.put(nodeName, nodeConfig);
            if (!(nodeConfig instanceof CollectionNodeConfig)) continue;
            CollectionNodeConfig collectionNodeConfig = (CollectionNodeConfig)nodeConfig;
            collectionNodeConfig.setChildren(null);
        }
        for (Map.Entry entry : nodeConfigs.entrySet()) {
            String nodeName;
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)entry.getValue();
            nodeName = (String)entry.getKey();
            nodeId = this.dao.getNodeId(serviceJid, nodeName);
            Object collectionId = this.dao.getNodeId(serviceJid, nodeConfig.getCollection());
            this.dao.updateNodeConfig(serviceJid, nodeId, nodeConfig.getFormElement().toString(), collectionId);
        }
        this.dao.removeAllFromRootCollection(serviceJid);
        for (String string : rootCollection) {
            this.dao.addToRootCollection(serviceJid, string);
        }
    }
}

