/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Map;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;

@Bean(name="retrieveSubscriptionsModule", parent=PubSubComponent.class, active=true)
public class RetrieveSubscriptionsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"subscriptions"));

    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-subscriptions"};
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void process(Packet packet) throws PubSubException {
        try {
            BareJID serviceJid = packet.getStanzaTo().getBareJID();
            Element pubsub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element subscriptions = pubsub.getChild("subscriptions");
            String nodeName = subscriptions.getAttributeStaticStr("node");
            String senderJid = packet.getStanzaFrom().toString();
            BareJID senderBareJid = packet.getStanzaFrom().getBareJID();
            Element pubsubResult = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Element subscriptionsResult = new Element("subscriptions");
            pubsubResult.addChild((XMLNodeIfc)subscriptionsResult);
            if (nodeName == null) {
                IPubSubDAO directRepo = this.getRepository().getPubSubDAO();
                Map<String, UsersSubscription> usersSubscriptions = directRepo.getUserSubscriptions(serviceJid, senderBareJid);
                for (Map.Entry<String, UsersSubscription> entry : usersSubscriptions.entrySet()) {
                    UsersSubscription subscription = entry.getValue();
                    Element a = new Element("subscription", new String[]{"node", "jid", "subscription"}, new String[]{entry.getKey(), senderBareJid.toString(), subscription.getSubscription().name()});
                    subscriptionsResult.addChild((XMLNodeIfc)a);
                }
            } else {
                UsersSubscription[] subscribers;
                AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJid, nodeName);
                if (nodeConfig == null) {
                    throw new PubSubException(packet.getElement(), Authorization.ITEM_NOT_FOUND);
                }
                ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(serviceJid, nodeName);
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "Getting node subscription, serviceJid: {0}, nodeName: {1}, nodeConfig: {2}, nodeSubscriptions: {3}", new Object[]{serviceJid, nodeName, nodeConfig, nodeSubscriptions});
                }
                subscriptionsResult.addAttribute("node", nodeName);
                for (UsersSubscription usersSubscription : subscribers = nodeSubscriptions.getSubscriptions()) {
                    Element s = new Element("subscription", new String[]{"jid", "subscription", "subid"}, new String[]{usersSubscription.getJid().toString(), usersSubscription.getSubscription().name(), usersSubscription.getSubid()});
                    subscriptionsResult.addChild((XMLNodeIfc)s);
                }
            }
            Packet result = packet.okResult(pubsubResult, 0);
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            log.log(Level.FINE, "Error processing retrieve subscriptions packet", e);
            throw new RuntimeException(e);
        }
    }
}

