/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.db.xml.XMLRepository;
import tigase.kernel.core.Kernel;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractPubSubDAOTest<DS extends DataSource>
extends AbstractDataSourceAwareTestCase<DS, IPubSubDAO> {
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    protected boolean checkEmoji = true;
    protected IPubSubDAO dao;
    private String nodeNameWithoutEmoji;
    private String nodeName = this.nodeNameWithoutEmoji = "test-node";
    private JID senderJid = JID.jidInstanceNS((String)"owner@tigase/tigase-1");
    private BareJID serviceJid = BareJID.bareJIDInstanceNS((String)"pubsub.tigase");
    private JID subscriberJid = JID.jidInstanceNS((String)"subscriber@tigase/tigase-1");

    @Before
    public void setup() throws RepositoryException, DBInitException, IllegalAccessException, InstantiationException {
        if (this.checkEmoji) {
            this.nodeName = this.nodeName + emoji;
        }
        this.dao = (IPubSubDAO)this.getDataSourceAware();
    }

    @After
    public void tearDown() {
        if (this.dao != null) {
            this.dao.destroy();
        }
        this.dao = null;
    }

    @Test
    public void test00_testNodesCount() throws RepositoryException {
        long value = this.dao.getNodesCount(null);
        Assert.assertTrue((value >= 0L ? 1 : 0) != 0);
    }

    @Test
    public void test01_createNode() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        if (nodeId != null) {
            this.dao.deleteNode(this.serviceJid, nodeId);
        }
        LeafNodeConfig nodeCfg = new LeafNodeConfig(this.nodeName);
        this.dao.createNode(this.serviceJid, this.nodeName, this.senderJid.getBareJID(), (AbstractNodeConfig)nodeCfg, NodeType.leaf, null);
        nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not retrieve nodeId for newly created node", (Object)nodeId);
    }

    @Test
    public void test02_subscribeNode() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        UsersSubscription subscr = new UsersSubscription(this.subscriberJid.getBareJID(), "sub-1", Subscription.subscribed);
        this.dao.updateNodeSubscription(this.serviceJid, nodeId, this.nodeName, subscr);
        NodeSubscriptions nodeSubscr = this.dao.getNodeSubscriptions(this.serviceJid, nodeId);
        Assert.assertNotNull((String)"Not found subscriptions for node", (Object)nodeSubscr);
        Subscription subscription = nodeSubscr.getSubscription(this.subscriberJid.getBareJID());
        Assert.assertEquals((String)"Bad subscription type for user", (Object)Subscription.subscribed, (Object)subscription);
    }

    @Test
    public void test03_affiliateNode() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        UsersAffiliation affil = new UsersAffiliation(this.subscriberJid.getBareJID(), Affiliation.publisher);
        this.dao.updateNodeAffiliation(this.serviceJid, nodeId, this.nodeName, affil);
        NodeAffiliations nodeAffils = this.dao.getNodeAffiliations(this.serviceJid, nodeId);
        Assert.assertNotNull((String)"Not found affiliations for node", (Object)nodeAffils);
        affil = nodeAffils.getSubscriberAffiliation(this.subscriberJid.getBareJID());
        Assert.assertNotNull((String)"Not found affiliation for user", (Object)affil);
        Affiliation affiliation = affil.getAffiliation();
        Assert.assertEquals((String)"Bad affiliation type for user", (Object)Affiliation.publisher, (Object)affiliation);
    }

    @Test
    public void test04_userSubscriptions() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        Map map = this.dao.getUserSubscriptions(this.serviceJid, this.subscriberJid.getBareJID());
        Assert.assertNotNull((String)"No subscriptions for user", (Object)map);
        UsersSubscription subscr = (UsersSubscription)map.get(this.nodeName);
        Assert.assertNotNull((String)"No subscription for user for node", (Object)subscr);
        Assert.assertEquals((String)"Bad subscription for user for node", (Object)Subscription.subscribed, (Object)subscr.getSubscription());
    }

    @Test
    public void test05_userAffiliations() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        Map map = this.dao.getUserAffiliations(this.serviceJid, this.subscriberJid.getBareJID());
        Assert.assertNotNull((String)"No affiliation for user", (Object)map);
        UsersAffiliation affil = (UsersAffiliation)map.get(this.nodeName);
        Assert.assertNotNull((String)"No affiliation for user for node", (Object)affil);
        Assert.assertEquals((String)"Bad affiliation for user for node", (Object)Affiliation.publisher, (Object)affil.getAffiliation());
    }

    @Test
    public void test06_allNodes() throws RepositoryException {
        Object[] allNodes = this.dao.getAllNodesList(this.serviceJid);
        Arrays.sort(allNodes);
        Assert.assertNotEquals((String)"Node name not listed in list of all root nodes", (long)-1L, (long)Arrays.binarySearch(allNodes, this.nodeName));
    }

    @Test
    public void test06_getNodeMeta() throws RepositoryException {
        INodeMeta meta = this.dao.getNodeMeta(this.serviceJid, this.nodeName);
        Assert.assertNotNull((Object)meta);
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertEquals((Object)nodeId, (Object)meta.getNodeId());
        Assert.assertEquals((Object)this.nodeName, (Object)meta.getNodeConfig().getNodeName());
        Assert.assertEquals((Object)this.senderJid.getBareJID(), (Object)meta.getCreator());
        Assert.assertNotNull((Object)meta.getCreationTime());
    }

    @Test
    public void test07_nodeItems() throws RepositoryException {
        String itemId = "item-1";
        Element item = new Element("item", new String[]{"id"}, new String[]{itemId});
        String payloadCData = "test-payload";
        if (this.checkEmoji) {
            payloadCData = payloadCData + emoji;
        }
        item.addChild((XMLNodeIfc)new Element("payload", payloadCData, new String[]{"xmlns"}, new String[]{"test-xmlns"}));
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        this.dao.writeItem(this.serviceJid, nodeId, System.currentTimeMillis(), itemId, this.nodeNameWithoutEmoji, item);
        Object[] itemsIds = this.dao.getItemsIds(this.serviceJid, nodeId);
        Assert.assertArrayEquals((String)"Added item id not listed in list of item ids", (Object[])new String[]{itemId}, (Object[])itemsIds);
        Element el = this.dao.getItem(this.serviceJid, nodeId, itemId);
        Assert.assertEquals((String)"Element retrieved from store do not match to element added to store", (Object)item, (Object)el);
        this.dao.deleteItem(this.serviceJid, nodeId, itemId);
        el = this.dao.getItem(this.serviceJid, nodeId, itemId);
        Assert.assertNull((String)"Element still available in store after removal", (Object)el);
    }

    @Test
    public void test08_queryNodeItems() throws RepositoryException, InterruptedException, ComponentException {
        this.test08_queryNodeItems(CollectionItemsOrdering.byCreationDate);
        this.test08_queryNodeItems(CollectionItemsOrdering.byUpdateDate);
    }

    @Test
    public void test09_subscribeNodeRemoval() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        UsersSubscription subscr = new UsersSubscription(this.subscriberJid.getBareJID(), "sub-1", Subscription.none);
        this.dao.updateNodeSubscription(this.serviceJid, nodeId, this.nodeName, subscr);
        NodeSubscriptions nodeSubscr = this.dao.getNodeSubscriptions(this.serviceJid, nodeId);
        Assert.assertNotNull((String)"Not found subscriptions for node", (Object)nodeSubscr);
        Subscription subscription = nodeSubscr.getSubscription(this.subscriberJid.getBareJID());
        Assert.assertEquals((String)"Bad subscription type for user", (Object)Subscription.none, (Object)subscription);
    }

    @Test
    public void test09_affiliateNodeRemoval() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        UsersAffiliation affil = new UsersAffiliation(this.subscriberJid.getBareJID(), Affiliation.none);
        this.dao.updateNodeAffiliation(this.serviceJid, nodeId, this.nodeName, affil);
        NodeAffiliations nodeAffils = this.dao.getNodeAffiliations(this.serviceJid, nodeId);
        Assert.assertNotNull((String)"Not found affiliations for node", (Object)nodeAffils);
        affil = nodeAffils.getSubscriberAffiliation(this.subscriberJid.getBareJID());
        Assert.assertEquals((String)"Bad affiliation for user", (Object)Affiliation.none, (Object)affil.getAffiliation());
    }

    @Test
    public void test10_nodeRemoval() throws RepositoryException {
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        this.dao.deleteNode(this.serviceJid, nodeId);
        nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNull((String)"Node not removed", (Object)nodeId);
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return IPubSubDAO.class;
    }

    protected void test08_queryNodeItems(CollectionItemsOrdering order) throws RepositoryException, InterruptedException, ComponentException {
        IPubSubRepository.Item item2;
        int i;
        IPubSubRepository.Item item3;
        int i2;
        ArrayList<Element> publishedItems = new ArrayList<Element>();
        Object nodeId = this.dao.getNodeId(this.serviceJid, this.nodeName);
        Assert.assertNotNull((String)"Could not fined nodeId", (Object)nodeId);
        for (int i3 = 0; i3 < 20; ++i3) {
            String itemId = "item-" + i3;
            String payloadCData = "test-payload";
            if (this.checkEmoji) {
                payloadCData = payloadCData + emoji;
                itemId = itemId + emoji;
            }
            Element item4 = new Element("item", new String[]{"id"}, new String[]{itemId});
            item4.addChild((XMLNodeIfc)new Element("payload", payloadCData + "-" + i3, new String[]{"xmlns"}, new String[]{"test-xmlns"}));
            this.dao.writeItem(this.serviceJid, nodeId, System.currentTimeMillis(), itemId, this.senderJid.getBareJID().toString(), item4);
            publishedItems.add(item4);
            Thread.sleep(1500L);
        }
        String[] publishedItemIds = (String[])publishedItems.stream().map(el -> el.getAttributeStaticStr("id")).toArray(String[]::new);
        ArrayList results = new ArrayList();
        Query query = new Query();
        query.setOrder(order);
        query.setComponentJID(JID.jidInstance((BareJID)this.serviceJid));
        query.setQuestionerJID(this.senderJid);
        query.getRsm().setMax(10);
        results.clear();
        this.dao.queryItems(query, Collections.singletonList(nodeId), (query1, item) -> results.add((IPubSubRepository.Item)item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i2 = 0; i2 < 10; ++i2) {
            item3 = (IPubSubRepository.Item)results.get(i2);
            Assert.assertEquals((Object)this.getMAMID(nodeId, publishedItemIds[i2]), (Object)item3.getId());
            Assert.assertEquals(publishedItems.get(i2), (Object)item3.getMessage());
        }
        query.setWith(this.senderJid.copyWithoutResource());
        results.clear();
        this.dao.queryItems(query, Collections.singletonList(nodeId), (query1, item) -> results.add((IPubSubRepository.Item)item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i2 = 0; i2 < 10; ++i2) {
            item3 = (IPubSubRepository.Item)results.get(i2);
            Assert.assertEquals((Object)this.getMAMID(nodeId, publishedItemIds[i2]), (Object)item3.getId());
            Assert.assertEquals(publishedItems.get(i2), (Object)item3.getMessage());
        }
        query.setWith(null);
        String after = ((IPubSubRepository.Item)results.get(4)).getId();
        query.getRsm().setAfter(after);
        results.clear();
        this.dao.queryItems(query, Collections.singletonList(nodeId), (query1, item) -> results.add((IPubSubRepository.Item)item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            item2 = (IPubSubRepository.Item)results.get(i);
            Assert.assertEquals((Object)this.getMAMID(nodeId, publishedItemIds[i + 5]), (Object)item2.getId());
            Assert.assertEquals(publishedItems.get(i + 5), (Object)item2.getMessage());
        }
        query.getRsm().setAfter(null);
        query.getRsm().setHasBefore(true);
        results.clear();
        this.dao.queryItems(query, Collections.singletonList(nodeId), (query1, item) -> results.add((IPubSubRepository.Item)item));
        Assert.assertEquals((long)10L, (long)results.size());
        for (i = 0; i < 10; ++i) {
            item2 = (IPubSubRepository.Item)results.get(i);
            Assert.assertEquals((Object)this.getMAMID(nodeId, publishedItemIds[i + 10]), (Object)item2.getId());
            Assert.assertEquals(publishedItems.get(i + 10), (Object)item2.getMessage());
        }
        Object[] itemsIds = this.dao.getItemsIds(this.serviceJid, nodeId);
        Arrays.sort(itemsIds);
        Object[] tmp = Arrays.copyOf(publishedItemIds, publishedItemIds.length);
        Arrays.sort(tmp);
        Assert.assertArrayEquals((String)"Added item id not listed in list of item ids", (Object[])tmp, (Object[])itemsIds);
        for (String itemId : publishedItemIds) {
            this.dao.deleteItem(this.serviceJid, nodeId, itemId);
            Element el2 = this.dao.getItem(this.serviceJid, nodeId, itemId);
            Assert.assertNull((String)"Element still available in store after removal", (Object)el2);
        }
    }

    protected abstract String getMAMID(Object var1, String var2);

    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        try {
            String xmlRepositoryURI = "memory://xmlRepo?autoCreateUser=true";
            XMLRepository repository = new XMLRepository();
            repository.initRepository(xmlRepositoryURI, null);
            kernel.registerBean("userAuthRepository").asInstance((Object)repository).exportable().exec();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to initialize user/auth repository", ex);
        }
    }
}

