/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.ext.presence;

import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.eventbus.EventBus;
import tigase.eventbus.EventBusFactory;
import tigase.pubsub.modules.ext.presence.PresencePerNodeExtension;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PresencePerNodeExtensionTest {
    private static final BareJID service1 = BareJID.bareJIDInstanceNS((String)"service1.local");
    private static final BareJID service2 = BareJID.bareJIDInstanceNS((String)"service2.local");
    private PresencePerNodeExtension ext;

    @Before
    public void setUp() throws Exception {
        EventBus bus = EventBusFactory.getInstance();
        this.ext = new PresencePerNodeExtension();
        this.ext.setEventBus(bus);
    }

    @Test
    public void testAddPresence01() throws TigaseStringprepException {
        Element presence = new Element("presence");
        presence.setXMLNS("jabber:client");
        presence.setAttribute("from", "a@b.c/d1");
        presence.setAttribute("to", service1.toString());
        this.ext.addPresence(service1, "node1", Packet.packetInstance((Element)presence));
        Collection ocs = this.ext.getNodeOccupants(service1, "node1");
        Assert.assertTrue((String)"Doesn't contains occupant!", (boolean)ocs.contains(JID.jidInstanceNS((String)"a@b.c/d1")));
        ocs = this.ext.getNodeOccupants(service2, "node1");
        Assert.assertTrue((String)"MUST not contains occupants", (boolean)ocs.isEmpty());
        Assert.assertNotNull((String)"Must contains presence", (Object)this.ext.getPresence(service1, "node1", JID.jidInstanceNS((String)"a@b.c/d1")));
        Assert.assertNull((String)"MUST not contain presence", (Object)this.ext.getPresence(service1, "node1", JID.jidInstanceNS((String)"a@b.c/d2")));
        this.ext.removePresence(service1, "node1", JID.jidInstanceNS((String)"a@b.c/d1"), Packet.packetInstance((Element)presence));
        Assert.assertNull((String)"MUST not contain presence", (Object)this.ext.getPresence(service1, "node1", JID.jidInstanceNS((String)"a@b.c/d1")));
        Assert.assertTrue((boolean)this.ext.getNodeOccupants(service1, "node1").isEmpty());
    }

    @Test
    public void testAddPresence02() throws TigaseStringprepException {
        Element presence = new Element("presence");
        presence.setXMLNS("jabber:client");
        presence.setAttribute("from", "a@b.c/d1");
        presence.setAttribute("to", service1.toString());
        this.ext.addPresence(service1, "node1", Packet.packetInstance((Element)presence));
        this.ext.addPresence(service1, "node2", Packet.packetInstance((Element)presence));
        this.ext.addPresence(service1, "node3", Packet.packetInstance((Element)presence));
        this.ext.removePresence(service1, null, JID.jidInstanceNS((String)"a@b.c/d1"), Packet.packetInstance((Element)presence));
        Assert.assertNull((String)"MUST not contain presence", (Object)this.ext.getPresence(service1, "node1", JID.jidInstanceNS((String)"a@b.c/d1")));
        Assert.assertTrue((boolean)this.ext.getNodeOccupants(service1, "node1").isEmpty());
    }
}

