/**
 * Tigase PubSub - Publish Subscribe component for Tigase
 * Copyright (C) 2008 Tigase, Inc. (office@tigase.com)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, version 3 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. Look for COPYING file in the top folder.
 * If not, see http://www.gnu.org/licenses/.
 */
package tigase.pubsub.repository;

import org.junit.Ignore;
import org.junit.Test;

import java.sql.*;
import java.util.*;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;

public class DerbyPubSubDAOTest {

    private static final String uri = "jdbc:derby:memory:myDB;create=true";

    private static Connection[] connections;
    private static PreparedStatement[] preparedStatements;

    @Ignore
    @Test
    public void test() throws SQLException, InterruptedException {
        connections = new Connection[10];
        for (int i=0; i<10; i++) {
            connections[i] = DriverManager.getConnection(uri);
        }

        Statement stmt = connections[0].createStatement();
        stmt.execute("create table tig_pubsub_jids (\n" +
                "\tjid_id bigint generated by default as identity not null,\n" +
                "\tjid varchar(2049) not null,\n" +
                "\tjid_sha1 varchar(50),\n" +
                "\n" +
                "\tprimary key ( jid_id )\n" +
                ")");
        stmt.execute("create table tig_pubsub_items (\n" +
                "\tnode_id bigint not null,\n" +
                "\tid varchar(1024) not null,\n" +
                "\tcreation_date timestamp,\n" +
                "\tpublisher_id bigint references tig_pubsub_jids ( jid_id ),\n" +
                "\tupdate_date timestamp,\n" +
                "\tdata varchar(32672),\n" +
                "\n" +
                "\tprimary key ( node_id, id )\n" +
                ")");

        stmt.execute("create procedure TigPubSubWriteItem(node_id bigint, item_id varchar(1024),\n" +
                "\tpublisher varchar(2049), item_data varchar(32672), ts timestamp)\n" +
                "\tPARAMETER STYLE JAVA\n" +
                "\tLANGUAGE JAVA\n" +
                "\tMODIFIES SQL DATA\n" +
                "\tDYNAMIC RESULT SETS 1\n" +
                "\tEXTERNAL NAME 'tigase.pubsub.repository.derby.StoredProcedures.tigPubSubWriteItem'");
        stmt.close();

        preparedStatements = new PreparedStatement[connections.length];
        for (int i=0; i<preparedStatements.length; i++) {
            preparedStatements[i] = connections[i].prepareCall("{ call TigPubSubWriteItem(?, ?, ?, ?, ?) }");
        }

        List<Callable<Exception>> tasks = new ArrayList<>();

        for (int j=0; j<10; j++) {
            final long nodeId = j;
            final String id = UUID.randomUUID().toString();
            final String publisher = "publisher@test.com";
            final String nodeItem = "item-" + j;

            for (int i = 0; i < preparedStatements.length; i++) {
                final String item = nodeItem + "-" + i;
                final PreparedStatement write_item_sp = preparedStatements[i];
                tasks.add(new Callable<Exception>() {
                    @Override
                    public Exception call() throws Exception {
                        try {
                            synchronized (write_item_sp) {
                                write_item_sp.setLong(1, nodeId);
                                write_item_sp.setString(2, id);
                                write_item_sp.setString(3, publisher);
                                write_item_sp.setString(4, item);
                                write_item_sp.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
                                System.out.println("executing query for " + item);
                                write_item_sp.execute();
                            }
                            return null;
                        } catch (Exception ex) {
                            //assertNull(ex);
                            return ex;
                        }
                    }
                });
            }
        }

        ExecutorService executorService = Executors.newFixedThreadPool(connections.length);//Runtime.getRuntime().availableProcessors() * 4);
        List<Future<Exception>> futures = executorService.invokeAll(tasks);

        executorService.shutdown();

        while (!executorService.isTerminated()) {
            System.out.println("awaiting termination...");
            Thread.sleep(1000);
        }

        List<Exception> list = futures.stream().map(f -> {
            try {
                return f.get();
            } catch (Exception x) {
                return x;
                //throw new RuntimeException(x);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());

        assertEquals(Collections.EMPTY_LIST, list);
    }

}
