/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FragmentedMap<KEY, VALUE> {
    private final Set<Map<KEY, VALUE>> changedFragments = new HashSet<Map<KEY, VALUE>>();
    private final ArrayList<Map<KEY, VALUE>> fragments = new ArrayList();
    private final int maxFragmentSize;
    private final Set<Integer> removedFragmentsIndexes = new HashSet<Integer>();

    public static void main(String[] args) {
        FragmentedMap fm = new FragmentedMap(9999);
        for (int p = 0; p < 1000; ++p) {
            XMap<String, String> x = new XMap<String, String>();
            for (int i = 0; i < 100; ++i) {
                x.put("key-" + p + "." + i, "value-" + p + "." + i);
            }
            fm.addFragment(x);
        }
        System.out.println(super.getLoadFactor());
        fm.defragment();
        System.out.println(super.getLoadFactor());
        fm.defragment();
        System.out.println(super.getLoadFactor());
        System.out.println(fm.getAllValues().size());
    }

    public FragmentedMap(int maxFragmentSize) {
        this.maxFragmentSize = maxFragmentSize;
    }

    public synchronized void addFragment(Map<KEY, VALUE> fragment) {
        if (fragment.size() <= this.maxFragmentSize) {
            XMap<KEY, VALUE> f = new XMap<KEY, VALUE>();
            f.putAll(fragment);
            this.fragments.add(f);
        } else {
            for (Map.Entry<KEY, VALUE> en : fragment.entrySet()) {
                this.put(en.getKey(), en.getValue());
            }
        }
    }

    public synchronized void cleanChangingLog() {
        this.changedFragments.clear();
        this.removedFragmentsIndexes.clear();
    }

    public synchronized void clear() {
        this.changedFragments.clear();
        this.fragments.clear();
        this.removedFragmentsIndexes.clear();
    }

    public synchronized void defragment() {
        this.intDefragment();
        float factor = this.getLoadFactor();
        if ((double)factor < 0.49999) {
            this.optimize();
            this.intDefragment();
        }
    }

    public synchronized VALUE get(KEY key) {
        Map<KEY, VALUE> fragment = this.getFragmentWithKey(key);
        if (fragment != null) {
            return fragment.get(key);
        }
        return null;
    }

    public synchronized Collection<VALUE> getAllValues() {
        HashSet<VALUE> x = new HashSet<VALUE>();
        for (Map<KEY, VALUE> f : this.fragments) {
            x.addAll(f.values());
        }
        return Collections.unmodifiableCollection(x);
    }

    public synchronized Set<Integer> getChangedFragmentIndexes() {
        HashSet<Integer> r = new HashSet<Integer>();
        for (Map<KEY, VALUE> f : this.changedFragments) {
            r.add(this.fragments.indexOf(f));
        }
        return r;
    }

    public synchronized Map<KEY, VALUE> getFragment(int index) {
        return new HashMap<KEY, VALUE>(this.fragments.get(index));
    }

    public synchronized int getFragmentsCount() {
        return this.fragments.size();
    }

    protected Map<KEY, VALUE> getFragmentToNewData() {
        for (Map<KEY, VALUE> f : this.changedFragments) {
            if (f.size() >= this.maxFragmentSize) continue;
            return f;
        }
        for (Map<KEY, VALUE> f : this.fragments) {
            if (f.size() >= this.maxFragmentSize) continue;
            return f;
        }
        return null;
    }

    protected Map<KEY, VALUE> getFragmentWithKey(KEY key) {
        for (Map<KEY, VALUE> f : this.fragments) {
            if (!f.containsKey(key)) continue;
            return f;
        }
        return null;
    }

    private float getLoadFactor() {
        float sum = 0.0f;
        float area = 0.0f;
        if (this.fragments.size() > 1) {
            for (Map<KEY, VALUE> iterable_element : this.fragments) {
                sum += (float)iterable_element.size();
                area += (float)this.maxFragmentSize;
            }
            return sum / area;
        }
        return 1.0f;
    }

    public synchronized Map<KEY, VALUE> getMap() {
        HashMap<KEY, VALUE> result = new HashMap<KEY, VALUE>();
        for (Map<KEY, VALUE> f : this.fragments) {
            result.putAll(f);
        }
        return Collections.unmodifiableMap(result);
    }

    public synchronized Set<Integer> getRemovedFragmentIndexes() {
        return Collections.unmodifiableSet(this.removedFragmentsIndexes);
    }

    private void intDefragment() {
        int size = this.fragments.size();
        Iterator<Map<KEY, VALUE>> iterator = this.fragments.iterator();
        while (iterator.hasNext()) {
            Map<KEY, VALUE> f = iterator.next();
            if (f.size() != 0) continue;
            iterator.remove();
        }
        for (int i = this.fragments.size(); i < size; ++i) {
            this.removedFragmentsIndexes.add(i);
        }
    }

    private void optimize() {
        Iterator<Map.Entry<KEY, VALUE>> iterator = this.getMap().entrySet().iterator();
        HashSet<Map.Entry<KEY, VALUE>> set = new HashSet<Map.Entry<KEY, VALUE>>();
        while (iterator.hasNext()) {
            Map.Entry<KEY, VALUE> p = iterator.next();
            set.add(p);
            this.remove(p.getKey());
        }
        for (Map.Entry entry : set) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized VALUE put(KEY key, VALUE value) {
        Map<KEY, VALUE> fragment = this.getFragmentWithKey(key);
        if (fragment == null && (fragment = this.getFragmentToNewData()) == null) {
            fragment = new XMap<KEY, VALUE>();
            this.fragments.add(fragment);
            int index = this.fragments.indexOf(fragment);
            this.removedFragmentsIndexes.remove(index);
        }
        if (!this.changedFragments.contains(fragment)) {
            this.changedFragments.add(fragment);
        }
        return fragment.put(key, value);
    }

    public synchronized void putAll(Map<KEY, VALUE> fragment) {
        for (Map.Entry<KEY, VALUE> e : fragment.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public synchronized VALUE remove(KEY key) {
        Map<KEY, VALUE> f = this.getFragmentWithKey(key);
        if (f != null) {
            VALUE value = f.remove(key);
            this.changedFragments.add(f);
            return value;
        }
        return null;
    }

    private void showDebug() {
        for (int i = 0; i < this.getFragmentsCount(); ++i) {
            System.out.println(i + ": " + this.getFragment(i));
        }
        System.out.println("C: " + this.getChangedFragmentIndexes());
        System.out.println("R: " + this.removedFragmentsIndexes);
        System.out.println();
    }

    private static class XMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final Object X = new Object();

        private XMap() {
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof XMap) {
                return this.X == ((XMap)o).X;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return this.X.hashCode();
        }
    }
}

