/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.migration;

import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.pubsub.repository.migration.IPubSubOldDAO;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

public class PubSubOldDAO
implements IPubSubOldDAO {
    public static final String CREATION_DATE_KEY = "creation-date";
    private static final String ITEMS_KEY = "items";
    public static final String NODES_KEY = "nodes/";
    private static final String ROOT_COLLECTION_KEY = "root-collection";
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    final UserRepository repository;

    public PubSubOldDAO(UserRepository repository) {
        this.repository = repository;
    }

    @Override
    public IPubSubOldDAO.Item getItem(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        try {
            IPubSubOldDAO.Item item = new IPubSubOldDAO.Item();
            String itemData = this.repository.getData(serviceJid, NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "data");
            char[] data = itemData.toCharArray();
            item.id = id;
            item.publisher = this.getItemPublisher(serviceJid, nodeName, id);
            item.creationDate = this.getItemCreationDate(serviceJid, nodeName, id);
            item.updateDate = this.getItemUpdateDate(serviceJid, nodeName, id);
            item.item = this.itemDataToElement(data);
            return item;
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException("Item reading error", e);
        }
    }

    public Date getItemCreationDate(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        try {
            String tmp = this.repository.getData(serviceJid, NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, CREATION_DATE_KEY);
            if (tmp == null) {
                return null;
            }
            Date d = new Date(Long.parseLong(tmp));
            return d;
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException("Items creation-date reading error", e);
        }
    }

    public String getItemPublisher(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        try {
            return this.repository.getData(serviceJid, NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "publisher");
        }
        catch (Exception e) {
            throw new RepositoryException("Items publisher reading error", e);
        }
    }

    @Override
    public String[] getItemsIds(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            String[] ids = this.repository.getSubnodes(serviceJid, NODES_KEY + nodeName + "/" + ITEMS_KEY);
            return ids;
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException("Items list reading error", e);
        }
    }

    public Date getItemUpdateDate(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        try {
            String tmp = this.repository.getData(serviceJid, NODES_KEY + nodeName + "/" + ITEMS_KEY + "/" + id, "update-date");
            if (tmp == null) {
                return null;
            }
            Date d = new Date(Long.parseLong(tmp));
            return d;
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException("Items update-date reading error", e);
        }
    }

    @Override
    public UsersAffiliation[] getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            String cnfData = this.repository.getData(serviceJid, NODES_KEY + nodeName, "affiliations");
            return NodeAffiliations.create(cnfData).getAffiliations();
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers reading error", e);
        }
    }

    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            Form cnfForm = this.readNodeConfigForm(serviceJid, nodeName);
            if (cnfForm == null) {
                return null;
            }
            NodeType type = NodeType.valueOf(cnfForm.getAsString("pubsub#node_type"));
            Class cl = null;
            switch (type) {
                case collection: {
                    cl = CollectionNodeConfig.class;
                    break;
                }
                case leaf: {
                    cl = LeafNodeConfig.class;
                    break;
                }
                default: {
                    throw new RepositoryException("Unknown node type " + (Object)((Object)type));
                }
            }
            CollectionNodeConfig nc = this.getNodeConfig(cl, nodeName, cnfForm);
            return nc;
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    public <T extends AbstractNodeConfig> T getNodeConfig(Class<T> nodeConfigClass, String nodeName, Form configForm) throws RepositoryException {
        try {
            Constructor<T> constructor = nodeConfigClass.getConstructor(String.class);
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)constructor.newInstance(nodeName);
            nodeConfig.copyFromForm(configForm);
            return (T)nodeConfig;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    @Override
    public Date getNodeCreationDate(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            String tmp = this.repository.getData(serviceJid, NODES_KEY + nodeName, CREATION_DATE_KEY);
            long l = Long.parseLong(tmp);
            return new Date(l);
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (Exception e) {
            throw new RepositoryException("Node creation date getting error", e);
        }
    }

    @Override
    public BareJID getNodeCreator(BareJID serviceJid, String nodeName) throws RepositoryException {
        return serviceJid;
    }

    @Override
    public String[] getNodesList(BareJID serviceJid) throws RepositoryException {
        try {
            String[] nodes = this.repository.getSubnodes(serviceJid, NODES_KEY);
            return nodes;
        }
        catch (UserNotFoundException e1) {
            this.log.log(Level.WARNING, "missing user for service jid = {0}", serviceJid);
            return null;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Nodes list getting error", e);
            throw new RepositoryException("Nodes list getting error", e);
        }
    }

    @Override
    public UsersSubscription[] getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        try {
            NodeSubscriptions ns = NodeSubscriptions.create();
            int index = 0;
            while (true) {
                String key = "subscriptions" + (index == 0 ? "" : "." + index);
                String cnfData = this.repository.getData(serviceJid, NODES_KEY + nodeName, key);
                if (cnfData == null || cnfData.length() == 0) break;
                ns.parse(cnfData);
                ++index;
            }
            return ns.getSubscriptions();
        }
        catch (Exception e) {
            throw new RepositoryException("Node subscribers reading error", e);
        }
    }

    @Override
    public void init() throws RepositoryException {
    }

    protected Element itemDataToElement(char[] data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        return (Element)q.element();
    }

    private Form readNodeConfigForm(BareJID serviceJid, String nodeName) throws UserNotFoundException, TigaseDBException {
        String cnfData = this.readNodeConfigFormData(serviceJid, nodeName);
        if (cnfData == null) {
            return null;
        }
        char[] data = cnfData.toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        if (q != null && q.size() > 0) {
            Form form = new Form((Element)q.element());
            return form;
        }
        return null;
    }

    protected String readNodeConfigFormData(BareJID serviceJid, String nodeName) throws TigaseDBException {
        return this.repository.getData(serviceJid, NODES_KEY + nodeName, "configuration");
    }

    @Override
    public BareJID[] getServiceJids() throws RepositoryException {
        try {
            List users = this.repository.getUsers();
            return users.toArray(new BareJID[users.size()]);
        }
        catch (TigaseDBException ex) {
            throw new RepositoryException("Exception reading service jids", ex);
        }
    }
}

