/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.NodeMeta;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.XMPPServer;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

@Repository.Meta(supportedUris={"jdbc:[^:]+:.*"})
public class PubSubDAOJDBC
extends PubSubDAO<Long> {
    protected Connection conn = null;
    private PreparedStatement conn_valid_st = null;
    private long connectionValidateInterval = 60000L;
    private CallableStatement create_node_sp = null;
    private DataRepository.dbTypes database = null;
    private String db_conn = null;
    private CallableStatement delete_all_nodes_sp = null;
    private CallableStatement delete_item_sp = null;
    private CallableStatement delete_node_subscriptions_sp = null;
    private CallableStatement get_all_nodes_sp = null;
    private CallableStatement get_child_nodes_sp = null;
    private CallableStatement get_item_sp = null;
    private CallableStatement get_node_affiliations_sp = null;
    private CallableStatement get_node_configuration_sp = null;
    private CallableStatement get_node_id_sp = null;
    private CallableStatement get_node_items_ids_since_sp = null;
    private CallableStatement get_node_items_ids_sp = null;
    private CallableStatement get_node_items_meta_sp = null;
    private CallableStatement get_node_meta_sp = null;
    private CallableStatement get_node_subscriptions_sp = null;
    private CallableStatement get_root_nodes_sp = null;
    private CallableStatement get_user_affiliations_sp = null;
    private CallableStatement get_user_subscriptions_sp = null;
    private long lastConnectionValidated = 0L;
    private CallableStatement remove_node_sp = null;
    private CallableStatement remove_service_sp = null;
    private CallableStatement set_node_affiliations_sp = null;
    private CallableStatement set_node_configuration_sp = null;
    private CallableStatement set_node_subscriptions_sp = null;
    private CallableStatement write_item_sp = null;
    private boolean schemaOk = false;

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection() throws SQLException {
        try {
            ResultSet rs = null;
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                try {
                    long tmp = System.currentTimeMillis();
                    if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                        rs = this.conn_valid_st.executeQuery();
                        this.lastConnectionValidated = tmp;
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (Exception e) {
            this.initRepo();
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Long createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, Long collectionId) throws RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 8[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(BareJID serviceJid, Long nodeId, String id) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "deleting Item: serviceJid: {0}, nodeId: {1}, id: {2}", new Object[]{serviceJid, nodeId, id});
        }
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_item_sp;
            synchronized (callableStatement) {
                this.delete_item_sp.setLong(1, (long)nodeId);
                this.delete_item_sp.setString(2, id);
                this.delete_item_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item removing error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(BareJID serviceJid, Long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "deleting Node: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.remove_node_sp;
            synchronized (callableStatement) {
                this.remove_node_sp.setLong(1, (long)nodeId);
                this.remove_node_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node deleting error", e);
        }
    }

    @Override
    public void destroy() {
        try {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "closing JDBC connection: {0} - {1}", new Object[]{this.conn.getClass().getCanonicalName(), this.conn});
            }
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem closing jdbc connection: " + this.db_conn, e);
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "get all nodes list: serviceJid: {0}", new Object[]{serviceJid});
        }
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_all_nodes_sp;
        synchronized (callableStatement) {
            String[] stringArray;
            try {
                this.get_all_nodes_sp.setString(1, serviceJid.toString());
                rs = this.get_all_nodes_sp.executeQuery();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                stringArray = names.toArray(new String[0]);
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RepositoryException("Nodes list getting error", e);
                }
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Date getDateFromItem(BareJID serviceJid, long nodeId, String id, int field) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getting date from item: serviceJid: {0}, nodeId: {1}, id: {2}, field: {3}", new Object[]{serviceJid, nodeId, id, field});
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.get_item_sp;
            synchronized (callableStatement) {
                block7: {
                    Timestamp timestamp;
                    try {
                        this.get_item_sp.setLong(1, nodeId);
                        this.get_item_sp.setString(2, id);
                        rs = this.get_item_sp.executeQuery();
                        if (!rs.next()) break block7;
                        timestamp = rs.getTimestamp(field);
                        this.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.release(null, rs);
                        throw throwable;
                    }
                    return timestamp;
                }
                this.release(null, rs);
                return null;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item field " + field + " reading error", e);
        }
    }

    @Override
    public Element getItem(BareJID serviceJid, Long nodeId, String id) throws RepositoryException {
        String data = this.getStringFromItem(serviceJid, nodeId, id, 1);
        if (data == null) {
            return null;
        }
        return this.itemDataToElement(data.toCharArray());
    }

    @Override
    public Date getItemCreationDate(BareJID serviceJid, Long nodeId, String id) throws RepositoryException {
        return this.getDateFromItem(serviceJid, nodeId, id, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(BareJID serviceJid, Long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "getting items IDs: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        if (null != nodeId) {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_items_ids_sp;
            synchronized (callableStatement) {
                String[] stringArray;
                try {
                    this.get_node_items_ids_sp.setLong(1, (long)nodeId);
                    rs = this.get_node_items_ids_sp.executeQuery();
                    ArrayList<String> ids = new ArrayList<String>();
                    while (rs.next()) {
                        ids.add(rs.getString(1));
                    }
                    stringArray = ids.toArray(new String[ids.size()]);
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    try {
                        this.release(null, rs);
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Items list reading error", e);
                    }
                }
                return stringArray;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIdsSince(BareJID serviceJid, Long nodeId, Date since) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting items since: serviceJid: {0}, nodeId: {1}, since: {2}", new Object[]{serviceJid, nodeId, since});
        }
        ResultSet rs = null;
        Timestamp sinceTs = new Timestamp(since.getTime());
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_items_ids_since_sp;
        synchronized (callableStatement) {
            String[] stringArray;
            try {
                this.get_node_items_ids_since_sp.setLong(1, (long)nodeId);
                this.get_node_items_ids_since_sp.setTimestamp(2, sinceTs);
                rs = this.get_node_items_ids_since_sp.executeQuery();
                ArrayList<String> ids = new ArrayList<String>();
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                stringArray = ids.toArray(new String[ids.size()]);
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RepositoryException("Items list reading error", e);
                }
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, Long nodeId, String nodeName) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting items meta: serviceJid: {0}, nodeId: {1}, nodeName: {2}", new Object[]{serviceJid, nodeId, nodeName});
        }
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_items_meta_sp;
        synchronized (callableStatement) {
            ArrayList<IItems.ItemMeta> arrayList;
            try {
                this.get_node_items_meta_sp.setLong(1, (long)nodeId);
                rs = this.get_node_items_meta_sp.executeQuery();
                ArrayList<IItems.ItemMeta> results = new ArrayList<IItems.ItemMeta>();
                while (rs.next()) {
                    String id = rs.getString(1);
                    Timestamp creationDate = rs.getTimestamp(2);
                    Timestamp updateDate = rs.getTimestamp(3);
                    results.add(new IItems.ItemMeta(nodeName, id, creationDate, updateDate));
                }
                arrayList = results;
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RepositoryException("Items list reading error", e);
                }
            }
            return arrayList;
        }
    }

    @Override
    public Date getItemUpdateDate(BareJID serviceJid, Long nodeId, String id) throws RepositoryException {
        return this.getDateFromItem(serviceJid, nodeId, id, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long getNodeId(BareJID serviceJid, String nodeName) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting Node ID: serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_id_sp;
            synchronized (callableStatement) {
                block9: {
                    Long l;
                    try {
                        this.get_node_id_sp.setString(1, serviceJid.toString());
                        this.get_node_id_sp.setString(2, nodeName);
                        rs = this.get_node_id_sp.executeQuery();
                        if (!rs.next()) break block9;
                        long nodeId = rs.getLong(1);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Getting Node ID: serviceJid: {0}, nodeName: {1}, nodeId: {2}, get_node_id_sp: {3}", new Object[]{serviceJid, nodeName, nodeId, this.get_node_id_sp});
                        }
                        l = nodeId;
                        this.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.release(null, rs);
                        throw throwable;
                    }
                    return l;
                }
                Long l = null;
                this.release(null, rs);
                return l;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Retrieving node id error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeMeta<Long> getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting Node ID: serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_meta_sp;
            synchronized (callableStatement) {
                block9: {
                    NodeMeta<Long> nodeMeta;
                    try {
                        this.get_node_meta_sp.setString(1, serviceJid.toString());
                        this.get_node_meta_sp.setString(2, nodeName);
                        rs = this.get_node_meta_sp.executeQuery();
                        if (!rs.next()) break block9;
                        long nodeId = rs.getLong(1);
                        String configStr = rs.getString(2);
                        String creator = rs.getString(3);
                        Timestamp creationTime = rs.getTimestamp(4);
                        NodeMeta<Long> nodeMeta2 = new NodeMeta<Long>(nodeId, this.parseConfig(nodeName, configStr), creator != null ? BareJID.bareJIDInstance((String)creator) : null, creationTime);
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "Getting Node ID: serviceJid: {0}, nodeName: {1}, nodeId: {2}, get_node_id_sp: {3}", new Object[]{serviceJid, nodeName, nodeId, this.get_node_id_sp});
                        }
                        nodeMeta = nodeMeta2;
                        this.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.release(null, rs);
                        throw throwable;
                    }
                    return nodeMeta;
                }
                NodeMeta<Long> nodeMeta = null;
                this.release(null, rs);
                return nodeMeta;
            }
        }
        catch (SQLException | TigaseStringprepException e) {
            throw new RepositoryException("Retrieving node meta data error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeAffiliations getNodeAffiliations(BareJID serviceJid, Long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting node affiliation: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_affiliations_sp;
        synchronized (callableStatement) {
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations;
            try {
                this.get_node_affiliations_sp.setLong(1, (long)nodeId);
                rs = this.get_node_affiliations_sp.executeQuery();
                ArrayDeque<UsersAffiliation> data = new ArrayDeque<UsersAffiliation>();
                while (rs.next()) {
                    BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                    Affiliation affil = Affiliation.valueOf(rs.getString(2));
                    data.offer(new UsersAffiliation(jid, affil));
                }
                nodeAffiliations = NodeAffiliations.create(data);
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RepositoryException("Node subscribers reading error", e);
                }
            }
            return nodeAffiliations;
        }
    }

    @Override
    public String getNodeConfig(BareJID serviceJid, Long nodeId) throws RepositoryException {
        return this.readNodeConfigFormData(serviceJid, nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting nodes list: serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            if (nodeName == null) {
                CallableStatement callableStatement = this.get_root_nodes_sp;
                synchronized (callableStatement) {
                    String[] stringArray;
                    try {
                        this.get_root_nodes_sp.setString(1, serviceJid.toString());
                        rs = this.get_root_nodes_sp.executeQuery();
                        ArrayList<String> names = new ArrayList<String>();
                        while (rs.next()) {
                            names.add(rs.getString(1));
                        }
                        stringArray = names.toArray(new String[0]);
                        this.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.release(null, rs);
                        throw throwable;
                    }
                    return stringArray;
                }
            }
            CallableStatement callableStatement = this.get_child_nodes_sp;
            synchronized (callableStatement) {
                String[] stringArray;
                try {
                    this.get_child_nodes_sp.setString(1, serviceJid.toString());
                    this.get_child_nodes_sp.setString(2, nodeName);
                    rs = this.get_child_nodes_sp.executeQuery();
                    ArrayList<String> names = new ArrayList<String>();
                    while (rs.next()) {
                        names.add(rs.getString(1));
                    }
                    stringArray = names.toArray(new String[0]);
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
                return stringArray;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Nodes list getting error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSubscriptions getNodeSubscriptions(BareJID serviceJid, Long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting node subscriptions: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        ResultSet rs = null;
        tigase.pubsub.repository.cached.NodeSubscriptions ns = NodeSubscriptions.create();
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_subscriptions_sp;
        synchronized (callableStatement) {
            tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions;
            try {
                this.get_node_subscriptions_sp.setLong(1, (long)nodeId);
                rs = this.get_node_subscriptions_sp.executeQuery();
                ArrayDeque<UsersSubscription> data = new ArrayDeque<UsersSubscription>();
                while (rs.next()) {
                    BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                    Subscription subscr = Subscription.valueOf(rs.getString(2));
                    String subscrId = rs.getString(3);
                    data.offer(new UsersSubscription(jid, subscrId, subscr));
                }
                ns.init(data);
                nodeSubscriptions = ns;
                this.release(null, rs);
            }
            catch (Throwable throwable) {
                try {
                    this.release(null, rs);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RepositoryException("Node subscribers reading error", e);
                }
            }
            return nodeSubscriptions;
        }
    }

    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.getNodesList(serviceJid, nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getStringFromItem(BareJID serviceJid, long nodeId, String id, int field) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting string from item: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.get_item_sp;
            synchronized (callableStatement) {
                block8: {
                    String string;
                    try {
                        this.get_item_sp.setLong(1, nodeId);
                        this.get_item_sp.setString(2, id);
                        rs = this.get_item_sp.executeQuery();
                        if (!rs.next()) break block8;
                        string = rs.getString(field);
                        this.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.release(null, rs);
                        throw throwable;
                    }
                    return string;
                }
                String string = null;
                this.release(null, rs);
                return string;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item field " + field + " reading error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting user affiliation: serviceJid: {0}, jid: {1}", new Object[]{serviceJid, jid});
        }
        try {
            ResultSet rs = null;
            HashMap<String, UsersAffiliation> result = new HashMap<String, UsersAffiliation>();
            CallableStatement callableStatement = this.get_user_affiliations_sp;
            synchronized (callableStatement) {
                try {
                    this.get_user_affiliations_sp.setString(1, serviceJid.toString());
                    this.get_user_affiliations_sp.setString(2, jid.toString());
                    rs = this.get_user_affiliations_sp.executeQuery();
                    while (rs.next()) {
                        String nodeName = rs.getString(1);
                        Affiliation affil = Affiliation.valueOf(rs.getString(2));
                        result.put(nodeName, new UsersAffiliation(jid, affil));
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new RepositoryException("User affiliations reading error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting user subs: serviceJid: {0}, jid: {1}", new Object[]{serviceJid, jid});
        }
        try {
            ResultSet rs = null;
            HashMap<String, UsersSubscription> result = new HashMap<String, UsersSubscription>();
            CallableStatement callableStatement = this.get_user_subscriptions_sp;
            synchronized (callableStatement) {
                try {
                    this.get_user_subscriptions_sp.setString(1, serviceJid.toString());
                    this.get_user_subscriptions_sp.setString(2, jid.toString());
                    rs = this.get_user_subscriptions_sp.executeQuery();
                    while (rs.next()) {
                        String nodeName = rs.getString(1);
                        Subscription subscr = Subscription.valueOf(rs.getString(2));
                        String subscrId = rs.getString(3);
                        result.put(nodeName, new UsersSubscription(jid, subscrId, subscr));
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new RepositoryException("User affiliations reading error", e);
        }
    }

    private void checkSchema() {
        if (this.schemaOk) {
            return;
        }
        try {
            CallableStatement testCall = this.conn.prepareCall("{ call TigPubSubGetNodeMeta(?,?) }");
            testCall.setString(1, "tigase-pubsub");
            testCall.setString(2, "tigase-pubsub");
            testCall.execute();
            testCall.close();
            this.schemaOk = true;
        }
        catch (Exception ex) {
            String[] msg = new String[]{"", "  ---------------------------------------------", "  ERROR! Terminating the server process.", "  PubSub Component is not compatible with", "  database schema which exists in", "  " + this.db_conn, "  This component uses newer schema. To continue", "  use of currently deployed schema, please use", "  older version of PubSub Component.", "  To convert database to new schema please see:", "  https://projects.tigase.org/projects/tigase-pubsub/wiki/PubSub_database_schema_conversion"};
            if (XMPPServer.isOSGi()) {
                for (String line : msg) {
                    log.log(Level.SEVERE, line);
                }
            } else {
                for (String line : msg) {
                    System.out.println(line);
                }
            }
            log.log(Level.FINEST, "Exception during checkSchema: ", ex);
            System.exit(1);
        }
    }

    public void initRepository(String resource_uri, Map<String, String> params) throws DBInitException {
        this.db_conn = resource_uri;
        if (this.db_conn.startsWith("jdbc:postgresql")) {
            this.database = DataRepository.dbTypes.postgresql;
        } else if (this.db_conn.startsWith("jdbc:mysql")) {
            this.database = DataRepository.dbTypes.mysql;
        } else if (this.db_conn.startsWith("jdbc:derby")) {
            this.database = DataRepository.dbTypes.derby;
        } else if (this.db_conn.startsWith("jdbc:jtds:sqlserver")) {
            this.database = DataRepository.dbTypes.jtds;
        } else if (this.db_conn.startsWith("jdbc:sqlserver")) {
            this.database = DataRepository.dbTypes.sqlserver;
        }
        try {
            this.initRepo();
        }
        catch (SQLException e) {
            this.conn = null;
            throw new DBInitException("Problem initializing jdbc connection: " + this.db_conn, (Throwable)e);
        }
    }

    private void initPreparedStatements() throws SQLException {
        String query;
        switch (this.database) {
            case derby: {
                query = "VALUES 1";
                break;
            }
            default: {
                query = "select 1";
            }
        }
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "{ call TigPubSubCreateNode(?, ?, ?, ?, ?, ?) }";
        this.create_node_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubRemoveNode(?) }";
        this.remove_node_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubRemoveService(?) }";
        this.remove_service_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeId(?, ?) }";
        this.get_node_id_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeMeta(?, ?) }";
        this.get_node_meta_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetItem(?, ?) }";
        this.get_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubWriteItem(?, ?, ?, ?) }";
        this.write_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteItem(?, ?) }";
        this.delete_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeItemsIds(?) }";
        this.get_node_items_ids_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeItemsIdsSince(?,?) }";
        this.get_node_items_ids_since_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeItemsMeta(?) }";
        this.get_node_items_meta_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetAllNodes(?) }";
        this.get_all_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetRootNodes(?) }";
        this.get_root_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetChildNodes(?,?) }";
        this.get_child_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteAllNodes(?) }";
        this.delete_all_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeConfiguration(?, ?, ?) }";
        this.set_node_configuration_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeAffiliation(?, ?, ?) }";
        this.set_node_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeConfiguration(?) }";
        this.get_node_configuration_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeAffiliations(?) }";
        this.get_node_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeSubscriptions(?) }";
        this.get_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeSubscription(?, ?, ?, ?) }";
        this.set_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteNodeSubscription(?, ?) }";
        this.delete_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetUserAffiliations(?, ?) }";
        this.get_user_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetUserSubscriptions(?, ?) }";
        this.get_user_subscriptions_sp = this.conn.prepareCall(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            if (this.conn != null) {
                try {
                    if (!this.conn.isClosed()) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "closing JDBC connection: {0}", this.conn);
                        }
                        this.conn.close();
                    }
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "Exception occured while closing old DB connection for reinitialization", ex);
                }
            }
            String driverClass = null;
            switch (this.database) {
                case postgresql: {
                    driverClass = "org.postgresql.Driver";
                    break;
                }
                case mysql: {
                    driverClass = "com.mysql.jdbc.Driver";
                    break;
                }
                case derby: {
                    driverClass = "org.apache.derby.jdbc.EmbeddedDriver";
                    break;
                }
                case jtds: {
                    driverClass = "net.sourceforge.jtds.jdbc.Driver";
                    break;
                }
                case sqlserver: {
                    driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                    break;
                }
                default: {
                    driverClass = "net.sf.log4jdbc.sql.jdbcapi.DriverSpy";
                }
            }
            try {
                Class.forName(driverClass, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                log.log(Level.SEVERE, null, ex);
            }
            this.conn = DriverManager.getConnection(this.db_conn);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "establishing JDBC connection: {0} for {1}", new Object[]{this.conn, this.db_conn});
            }
            this.checkSchema();
            this.initPreparedStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readNodeConfigFormData(BareJID serviceJid, long nodeId) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "reding node config: serviceJid: {0}, nodeId: {1}", new Object[]{serviceJid, nodeId});
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_configuration_sp;
            synchronized (callableStatement) {
                block8: {
                    String string;
                    try {
                        this.get_node_configuration_sp.setLong(1, nodeId);
                        rs = this.get_node_configuration_sp.executeQuery();
                        if (!rs.next()) break block8;
                        string = rs.getString(1);
                        this.release(null, rs);
                    }
                    catch (Throwable throwable) {
                        this.release(null, rs);
                        throw throwable;
                    }
                    return string;
                }
                String string = null;
                this.release(null, rs);
                return string;
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers reading error", e);
        }
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFromRootCollection(BareJID serviceJid) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_all_nodes_sp;
            synchronized (callableStatement) {
                this.delete_all_nodes_sp.setString(1, serviceJid.toString());
                this.delete_all_nodes_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Removing root collection error", e);
        }
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, Long nodeId) throws RepositoryException {
        this.deleteNode(serviceJid, nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeSubscription(BareJID serviceJid, Long nodeId, BareJID jid) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_node_subscriptions_sp;
            synchronized (callableStatement) {
                this.delete_node_subscriptions_sp.setLong(1, (long)nodeId);
                this.delete_node_subscriptions_sp.setString(2, jid.toString());
                this.delete_node_subscriptions_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers fragment removing error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeService(BareJID serviceJid) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.remove_service_sp;
            synchronized (callableStatement) {
                this.remove_service_sp.setString(1, serviceJid.toString());
                this.remove_service_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers fragment removing error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeAffiliation(BareJID serviceJid, Long nodeId, String nodeName, UsersAffiliation affiliation) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node affiliation[1]: " + nodeName + " / " + affiliation);
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_affiliations_sp;
            synchronized (callableStatement) {
                try {
                    this.set_node_affiliations_sp.setLong(1, (long)nodeId);
                    this.set_node_affiliations_sp.setString(2, affiliation.getJid().toString());
                    this.set_node_affiliations_sp.setString(3, affiliation.getAffiliation().name());
                    switch (this.database) {
                        case mysql: {
                            rs = this.set_node_affiliations_sp.executeQuery();
                            break;
                        }
                        default: {
                            this.set_node_affiliations_sp.execute();
                        }
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node affiliation[2]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(BareJID serviceJid, Long nodeId, String serializedData, Long collectionId) throws RepositoryException {
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_configuration_sp;
            synchronized (callableStatement) {
                try {
                    this.set_node_configuration_sp.setLong(1, (long)nodeId);
                    this.set_node_configuration_sp.setString(2, serializedData);
                    if (collectionId == null) {
                        this.set_node_configuration_sp.setNull(3, -5);
                    } else {
                        this.set_node_configuration_sp.setLong(3, (long)collectionId);
                    }
                    switch (this.database) {
                        case mysql: {
                            rs = this.set_node_configuration_sp.executeQuery();
                            break;
                        }
                        default: {
                            this.set_node_configuration_sp.execute();
                        }
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node configuration writing error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeSubscription(BareJID serviceJid, Long nodeId, String nodeName, UsersSubscription subscription) throws RepositoryException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node subscriptions[1]: " + nodeName + " / " + subscription);
        }
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_subscriptions_sp;
            synchronized (callableStatement) {
                try {
                    this.set_node_subscriptions_sp.setLong(1, (long)nodeId);
                    this.set_node_subscriptions_sp.setString(2, subscription.getJid().toString());
                    this.set_node_subscriptions_sp.setString(3, subscription.getSubscription().name());
                    this.set_node_subscriptions_sp.setString(4, subscription.getSubid());
                    switch (this.database) {
                        case mysql: {
                            rs = this.set_node_subscriptions_sp.executeQuery();
                            break;
                        }
                        default: {
                            this.set_node_subscriptions_sp.execute();
                        }
                    }
                    this.release(null, rs);
                }
                catch (Throwable throwable) {
                    this.release(null, rs);
                    throw throwable;
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Updating node subscriptions[2]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(BareJID serviceJid, Long nodeId, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        try {
            ResultSet rs = null;
            this.checkConnection();
            CallableStatement callableStatement = this.write_item_sp;
            synchronized (callableStatement) {
                try {
                    this.write_item_sp.setLong(1, (long)nodeId);
                    this.write_item_sp.setString(2, id);
                    this.write_item_sp.setString(3, publisher);
                    this.write_item_sp.setString(4, item.toString());
                    if (this.db_conn != null) {
                        this.write_item_sp.execute();
                    }
                }
                finally {
                    this.release(null, rs);
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item writing error", e);
        }
    }
}

