/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.ext.presence;

import java.util.Collection;
import java.util.logging.Level;
import tigase.component2.PacketWriter;
import tigase.component2.exceptions.ComponentException;
import tigase.criteria.Criteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.ext.presence.PresencePerNodeExtension;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PresenceNotifierModule
extends AbstractPubSubModule {
    private final PresencePerNodeExtension presencePerNodeExtension;
    private final PublishItemModule publishItemModule;

    public PresenceNotifierModule(PubSubConfig config, PacketWriter packetWriter, PublishItemModule publishItemModule) {
        super(config, packetWriter);
        this.presencePerNodeExtension = new PresencePerNodeExtension(config, packetWriter);
        this.publishItemModule = publishItemModule;
        this.presencePerNodeExtension.addLoginToNodeHandler(new PresencePerNodeExtension.LoginToNodeHandler(){

            @Override
            public void onLoginToNode(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
                PresenceNotifierModule.this.onLoginToNode(serviceJID, node, occupantJID, presenceStanza);
            }
        });
        this.presencePerNodeExtension.addLogoffFromNodeHandler(new PresencePerNodeExtension.LogoffFromNodeHandler(){

            @Override
            public void onLogoffFromNode(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
                PresenceNotifierModule.this.onLogoffFromNode(serviceJID, node, occupantJID, presenceStanza);
            }
        });
        this.presencePerNodeExtension.addUpdatePresenceHandler(new PresencePerNodeExtension.UpdatePresenceHandler(){

            @Override
            public void onPresenceUpdate(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
                PresenceNotifierModule.this.onPresenceUpdate(serviceJID, node, occupantJID, presenceStanza);
            }
        });
    }

    protected Element createPresenceNotificationItem(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
        Element notification = new Element("presence");
        notification.setAttribute("xmlns", "tigase:pubsub:1");
        notification.setAttribute("node", node);
        notification.setAttribute("jid", occupantJID.toString());
        if (presenceStanza == null || presenceStanza.getType() == StanzaType.unavailable) {
            notification.setAttribute("type", "unavailable");
        } else if (presenceStanza.getType() == StanzaType.available) {
            notification.setAttribute("type", "available");
        }
        return notification;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"tigase:pubsub:1"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return null;
    }

    public PresencePerNodeExtension getPresencePerNodeExtension() {
        return this.presencePerNodeExtension;
    }

    protected void onLoginToNode(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
        try {
            Element notification = this.createPresenceNotificationItem(serviceJID, node, occupantJID, presenceStanza);
            this.publish(serviceJID, node, notification);
            this.publishToOne(serviceJID, node, occupantJID);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on sending LoginToNodeEvent", e);
        }
    }

    protected void onLogoffFromNode(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
        try {
            Element notification = this.createPresenceNotificationItem(serviceJID, node, occupantJID, presenceStanza);
            this.publish(serviceJID, node, notification);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on sending LogoffFromNodeEvent", e);
        }
    }

    protected void onPresenceUpdate(BareJID serviceJID, String node, JID occupantJID, Packet presenceStanza) {
    }

    @Override
    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
    }

    protected void publish(BareJID serviceJID, String nodeName, Element itemToSend) throws RepositoryException {
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJID, nodeName);
        IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(serviceJID, nodeName);
        ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(serviceJID, nodeName);
        Element items = new Element("items");
        items.addAttribute("node", nodeName);
        Element item = new Element("item");
        items.addChild((XMLNodeIfc)item);
        item.addChild((XMLNodeIfc)itemToSend);
        this.publishItemModule.sendNotifications(items, JID.jidInstance((BareJID)serviceJID), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions);
    }

    protected void publishToOne(BareJID serviceJID, String nodeName, JID destinationJID) throws RepositoryException {
        AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(serviceJID, nodeName);
        Collection<JID> occupants = this.presencePerNodeExtension.getNodeOccupants(serviceJID, nodeName);
        for (JID jid : occupants) {
            Packet p;
            if (jid.equals((Object)destinationJID) || (p = this.presencePerNodeExtension.getPresence(serviceJID, nodeName, jid)) == null) continue;
            Element items = new Element("items");
            items.addAttribute("node", nodeName);
            Element item = new Element("item");
            items.addChild((XMLNodeIfc)item);
            item.addChild((XMLNodeIfc)this.createPresenceNotificationItem(serviceJID, nodeName, jid, p));
            this.publishItemModule.sendNotifications(new JID[]{destinationJID}, items, JID.jidInstance((BareJID)serviceJID), nodeConfig, nodeName, null);
        }
    }
}

