/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.logging.Logger;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdhHocRequest;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventType;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;

public class DefaultConfigCommand
implements AdHocCommand {
    private final PubSubConfig config;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final UserRepository userRepository;

    public DefaultConfigCommand(PubSubConfig config, UserRepository userRepository) {
        this.config = config;
        this.userRepository = userRepository;
    }

    public void addDefaultNodeConfigurationChangedHandler(DefaultNodeConfigurationChangedHandler handler) {
        this.config.getEventBus().addHandler(DefaultNodeConfigurationChangedHandler.DefaultNodeConfigurationChangedEvent.TYPE, handler);
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                LeafNodeConfig defaultNodeConfig = new LeafNodeConfig("default");
                defaultNodeConfig.read(this.userRepository, this.config, "default-node-config");
                response.getElements().add(defaultNodeConfig.getFormElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    LeafNodeConfig nodeConfig = new LeafNodeConfig("default");
                    nodeConfig.read(this.userRepository, this.config, "default-node-config");
                    NodeConfigModule.parseConf(nodeConfig, request.getCommand(), this.config);
                    nodeConfig.write(this.userRepository, this.config, "default-node-config");
                    DefaultNodeConfigurationChangedHandler.DefaultNodeConfigurationChangedEvent event = new DefaultNodeConfigurationChangedHandler.DefaultNodeConfigurationChangedEvent(request.getIq(), this.config);
                    this.config.getEventBus().fire(event);
                    Form f = new Form("result", "Info", "Default config saved.");
                    response.getElements().add(f.getElement());
                    response.completeSession();
                }
                response.completeSession();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Default config";
    }

    @Override
    public String getNode() {
        return "default-config";
    }

    public void removeDefaultNodeConfigurationChangedHandler(DefaultNodeConfigurationChangedHandler handler) {
        this.config.getEventBus().remove(DefaultNodeConfigurationChangedHandler.DefaultNodeConfigurationChangedEvent.TYPE, handler);
    }

    public static interface DefaultNodeConfigurationChangedHandler
    extends EventHandler {
        public void onDefaultConfigurationChanged(Packet var1, PubSubConfig var2);

        public static class DefaultNodeConfigurationChangedEvent
        extends Event<DefaultNodeConfigurationChangedHandler> {
            public static final EventType<DefaultNodeConfigurationChangedHandler> TYPE = new EventType();
            private PubSubConfig config;
            private final Packet packet;

            public DefaultNodeConfigurationChangedEvent(Packet packet, PubSubConfig config) {
                super(TYPE);
                this.packet = packet;
                this.config = config;
            }

            @Override
            protected void dispatch(DefaultNodeConfigurationChangedHandler handler) {
                handler.onDefaultConfigurationChanged(this.packet, this.config);
            }
        }
    }
}

