/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.TimeZone;
import tigase.component2.PacketWriter;
import tigase.component2.modules.ModulesManager;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class DiscoverInfoModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"));
    private final SimpleDateFormat formatter;
    private final ModulesManager modulesManager;

    public DiscoverInfoModule(PubSubConfig config, PacketWriter packetWriter, ModulesManager modulesManager) {
        super(config, packetWriter);
        this.modulesManager = modulesManager;
        this.formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            Element element = packet.getElement();
            JID senderJid = packet.getStanzaFrom();
            Element query = element.getChild("query", "http://jabber.org/protocol/disco#info");
            String nodeName = query.getAttributeStaticStr("node");
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet resultIq = packet.okResult(resultQuery, 0);
            if (nodeName == null) {
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type", "name"}, new String[]{"pubsub", "service", "Publish-Subscribe"}));
                for (String f : this.modulesManager.getFeatures()) {
                    resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{f}));
                }
            } else {
                boolean allowed;
                INodeMeta nodeMeta = this.getRepository().getNodeMeta(packet.getStanzaTo().getBareJID(), nodeName);
                if (nodeMeta == null) {
                    throw new PubSubException(Authorization.ITEM_NOT_FOUND);
                }
                AbstractNodeConfig nodeConfigClone = nodeMeta.getNodeConfig().clone();
                boolean bl = allowed = senderJid == null || nodeConfigClone == null ? true : Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfigClone.getDomains());
                if (!allowed) {
                    throw new PubSubException(Authorization.FORBIDDEN);
                }
                resultQuery.addChild((XMLNodeIfc)new Element("identity", new String[]{"category", "type"}, new String[]{"pubsub", nodeConfigClone.getNodeType().name()}));
                resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/pubsub"}));
                Form form = nodeConfigClone.getForm();
                form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#meta-data"));
                ArrayList<String> owners = new ArrayList<String>();
                ArrayList<String> publishers = new ArrayList<String>();
                IAffiliations affiliations = this.getRepository().getNodeAffiliations(packet.getStanzaTo().getBareJID(), nodeName);
                block11: for (UsersAffiliation affiliation : affiliations.getAffiliations()) {
                    if (affiliation.getAffiliation() == null) continue;
                    switch (affiliation.getAffiliation()) {
                        case owner: {
                            owners.add(affiliation.getJid().toString());
                            continue block11;
                        }
                        case publisher: {
                            publishers.add(affiliation.getJid().toString());
                            continue block11;
                        }
                    }
                }
                form.addField(Field.fieldJidMulti((String)"pubsub#owner", (String[])owners.toArray(new String[owners.size()]), (String)"Node owners"));
                form.addField(Field.fieldJidMulti((String)"pubsub#publisher", (String[])publishers.toArray(new String[publishers.size()]), (String)"Publishers to this node"));
                BareJID creator = nodeMeta.getCreator();
                String creationDateStr = "";
                if (nodeMeta.getCreationTime() != null) {
                    SimpleDateFormat simpleDateFormat = this.formatter;
                    synchronized (simpleDateFormat) {
                        creationDateStr = this.formatter.format(nodeMeta.getCreationTime());
                    }
                }
                form.addField(Field.fieldJidSingle((String)"pubsub#creator", (String)(creator != null ? creator.toString() : ""), (String)"Node creator"));
                form.addField(Field.fieldTextSingle((String)"pubsub#creation_date", (String)creationDateStr, (String)"Creation date"));
                resultQuery.addChild((XMLNodeIfc)form.getElement());
            }
            this.packetWriter.write(resultIq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

