/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.HashMap;
import java.util.Map;
import tigase.component2.AbstractComponent;
import tigase.component2.ComponentConfig;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.sys.TigaseRuntime;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PubSubConfig
extends ComponentConfig {
    private static final String PUBSUB_HIGH_MEMORY_USAGE_LEVEL_KEY = "pubsub-high-memory-usage-level";
    private static final String PUBSUB_LOW_MEMORY_DELAY_KEY = "pubsub-low-memory-delay";
    private static final String PUBSUB_PERSISTENT_PEP_KEY = "persistent-pep";
    private static final String PUBSUB_PEP_REMOVE_EMPTY_GEOLOC_KEY = "pep-remove-empty-geoloc";
    private static final String PUBSUB_SEND_LAST_PUBLISHED_ITEM_ON_PRESECE_KEY = "send-last-published-item-on-presence";
    private static final int DEF_PUBSUB_HIGH_MEMORY_USAGE_LEVEL_VAL = 90;
    private static final long DEF_PUBSUB_LOW_MEMORY_DELAY_VAL = 1000L;
    private static final boolean DEF_PUBSUB_PEP_REMOVE_EMPTY_GEOLOC_VAL = false;
    protected String[] admins;
    protected IPubSubRepository pubSubRepository;
    protected BareJID serviceBareJID = BareJID.bareJIDInstanceNS((String)"tigase-pubsub");
    private long lowMemoryDelay = 1000L;
    private float highMemoryUsageLevel = 90.0f;
    private boolean persistentPep = false;
    private boolean pepRemoveEmptyGeoloc = false;
    private boolean sendLastPublishedItemOnPresence = false;

    public PubSubConfig(AbstractComponent<?> component) {
        super(component);
    }

    public String[] getAdmins() {
        return this.admins;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put(PUBSUB_HIGH_MEMORY_USAGE_LEVEL_KEY, 90);
        props.put(PUBSUB_LOW_MEMORY_DELAY_KEY, 1000L);
        props.put(PUBSUB_PEP_REMOVE_EMPTY_GEOLOC_KEY, false);
        return props;
    }

    public long getDelayOnLowMemory() {
        if (this.isHighMemoryUsage()) {
            return this.lowMemoryDelay;
        }
        return 0L;
    }

    public IPubSubRepository getPubSubRepository() {
        return this.pubSubRepository;
    }

    public BareJID getServiceBareJID() {
        return this.serviceBareJID;
    }

    public JID getComponentJID() {
        return this.component.getComponentId();
    }

    public boolean isAdmin(BareJID jid) {
        if (jid == null || this.admins == null) {
            return false;
        }
        for (String adj : this.admins) {
            if (!jid.toString().equals(adj)) continue;
            return true;
        }
        return this.component.isTrusted(jid.toString());
    }

    public boolean isAdmin(JID jid) {
        return this.isAdmin(jid.getBareJID());
    }

    public void setAdmins(String[] strings) {
        this.admins = strings;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey(PUBSUB_LOW_MEMORY_DELAY_KEY)) {
            this.lowMemoryDelay = (Long)props.get(PUBSUB_LOW_MEMORY_DELAY_KEY);
        }
        if (props.containsKey(PUBSUB_HIGH_MEMORY_USAGE_LEVEL_KEY)) {
            this.highMemoryUsageLevel = ((Integer)props.get(PUBSUB_HIGH_MEMORY_USAGE_LEVEL_KEY)).floatValue();
        }
        if (props.containsKey(PUBSUB_PERSISTENT_PEP_KEY)) {
            this.persistentPep = (Boolean)props.get(PUBSUB_PERSISTENT_PEP_KEY);
        }
        if (props.containsKey(PUBSUB_PEP_REMOVE_EMPTY_GEOLOC_KEY)) {
            this.pepRemoveEmptyGeoloc = (Boolean)props.get(PUBSUB_PEP_REMOVE_EMPTY_GEOLOC_KEY);
        }
        if (props.containsKey(PUBSUB_SEND_LAST_PUBLISHED_ITEM_ON_PRESECE_KEY)) {
            this.sendLastPublishedItemOnPresence = (Boolean)props.get(PUBSUB_SEND_LAST_PUBLISHED_ITEM_ON_PRESECE_KEY);
        }
    }

    void setPubSubRepository(IPubSubRepository pubSubRepository) {
        this.pubSubRepository = pubSubRepository;
    }

    private boolean isHighMemoryUsage() {
        return TigaseRuntime.getTigaseRuntime().getHeapMemUsage() > this.highMemoryUsageLevel;
    }

    public boolean isPepPeristent() {
        return this.persistentPep;
    }

    public boolean isPepRemoveEmptyGeoloc() {
        return this.pepRemoveEmptyGeoloc;
    }

    public boolean isSendLastPublishedItemOnPresence() {
        return this.sendLastPublishedItemOnPresence;
    }
}

