/*
 * Decompiled with CFR 0.152.
 */
package tigase.component2;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component2.ComponentConfig;
import tigase.component2.PacketWriter;
import tigase.component2.eventbus.DefaultEventBus;
import tigase.component2.eventbus.EventBus;
import tigase.component2.exceptions.ComponentException;
import tigase.component2.modules.Module;
import tigase.component2.modules.ModulesManager;
import tigase.conf.ConfigurationException;
import tigase.disco.XMPPService;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.StanzaType;

public abstract class AbstractComponent<T extends ComponentConfig>
extends AbstractMessageReceiver
implements XMPPService {
    protected final T componentConfig;
    private final PacketWriter DEFAULT_WRITER = new PacketWriter(){

        @Override
        public void write(Collection<Packet> elements) {
            if (elements != null) {
                for (Packet element : elements) {
                    if (element == null) continue;
                    this.write(element);
                }
            }
        }

        @Override
        public void write(Packet packet) {
            if (AbstractComponent.this.log.isLoggable(Level.FINER)) {
                if (AbstractComponent.this.log.isLoggable(Level.FINEST) && packet.getXMLNS() == null) {
                    try {
                        throw new Exception("Missing XMLNS");
                    }
                    catch (Exception ex) {
                        AbstractComponent.this.log.log(Level.WARNING, "sending packet with not XMLNS set, should not occur, packet = " + packet.toString(), ex);
                    }
                }
                AbstractComponent.this.log.finer("Sent: " + packet.getElement());
            }
            AbstractComponent.this.addOutPacket(packet);
        }
    };
    protected final EventBus eventBus = new DefaultEventBus();
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected final ModulesManager modulesManager = new ModulesManager();
    private final PacketWriter writer;

    public AbstractComponent() {
        this(null);
    }

    public AbstractComponent(PacketWriter writer) {
        this.writer = writer != null ? writer : this.DEFAULT_WRITER;
        this.componentConfig = this.createComponentConfigInstance(this);
    }

    protected abstract T createComponentConfigInstance(AbstractComponent<?> var1);

    public synchronized void everyHour() {
        super.everyHour();
        this.modulesManager.everyHour();
    }

    public synchronized void everyMinute() {
        super.everyMinute();
        this.modulesManager.everyMinute();
    }

    public synchronized void everySecond() {
        super.everySecond();
        this.modulesManager.everySecond();
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        Map<String, Object> x = ((ComponentConfig)this.componentConfig).getDefaults(props);
        if (x != null) {
            props.putAll(x);
        }
        return props;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    protected PacketWriter getWriter() {
        return this.writer;
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        this.modulesManager.getStatistics(this.getName(), list);
    }

    public abstract boolean isDiscoNonAdmin();

    public boolean isRegistered(Class<? extends Module> moduleClass) {
        return this.modulesManager.isRegistered(moduleClass);
    }

    protected void processCommandPacket(Packet packet) {
        ArrayDeque results = new ArrayDeque();
        this.processScriptCommand(packet, results);
        if (results.size() > 0) {
            for (Packet res : results) {
                this.addOutPacketNB(res);
            }
        }
    }

    public void processPacket(Packet packet) {
        this.processStanzaPacket(packet);
    }

    protected void processStanzaPacket(Packet packet) {
        try {
            boolean handled = this.modulesManager.process(packet, this.getWriter());
            if (!handled) {
                StanzaType type;
                String t = packet.getElement().getAttributeStaticStr("type");
                StanzaType stanzaType = type = t == null ? null : StanzaType.valueof((String)t);
                if (type != StanzaType.error) {
                    throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(packet.getElemName() + " stanza with type='error' ignored");
                }
            }
        }
        catch (TigaseStringprepException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessage() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, new ComponentException(Authorization.JID_MALFORMED));
        }
        catch (ComponentException e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, e.getMessageWithPosition() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, e);
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.SEVERE)) {
                this.log.log(Level.SEVERE, e.getMessage() + " when processing " + packet.toString(), e);
            }
            this.sendException(packet, new ComponentException(Authorization.INTERNAL_SERVER_ERROR));
        }
    }

    public <M extends Module> M registerModule(M module) {
        return this.modulesManager.register(module, false);
    }

    public <M extends Module> M registerModule(M module, boolean skipIfRegistered) {
        return this.modulesManager.register(module, skipIfRegistered);
    }

    protected void sendException(Packet packet, ComponentException e) {
        block5: {
            try {
                String t = packet.getElement().getAttributeStaticStr("type");
                if (t != null && t == "error") {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer(packet.getElemName() + " stanza already with type='error' ignored");
                    }
                    return;
                }
                Packet result = e.makeElement(packet, true);
                Element el = result.getElement();
                el.setXMLNS("jabber:client");
                el.setAttribute("from", BareJID.bareJIDInstance((String)el.getAttributeStaticStr("from")).toString());
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Sending back: " + result.toString());
                }
                this.getWriter().write(result);
            }
            catch (Exception e1) {
                if (!this.log.isLoggable(Level.WARNING)) break block5;
                this.log.log(Level.WARNING, "Problem during generate error response", e1);
            }
        }
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        ((ComponentConfig)this.componentConfig).setProperties(props);
    }

    public void updateServiceEntity() {
        super.updateServiceEntity();
        this.updateServiceDiscoveryItem(this.getName(), null, this.getDiscoDescription(), !this.isDiscoNonAdmin());
    }
}

