/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.NodeType;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.Items;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.stats.Counter;
import tigase.stats.StatisticHolder;
import tigase.stats.StatisticHolderImpl;
import tigase.stats.StatisticsList;
import tigase.xmpp.BareJID;
import tigase.xmpp.impl.roster.RosterElement;

public class CachedPubSubRepository<T>
implements IPubSubRepository,
StatisticHolder {
    public static final long MAX_WRITE_DELAY = 15000L;
    protected final IPubSubDAO<T> dao;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final Integer maxCacheSize;
    private final StatisticHolder cacheStats;
    protected final Map<String, Node> nodes;
    private long nodes_added = 0L;
    private long repo_writes = 0L;
    private final ConcurrentHashMap<BareJID, Set<String>> rootCollection = new ConcurrentHashMap();
    private NodeSaver nodeSaver;
    private long updateSubscriptionsCalled = 0L;
    private long writingTime = 0L;
    private final Map<String, StatisticHolder> stats;

    public CachedPubSubRepository(PubSubDAO dao, Integer maxCacheSize) {
        this.dao = dao;
        this.maxCacheSize = maxCacheSize;
        SizedCache cache = new SizedCache(this.maxCacheSize);
        this.cacheStats = cache;
        this.nodes = Collections.synchronizedMap(cache);
        this.log.config("Initializing Cached Repository with cache size = " + (maxCacheSize == null ? "OFF" : maxCacheSize));
        this.nodeSaver = new NodeSaver();
        this.stats = new ConcurrentHashMap<String, StatisticHolder>();
        this.stats.put("getNodeItems", (StatisticHolder)new StatisticHolderImpl("db/getNodeItems requests"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStatistics(String name, StatisticsList stats) {
        if (this.nodes.size() > 0) {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINE);
        } else {
            stats.add(name, "Cached nodes", this.nodes.size(), Level.FINEST);
        }
        long subscriptionsCount = 0L;
        long affiliationsCount = 0L;
        LinkedHashMap<String, Node> tmp = null;
        Iterator<StatisticHolder> iterator = this.nodes;
        synchronized (iterator) {
            tmp = new LinkedHashMap<String, Node>(this.nodes);
        }
        for (Node nd : tmp.values()) {
            subscriptionsCount += (long)nd.getNodeSubscriptions().getSubscriptionsMap().size();
            affiliationsCount += (long)nd.getNodeAffiliations().getAffiliationsMap().size();
        }
        if (this.updateSubscriptionsCalled > 0L) {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINE);
        } else {
            stats.add(name, "Update subscriptions calls", this.updateSubscriptionsCalled, Level.FINEST);
        }
        if (subscriptionsCount > 0L) {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINE);
        } else {
            stats.add(name, "Subscriptions count (in cache)", subscriptionsCount, Level.FINEST);
        }
        if (affiliationsCount > 0L) {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINE);
        } else {
            stats.add(name, "Affiliations count (in cache)", affiliationsCount, Level.FINEST);
        }
        if (this.repo_writes > 0L) {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINE);
        } else {
            stats.add(name, "Repository writes", this.repo_writes, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Added new nodes", this.nodes_added, Level.INFO);
        } else {
            stats.add(name, "Added new nodes", this.nodes_added, Level.FINEST);
        }
        if (this.nodes_added > 0L) {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.INFO);
        } else {
            stats.add(name, "Total writing time", Utils.longToTime(this.writingTime), Level.FINEST);
        }
        if (this.nodes_added + this.repo_writes > 0L) {
            if (this.nodes_added > 0L) {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.INFO);
            } else {
                stats.add(name, "Average DB write time [ms]", this.writingTime / (this.nodes_added + this.repo_writes), Level.FINEST);
            }
        }
        this.cacheStats.getStatistics(name, stats);
        for (StatisticHolder holder : this.stats.values()) {
            holder.getStatistics(name, stats);
        }
    }

    public void statisticExecutedIn(long executionTime) {
    }

    public void everyHour() {
        this.cacheStats.everyHour();
        for (StatisticHolder holder : this.stats.values()) {
            holder.everyHour();
        }
    }

    public void everyMinute() {
        this.cacheStats.everyMinute();
        for (StatisticHolder holder : this.stats.values()) {
            holder.everyMinute();
        }
    }

    public void everySecond() {
        this.cacheStats.everySecond();
        for (StatisticHolder holder : this.stats.values()) {
            holder.everySecond();
        }
    }

    public void setStatisticsPrefix(String prefix) {
    }

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Addint to root collection, serviceJid: {0}, nodeName: {1}", new Object[]{serviceJid, nodeName});
        }
        this.dao.addToRootCollection(serviceJid, nodeName);
        this.getRootCollectionSet(serviceJid).add(nodeName);
    }

    protected String createKey(BareJID serviceJid, String nodeName) {
        return serviceJid.toString() + "/" + nodeName;
    }

    @Override
    public void createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Creating node, serviceJid: {0}, nodeName: {1}, ownerJid: {2}, nodeConfig: {3}, nodeType: {4}, collection: {5}", new Object[]{serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collection});
        }
        long start = System.currentTimeMillis();
        Object collectionId = null;
        if (collection != null && !collection.equals("") && (collectionId = (Object)this.dao.getNodeId(serviceJid, collection)) == null) {
            throw new RepositoryException("Parent collection does not exists yet!");
        }
        Object nodeId = this.dao.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collectionId);
        if (null == nodeId && null == (nodeId = (Object)this.dao.getNodeId(serviceJid, nodeName))) {
            throw new RepositoryException("Creating node failed!");
        }
        tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = NodeAffiliations.create((Queue<UsersAffiliation>)null);
        NodeSubscriptions nodeSubscriptions = this.wrapNodeSubscriptions(tigase.pubsub.repository.NodeSubscriptions.create());
        Node<Object> node = new Node<Object>(nodeId, serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions, ownerJid, new Date());
        String key = this.createKey(serviceJid, nodeName);
        this.nodes.put(key, node);
        long end = System.currentTimeMillis();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Creating node[2], serviceJid: {0}, nodeName: {1}, nodeAffiliations: {2}, nodeSubscriptions: {3}, node: {4}", new Object[]{serviceJid, nodeName, nodeAffiliations, nodeSubscriptions, node});
        }
        ++this.nodes_added;
        this.writingTime += end - start;
    }

    protected NodeSubscriptions wrapNodeSubscriptions(tigase.pubsub.repository.NodeSubscriptions nodeSubscriptions) {
        return new NodeSubscriptions(nodeSubscriptions);
    }

    @Override
    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        Object nodeId;
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        Object t = nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Deleting node, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeId: {4}", new Object[]{serviceJid, nodeName, key, node, nodeId});
        }
        this.dao.deleteNode(serviceJid, nodeId);
        if (node != null) {
            node.setDeleted(true);
        }
        this.nodes.remove(key);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        this.nodes.remove(key);
    }

    public Collection<Node> getAllNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public String[] getBuddyGroups(BareJID owner, BareJID bareJid) throws RepositoryException {
        return this.dao.getBuddyGroups(owner, bareJid);
    }

    @Override
    public String getBuddySubscription(BareJID owner, BareJID buddy) throws RepositoryException {
        return this.dao.getBuddySubscription(owner, buddy);
    }

    protected Node getNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        String key = this.createKey(serviceJid, nodeName);
        Node<T> node = this.nodes.get(key);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}", new Object[]{serviceJid, nodeName, key, node});
        }
        if (node == null) {
            INodeMeta<T> nodeMeta = this.dao.getNodeMeta(serviceJid, nodeName);
            if (nodeMeta == null) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Getting node[1] -- nodeId null! serviceJid: {0}, nodeName: {1}, nodeId: {2}", new Object[]{serviceJid, nodeName, null});
                }
                return null;
            }
            AbstractNodeConfig nodeConfig = nodeMeta.getNodeConfig();
            if (nodeConfig == null) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Getting node[2] -- config null! serviceJid: {0}, nodeName: {1}, cfgData: {2}", new Object[]{serviceJid, nodeName, null});
                }
                return null;
            }
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = new tigase.pubsub.repository.cached.NodeAffiliations(this.dao.getNodeAffiliations(serviceJid, nodeMeta.getNodeId()));
            NodeSubscriptions nodeSubscriptions = this.wrapNodeSubscriptions(this.dao.getNodeSubscriptions(serviceJid, nodeMeta.getNodeId()));
            node = new Node<T>(nodeMeta.getNodeId(), serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions, nodeMeta.getCreator(), nodeMeta.getCreationTime());
            this.nodes.put(key, node);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Getting node[2], serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeAffiliations {4}, nodeSubscriptions: {5}", new Object[]{serviceJid, nodeName, key, node, nodeAffiliations, nodeSubscriptions});
            }
        }
        return node;
    }

    @Override
    public IAffiliations getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        return node == null ? null : node.getNodeAffiliations();
    }

    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node config, serviceJid: {0}, nodeName: {1}, node: {2}", new Object[]{serviceJid, nodeName, node});
        }
        try {
            return node == null ? null : node.getNodeConfig().clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public INodeMeta getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.getNode(serviceJid, nodeName);
    }

    @Override
    public IItems getNodeItems(BareJID serviceJid, String nodeName) throws RepositoryException {
        Object nodeId;
        String key = this.createKey(serviceJid, nodeName);
        long start = System.currentTimeMillis();
        Node node = this.nodes.get(key);
        Object t = nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node items, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeId: {4}", new Object[]{serviceJid, nodeName, key, node, nodeId});
        }
        long end = System.currentTimeMillis();
        this.stats.get("getNodeItems").statisticExecutedIn(end - start);
        return new Items(nodeId, serviceJid, nodeName, this.dao);
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node subscriptions, serviceJid: {0}, nodeName: {1}, node: {2}, node.getNodeConfig(): {3}", new Object[]{serviceJid, nodeName, node, node.getNodeConfig()});
        }
        return node == null ? null : node.getNodeSubscriptions();
    }

    @Override
    public IPubSubDAO getPubSubDAO() {
        return this.dao;
    }

    @Override
    public String[] getRootCollection(BareJID serviceJid) throws RepositoryException {
        Set<String> rootCollection = this.getRootCollectionSet(serviceJid);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting root collection, serviceJid: {0}", new Object[]{serviceJid});
        }
        if (rootCollection == null) {
            return null;
        }
        return rootCollection.toArray(new String[rootCollection.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getRootCollectionSet(BareJID serviceJid) throws RepositoryException {
        Set<String> rootCollection = this.rootCollection.get(serviceJid);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting root collection, serviceJid: {0}", new Object[]{serviceJid});
        }
        if (rootCollection == null || rootCollection.isEmpty()) {
            Set<String> oldRootCollection;
            if (rootCollection == null && (oldRootCollection = this.rootCollection.putIfAbsent(serviceJid, rootCollection = Collections.synchronizedSet(new HashSet()))) != null) {
                rootCollection = oldRootCollection;
            }
            Set<String> set = rootCollection;
            synchronized (set) {
                String[] x;
                if (rootCollection.isEmpty() && (x = this.dao.getChildNodes(serviceJid, null)) != null) {
                    for (String string : x) {
                        rootCollection.add(string);
                    }
                }
            }
        }
        return rootCollection;
    }

    @Override
    public Map<BareJID, RosterElement> getUserRoster(BareJID owner) throws RepositoryException {
        return this.dao.getUserRoster(owner);
    }

    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID userJid) throws RepositoryException {
        return this.dao.getUserSubscriptions(serviceJid, userJid);
    }

    @Override
    public void init() {
        this.log.config("Cached PubSubRepository initialising...");
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        Set<String> rootCollectionNodes;
        Object nodeId;
        String key = this.createKey(serviceJid, nodeName);
        Node node = this.nodes.get(key);
        Object t = nodeId = node != null ? node.getNodeId() : this.dao.getNodeId(serviceJid, nodeName);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Getting node items, serviceJid: {0}, nodeName: {1}, key: {2}, node: {3}, nodeId: {4}", new Object[]{serviceJid, nodeName, key, node, nodeId});
        }
        if ((rootCollectionNodes = this.getRootCollectionSet(serviceJid)) != null) {
            rootCollectionNodes.remove(nodeName);
        }
        this.nodes.remove(key);
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            node.configCopyFrom(nodeConfig);
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (config)");
            this.nodeSaver.save(node);
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        if (nodeAffiliations instanceof tigase.pubsub.repository.cached.NodeAffiliations) {
            Node node = this.getNode(serviceJid, nodeName);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Updating node affiliations, serviceJid: {0}, nodeName: {1}, node: {2}, nodeAffiliations: {3}", new Object[]{serviceJid, nodeName, node, nodeAffiliations});
            }
            if (node != null) {
                if (node.getNodeAffiliations() != nodeAffiliations) {
                    throw new RuntimeException("INCORRECT");
                }
                this.log.finest("Node '" + nodeName + "' added to lazy write queue (affiliations), node: " + node);
                this.nodeSaver.save(node);
            }
        } else {
            throw new RuntimeException("Wrong class");
        }
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, ISubscriptions nodeSubscriptions) throws RepositoryException {
        ++this.updateSubscriptionsCalled;
        Node node = this.getNode(serviceJid, nodeName);
        if (node != null) {
            this.log.finest("Node '" + nodeName + "' added to lazy write queue (subscriptions)");
            this.nodeSaver.save(node);
        }
    }

    @Override
    public void onUserRemoved(BareJID userJid) throws RepositoryException {
        String[] rootCollectionNodes = this.getRootCollection(userJid);
        if (rootCollectionNodes != null) {
            for (String node : rootCollectionNodes) {
                this.removeFromRootCollection(userJid, node);
            }
        }
        this.dao.removeService(userJid);
        this.rootCollection.remove(userJid);
        for (Node node : this.nodes.values()) {
            NodeSubscriptions nodeSubscriptions = node.getNodeSubscriptions();
            nodeSubscriptions.changeSubscription(userJid, Subscription.none);
            nodeSubscriptions.merge();
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = node.getNodeAffiliations();
            nodeAffiliations.changeAffiliation(userJid, Affiliation.none);
            nodeAffiliations.merge();
        }
    }

    private class SizedCache
    extends LinkedHashMap<String, Node>
    implements StatisticHolder {
        private static final long serialVersionUID = 1L;
        private int maxCacheSize;
        private Counter requestsCounter;
        private Counter hitsCounter;

        public SizedCache(int maxSize) {
            super(maxSize, 0.1f, true);
            this.maxCacheSize = 1000;
            this.requestsCounter = new Counter("cache/requests", Level.FINEST);
            this.hitsCounter = new Counter("cache/hits", Level.FINEST);
            this.maxCacheSize = maxSize;
        }

        @Override
        public Node get(Object key) {
            Node val = (Node)super.get(key);
            this.requestsCounter.inc();
            if (val != null) {
                this.hitsCounter.inc();
            }
            return val;
        }

        public void getStatistics(String compName, StatisticsList list) {
            this.requestsCounter.getStatistics(compName, list);
            this.hitsCounter.getStatistics(compName, list);
            list.add(compName, "cache/hit-miss ratio per minute", this.requestsCounter.getPerMinute() == 0L ? 0.0f : (float)this.hitsCounter.getPerMinute() / (float)this.requestsCounter.getPerMinute(), Level.FINE);
            list.add(compName, "cache/hit-miss ratio per second", this.requestsCounter.getPerSecond() == 0L ? 0.0f : (float)this.hitsCounter.getPerSecond() / (float)this.requestsCounter.getPerSecond(), Level.FINE);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Node> eldest) {
            return this.size() > this.maxCacheSize && !eldest.getValue().needsWriting();
        }

        public void statisticExecutedIn(long executionTime) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public void everyHour() {
            this.requestsCounter.everyHour();
            this.hitsCounter.everyHour();
        }

        public void everyMinute() {
            this.requestsCounter.everyMinute();
            this.hitsCounter.everyMinute();
        }

        public void everySecond() {
            this.requestsCounter.everySecond();
            this.hitsCounter.everySecond();
        }

        public void setStatisticsPrefix(String prefix) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class NodeSaver {
        private NodeSaver() {
        }

        public void save(Node<T> node) throws RepositoryException {
            this.save(node, 0);
        }

        public void save(Node<T> node, int iteration) throws RepositoryException {
            long start = System.currentTimeMillis();
            ++CachedPubSubRepository.this.repo_writes;
            try {
                if (node.isDeleted()) {
                    return;
                }
                if (CachedPubSubRepository.this.log.isLoggable(Level.FINEST)) {
                    CachedPubSubRepository.this.log.log(Level.FINEST, "Saving node: {0}", new Object[]{node});
                }
                if (node.configNeedsWriting()) {
                    String collection = node.getNodeConfig().getCollection();
                    Object collectionId = null;
                    if (collection != null && !collection.equals("") && (collectionId = (Object)CachedPubSubRepository.this.dao.getNodeId(node.getServiceJid(), collection)) == null) {
                        throw new RepositoryException("Parent collection does not exists yet!");
                    }
                    CachedPubSubRepository.this.dao.updateNodeConfig(node.getServiceJid(), node.getNodeId(), node.getNodeConfig().getFormElement().toString(), collectionId);
                    node.configSaved();
                }
                if (node.affiliationsNeedsWriting()) {
                    Map<BareJID, UsersAffiliation> changedAffiliations = node.getNodeAffiliations().getChanged();
                    for (Map.Entry<BareJID, Cloneable> entry : changedAffiliations.entrySet()) {
                        CachedPubSubRepository.this.dao.updateNodeAffiliation(node.getServiceJid(), node.getNodeId(), node.getName(), (UsersAffiliation)entry.getValue());
                    }
                    node.affiliationsSaved();
                }
                if (node.subscriptionsNeedsWriting()) {
                    Map<BareJID, UsersSubscription> changedSubscriptions = node.getNodeSubscriptions().getChanged();
                    for (Map.Entry<BareJID, Cloneable> entry : changedSubscriptions.entrySet()) {
                        UsersSubscription subscription = (UsersSubscription)entry.getValue();
                        if (subscription.getSubscription() == Subscription.none) {
                            CachedPubSubRepository.this.dao.removeNodeSubscription(node.getServiceJid(), node.getNodeId(), subscription.getJid());
                            continue;
                        }
                        CachedPubSubRepository.this.dao.updateNodeSubscription(node.getServiceJid(), node.getNodeId(), node.getName(), subscription);
                    }
                    node.subscriptionsSaved();
                }
            }
            catch (Exception e) {
                CachedPubSubRepository.this.log.log(Level.WARNING, "Problem saving pubsub data: ", e);
                node.resetChanges();
                throw new RepositoryException("Problem saving pubsub data", e);
            }
            if (node.needsWriting()) {
                if (iteration >= 10) {
                    String msg = "Was not able to save data for node " + node.getName() + " on " + iteration + " iteration, config saved = " + !node.configNeedsWriting() + ", affiliations saved = " + !node.affiliationsNeedsWriting() + ", subscriptions saved = " + !node.subscriptionsNeedsWriting();
                    CachedPubSubRepository.this.log.log(Level.WARNING, msg);
                    throw new RepositoryException("Problem saving pubsub data");
                }
                this.save(node, iteration++);
            }
            long end = System.currentTimeMillis();
            CachedPubSubRepository.this.writingTime = CachedPubSubRepository.this.writingTime + (end - start);
        }
    }
}

