/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Map;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.stats.StatisticHolder;
import tigase.stats.StatisticsList;
import tigase.xmpp.BareJID;
import tigase.xmpp.impl.roster.RosterElement;

public class PubSubRepositoryWrapper
implements IPubSubRepository,
StatisticHolder {
    private IPubSubRepository repo;

    public PubSubRepositoryWrapper(IPubSubRepository repo) {
        this.repo = repo;
    }

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.repo.addToRootCollection(serviceJid, nodeName);
    }

    @Override
    public void createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        this.repo.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collection);
    }

    @Override
    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.repo.deleteNode(serviceJid, nodeName);
    }

    @Override
    public void destroy() {
        this.repo.destroy();
    }

    @Override
    public void forgetConfiguration(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.repo.forgetConfiguration(serviceJid, nodeName);
    }

    @Override
    public String[] getBuddyGroups(BareJID owner, BareJID buddy) throws RepositoryException {
        return this.repo.getBuddyGroups(owner, buddy);
    }

    @Override
    public String getBuddySubscription(BareJID owner, BareJID buddy) throws RepositoryException {
        return this.repo.getBuddySubscription(owner, buddy);
    }

    @Override
    public IAffiliations getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.repo.getNodeAffiliations(serviceJid, nodeName);
    }

    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.repo.getNodeConfig(serviceJid, nodeName);
    }

    @Override
    public IItems getNodeItems(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.repo.getNodeItems(serviceJid, nodeName);
    }

    @Override
    public INodeMeta getNodeMeta(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.repo.getNodeMeta(serviceJid, nodeName);
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.repo.getNodeSubscriptions(serviceJid, nodeName);
    }

    @Override
    public IPubSubDAO getPubSubDAO() {
        return this.repo.getPubSubDAO();
    }

    @Override
    public String[] getRootCollection(BareJID serviceJid) throws RepositoryException {
        return this.repo.getRootCollection(serviceJid);
    }

    @Override
    public Map<BareJID, RosterElement> getUserRoster(BareJID owner) throws RepositoryException {
        return this.repo.getUserRoster(owner);
    }

    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID userJid) throws RepositoryException {
        return this.repo.getUserSubscriptions(serviceJid, userJid);
    }

    @Override
    public void init() {
        this.repo.init();
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        this.repo.removeFromRootCollection(serviceJid, nodeName);
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, AbstractNodeConfig nodeConfig) throws RepositoryException {
        this.repo.update(serviceJid, nodeName, nodeConfig);
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, IAffiliations affiliations) throws RepositoryException {
        this.repo.update(serviceJid, nodeName, affiliations);
    }

    @Override
    public void update(BareJID serviceJid, String nodeName, ISubscriptions subscriptions) throws RepositoryException {
        this.repo.update(serviceJid, nodeName, subscriptions);
    }

    @Override
    public void onUserRemoved(BareJID userJid) throws RepositoryException {
    }

    public void statisticExecutedIn(long executionTime) {
        if (this.repo instanceof StatisticHolder) {
            ((StatisticHolder)this.repo).statisticExecutedIn(executionTime);
        }
    }

    public void everyHour() {
        if (this.repo instanceof StatisticHolder) {
            ((StatisticHolder)this.repo).everyHour();
        }
    }

    public void everyMinute() {
        if (this.repo instanceof StatisticHolder) {
            ((StatisticHolder)this.repo).everyMinute();
        }
    }

    public void everySecond() {
        if (this.repo instanceof StatisticHolder) {
            ((StatisticHolder)this.repo).everySecond();
        }
    }

    public void getStatistics(String compName, StatisticsList list) {
        if (this.repo instanceof StatisticHolder) {
            ((StatisticHolder)this.repo).getStatistics(compName, list);
        }
    }

    public void setStatisticsPrefix(String prefix) {
        if (this.repo instanceof StatisticHolder) {
            ((StatisticHolder)this.repo).setStatisticsPrefix(prefix);
        }
    }
}

