/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Map;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;

public class RetrieveSubscriptionsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"subscriptions"));

    public RetrieveSubscriptionsModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-subscriptions"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            BareJID serviceJid = packet.getStanzaTo().getBareJID();
            Element pubsub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element subscriptions = pubsub.getChild("subscriptions");
            String nodeName = subscriptions.getAttributeStaticStr("node");
            String senderJid = packet.getStanzaFrom().toString();
            BareJID senderBareJid = packet.getStanzaFrom().getBareJID();
            Element pubsubResult = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Packet result = packet.okResult(pubsubResult, 0);
            Element subscriptionsResult = new Element("subscriptions");
            pubsubResult.addChild((XMLNodeIfc)subscriptionsResult);
            if (nodeName == null) {
                IPubSubDAO directRepo = this.getRepository().getPubSubDAO();
                Map<String, UsersSubscription> usersSubscriptions = directRepo.getUserSubscriptions(serviceJid, senderBareJid);
                for (Map.Entry<String, UsersSubscription> entry : usersSubscriptions.entrySet()) {
                    UsersSubscription subscription = entry.getValue();
                    Element a2 = new Element("subscription", new String[]{"node", "jid", "subscription"}, new String[]{entry.getKey(), senderBareJid.toString(), subscription.getSubscription().name()});
                    subscriptionsResult.addChild((XMLNodeIfc)a2);
                }
            } else {
                UsersSubscription[] subscribers;
                ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(serviceJid, nodeName);
                subscriptionsResult.addAttribute("node", nodeName);
                for (UsersSubscription usersSubscription : subscribers = nodeSubscriptions.getSubscriptions()) {
                    Element s = new Element("subscription", new String[]{"jid", "subscription", "subid"}, new String[]{usersSubscription.getJid().toString(), usersSubscription.getSubscription().name(), usersSubscription.getSubid()});
                    subscriptionsResult.addChild((XMLNodeIfc)s);
                }
            }
            this.packetWriter.write(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

