/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import tigase.xmpp.JID;

public class ClusterNodeMap {
    private final Set<JID> clusterNodes;
    private final Map<String, NodeInfo> nodesMap = new HashMap<String, NodeInfo>();
    private final Random random = new SecureRandom();

    public ClusterNodeMap(Set<JID> cluster_nodes) {
        this.clusterNodes = cluster_nodes;
    }

    public void addPubSubNode(String nodeName) {
        this.nodesMap.put(nodeName, new NodeInfo());
    }

    public void addPubSubNode(String[] nodeNames) {
        if (nodeNames != null) {
            for (String string : nodeNames) {
                this.addPubSubNode(string);
            }
        }
    }

    public void assign(String clusterNodeId, String pubSubNodeName) {
        NodeInfo i = this.nodesMap.get(pubSubNodeName);
        if (i == null) {
            i = new NodeInfo();
            this.nodesMap.put(pubSubNodeName, i);
        }
        i.clusterNodeId = clusterNodeId;
    }

    public String getClusterNodeId(String pubsubNodeName) {
        NodeInfo i = this.nodesMap.get(pubsubNodeName);
        if (i != null) {
            return i.clusterNodeId;
        }
        return null;
    }

    public Map<String, Integer> getClusterNodesLoad() {
        HashMap<String, Integer> nodeLoad = new HashMap<String, Integer>();
        for (JID jID : this.clusterNodes) {
            nodeLoad.put(jID.toString(), new Integer(0));
        }
        for (Map.Entry entry : this.nodesMap.entrySet()) {
            Integer a2;
            if (((NodeInfo)entry.getValue()).clusterNodeId == null || (a2 = (Integer)nodeLoad.get(((NodeInfo)entry.getValue()).clusterNodeId)) == null) continue;
            Integer n = a2;
            Integer n2 = a2 = Integer.valueOf(a2 + 1);
            nodeLoad.put(((NodeInfo)entry.getValue()).clusterNodeId, a2);
        }
        return nodeLoad;
    }

    public String getNewOwnerOfNode(String nodeName) {
        Map<String, Integer> nodeLoad = this.getClusterNodesLoad();
        Integer minCount = null;
        for (Integer i : nodeLoad.values()) {
            minCount = minCount == null || minCount > i ? i : minCount;
        }
        ArrayList<String> shortList = new ArrayList<String>();
        for (Map.Entry<String, Integer> entry : nodeLoad.entrySet()) {
            if (!entry.getValue().equals(minCount)) continue;
            shortList.add(entry.getKey());
        }
        int r = this.random.nextInt(shortList.size());
        return (String)shortList.get(r);
    }

    private class NodeInfo {
        private String clusterNodeId;

        private NodeInfo() {
        }
    }
}

