/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import tigase.db.DataRepository;
import tigase.db.UserRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.XMPPServer;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

public class PubSubDAOJDBC
extends PubSubDAO {
    protected Connection conn = null;
    private PreparedStatement conn_valid_st = null;
    private long connectionValidateInterval = 60000L;
    private CallableStatement create_node_sp = null;
    private DataRepository.dbTypes database = null;
    private String db_conn = null;
    private CallableStatement delete_all_nodes_sp = null;
    private CallableStatement delete_item_sp = null;
    private CallableStatement delete_node_subscriptions_sp = null;
    private CallableStatement get_all_nodes_sp = null;
    private CallableStatement get_child_nodes_sp = null;
    private CallableStatement get_item_sp = null;
    private CallableStatement get_node_affiliations_sp = null;
    private CallableStatement get_node_configuration_sp = null;
    private CallableStatement get_node_id_sp = null;
    private CallableStatement get_node_items_ids_since_sp = null;
    private CallableStatement get_node_items_ids_sp = null;
    private CallableStatement get_node_items_meta_sp = null;
    private CallableStatement get_node_subscriptions_sp = null;
    private CallableStatement get_root_nodes_sp = null;
    private CallableStatement get_user_affiliations_sp = null;
    private CallableStatement get_user_subscriptions_sp = null;
    private long lastConnectionValidated = 0L;
    private CallableStatement remove_node_sp = null;
    private CallableStatement set_node_affiliations_sp = null;
    private CallableStatement set_node_configuration_sp = null;
    private CallableStatement set_node_subscriptions_sp = null;
    private CallableStatement write_item_sp = null;
    private boolean schemaOk = false;

    public PubSubDAOJDBC(UserRepository repository, PubSubConfig pubSubConfig, String connection_str) {
        super(repository);
        this.db_conn = connection_str;
        if (this.db_conn.startsWith("jdbc:postgresql")) {
            this.database = DataRepository.dbTypes.postgresql;
        } else if (this.db_conn.startsWith("jdbc:mysql")) {
            this.database = DataRepository.dbTypes.mysql;
        } else if (this.db_conn.startsWith("jdbc:derby")) {
            this.database = DataRepository.dbTypes.derby;
        } else if (this.db_conn.startsWith("jdbc:jtds:sqlserver")) {
            this.database = DataRepository.dbTypes.jtds;
        } else if (this.db_conn.startsWith("jdbc:sqlserver")) {
            this.database = DataRepository.dbTypes.sqlserver;
        }
    }

    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkConnection() throws SQLException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.conn_valid_st;
            synchronized (preparedStatement) {
                long tmp = System.currentTimeMillis();
                if (tmp - this.lastConnectionValidated >= this.connectionValidateInterval) {
                    rs = this.conn_valid_st.executeQuery();
                    this.lastConnectionValidated = tmp;
                }
            }
            this.release(null, rs);
        }
        catch (Exception e) {
            this.initRepo();
        }
        finally {
            this.release(null, rs);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, Long collectionId) throws RepositoryException {
        long nodeId = 0L;
        ResultSet rs = null;
        try {
            String serializedNodeConfig = null;
            if (nodeConfig != null) {
                nodeConfig.setNodeType(nodeType);
                serializedNodeConfig = nodeConfig.getFormElement().toString();
            }
            this.checkConnection();
            CallableStatement callableStatement = this.create_node_sp;
            synchronized (callableStatement) {
                this.create_node_sp.setString(1, serviceJid.toString());
                this.create_node_sp.setString(2, nodeName);
                this.create_node_sp.setInt(3, nodeType.ordinal());
                this.create_node_sp.setString(4, ownerJid.toString());
                this.create_node_sp.setString(5, serializedNodeConfig);
                if (collectionId == null) {
                    this.create_node_sp.setNull(6, -5);
                } else {
                    this.create_node_sp.setLong(6, (long)collectionId);
                }
                if (this.db_conn != null && (rs = this.create_node_sp.executeQuery()).next()) {
                    nodeId = rs.getLong(1);
                }
            }
            this.release(null, rs);
            return nodeId;
        }
        catch (SQLIntegrityConstraintViolationException e) {
            try {
                throw new RepositoryException("Error while adding node to repository, already exists?", e);
                catch (SQLException e2) {
                    e2.printStackTrace();
                    throw new RepositoryException("Problem accessing repository.", e2);
                }
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_item_sp;
            synchronized (callableStatement) {
                this.delete_item_sp.setLong(1, nodeId);
                this.delete_item_sp.setString(2, id);
                this.delete_item_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item removing error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(BareJID serviceJid, long nodeId) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.remove_node_sp;
            synchronized (callableStatement) {
                this.remove_node_sp.setLong(1, nodeId);
                this.remove_node_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node deleting error", e);
        }
    }

    @Override
    public void destroy() {
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            log.log(Level.WARNING, "Problem closing jdbc connection: " + this.db_conn, e);
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAllNodesList(BareJID serviceJid) throws RepositoryException {
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_all_nodes_sp;
        synchronized (callableStatement) {
            try {
                this.get_all_nodes_sp.setString(1, serviceJid.toString());
                rs = this.get_all_nodes_sp.executeQuery();
                ArrayList<String> names = new ArrayList<String>();
                while (rs.next()) {
                    names.add(rs.getString(1));
                }
                String[] stringArray = names.toArray(new String[0]);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var3_3
                this.release(null, rs);
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Nodes list getting error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Date getDateFromItem(BareJID serviceJid, long nodeId, String id, int field) throws RepositoryException {
        ResultSet rs = null;
        try {
            Date date;
            this.checkConnection();
            CallableStatement callableStatement = this.get_item_sp;
            synchronized (callableStatement) {
                this.get_item_sp.setLong(1, nodeId);
                this.get_item_sp.setString(2, id);
                rs = this.get_item_sp.executeQuery();
                if (rs.next()) {
                    Timestamp timestamp = rs.getTimestamp(field);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var7_6
                    this.release(null, rs);
                    return timestamp;
                }
                date = null;
            }
            this.release(null, rs);
            return date;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Item field " + field + " reading error", e);
            }
        }
    }

    @Override
    public Element getItem(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        return this.itemDataToElement(this.getStringFromItem(serviceJid, nodeId, id, 1).toCharArray());
    }

    @Override
    public Date getItemCreationDate(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        return this.getDateFromItem(serviceJid, nodeId, id, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(BareJID serviceJid, long nodeId) throws RepositoryException {
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_items_ids_sp;
        synchronized (callableStatement) {
            try {
                this.get_node_items_ids_sp.setLong(1, nodeId);
                rs = this.get_node_items_ids_sp.executeQuery();
                ArrayList<String> ids = new ArrayList<String>();
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                String[] stringArray = ids.toArray(new String[ids.size()]);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var5_4
                this.release(null, rs);
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Items list reading error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIdsSince(BareJID serviceJid, long nodeId, Date since) throws RepositoryException {
        ResultSet rs = null;
        Timestamp sinceTs = new Timestamp(since.getTime());
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_items_ids_since_sp;
        synchronized (callableStatement) {
            try {
                this.get_node_items_ids_since_sp.setLong(1, nodeId);
                this.get_node_items_ids_since_sp.setTimestamp(2, sinceTs);
                rs = this.get_node_items_ids_since_sp.executeQuery();
                ArrayList<String> ids = new ArrayList<String>();
                while (rs.next()) {
                    ids.add(rs.getString(1));
                }
                String[] stringArray = ids.toArray(new String[ids.size()]);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var7_7
                this.release(null, rs);
                return stringArray;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Items list reading error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IItems.ItemMeta> getItemsMeta(BareJID serviceJid, long nodeId, String nodeName) throws RepositoryException {
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_items_meta_sp;
        synchronized (callableStatement) {
            try {
                this.get_node_items_meta_sp.setLong(1, nodeId);
                rs = this.get_node_items_meta_sp.executeQuery();
                ArrayList<IItems.ItemMeta> results = new ArrayList<IItems.ItemMeta>();
                while (rs.next()) {
                    String id = rs.getString(1);
                    Timestamp creationDate = rs.getTimestamp(2);
                    results.add(new IItems.ItemMeta(nodeName, id, creationDate));
                }
                ArrayList<IItems.ItemMeta> arrayList = results;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var6_5
                this.release(null, rs);
                return arrayList;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Items list reading error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public Date getItemUpdateDate(BareJID serviceJid, long nodeId, String id) throws RepositoryException {
        return this.getDateFromItem(serviceJid, nodeId, id, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getNodeId(BareJID serviceJid, String nodeName) throws RepositoryException {
        ResultSet rs = null;
        try {
            long l;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_id_sp;
            synchronized (callableStatement) {
                this.get_node_id_sp.setString(1, serviceJid.toString());
                this.get_node_id_sp.setString(2, nodeName);
                rs = this.get_node_id_sp.executeQuery();
                if (rs.next()) {
                    long l2 = rs.getLong(1);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var4_4
                    this.release(null, rs);
                    return l2;
                }
                l = 0L;
            }
            this.release(null, rs);
            return l;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Retrieving node id error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeAffiliations getNodeAffiliations(BareJID serviceJid, long nodeId) throws RepositoryException {
        ResultSet rs = null;
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_affiliations_sp;
        synchronized (callableStatement) {
            try {
                this.get_node_affiliations_sp.setLong(1, nodeId);
                rs = this.get_node_affiliations_sp.executeQuery();
                ArrayDeque<UsersAffiliation> data = new ArrayDeque<UsersAffiliation>();
                while (rs.next()) {
                    BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                    Affiliation affil = Affiliation.valueOf(rs.getString(2));
                    data.offer(new UsersAffiliation(jid, affil));
                }
                tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = NodeAffiliations.create(data);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl18 : MonitorExitStatement: MONITOREXIT : var5_4
                this.release(null, rs);
                return nodeAffiliations;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Node subscribers reading error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    @Override
    public String getNodeConfig(BareJID serviceJid, long nodeId) throws RepositoryException {
        return this.readNodeConfigFormData(serviceJid, nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String[] getNodesList(BareJID serviceJid, String nodeName) throws RepositoryException {
        rs = null;
        try {
            this.checkConnection();
            if (nodeName != null) ** GOTO lbl-1000
            var4_4 = this.get_root_nodes_sp;
            synchronized (var4_4) {
                this.get_root_nodes_sp.setString(1, serviceJid.toString());
                rs = this.get_root_nodes_sp.executeQuery();
                names = new ArrayList<String>();
                while (true) {
                    if (!rs.next()) {
                        var6_9 = names.toArray(new String[0]);
                        // MONITOREXIT @DISABLED, blocks:[0, 6, 10, 12] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                        this.release(null, rs);
                        return var6_9;
                    }
                    names.add(rs.getString(1));
                }
            }
lbl-1000:
            // 1 sources

            {
                var4_5 = this.get_child_nodes_sp;
            }
        }
        catch (Throwable var9_11) {
            this.release(null, rs);
            throw var9_11;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Nodes list getting error", e);
            }
        }
        synchronized (var4_5) {
            this.get_child_nodes_sp.setString(1, serviceJid.toString());
            this.get_child_nodes_sp.setString(2, nodeName);
            rs = this.get_child_nodes_sp.executeQuery();
            names = new ArrayList<String>();
            while (rs.next()) {
                names.add(rs.getString(1));
            }
            var6_10 = names.toArray(new String[0]);
        }
        this.release(null, rs);
        return var6_10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSubscriptions getNodeSubscriptions(BareJID serviceJid, long nodeId) throws RepositoryException {
        ResultSet rs = null;
        tigase.pubsub.repository.cached.NodeSubscriptions ns = NodeSubscriptions.create();
        this.checkConnection();
        CallableStatement callableStatement = this.get_node_subscriptions_sp;
        synchronized (callableStatement) {
            try {
                this.get_node_subscriptions_sp.setLong(1, nodeId);
                rs = this.get_node_subscriptions_sp.executeQuery();
                ArrayDeque<UsersSubscription> data = new ArrayDeque<UsersSubscription>();
                while (rs.next()) {
                    BareJID jid = BareJID.bareJIDInstanceNS((String)rs.getString(1));
                    Subscription subscr = Subscription.valueOf(rs.getString(2));
                    String subscrId = rs.getString(3);
                    data.offer(new UsersSubscription(jid, subscrId, subscr));
                }
                ns.init(data);
                tigase.pubsub.repository.cached.NodeSubscriptions nodeSubscriptions = ns;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl21 : MonitorExitStatement: MONITOREXIT : var6_6
                this.release(null, rs);
                return nodeSubscriptions;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Node subscribers reading error", e);
                    }
                }
                catch (Throwable throwable2) {
                    this.release(null, rs);
                    throw throwable2;
                }
            }
        }
    }

    public String getResourceUri() {
        return this.db_conn;
    }

    @Override
    public String[] getChildNodes(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.getNodesList(serviceJid, nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getStringFromItem(BareJID serviceJid, long nodeId, String id, int field) throws RepositoryException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            CallableStatement callableStatement = this.get_item_sp;
            synchronized (callableStatement) {
                this.get_item_sp.setLong(1, nodeId);
                this.get_item_sp.setString(2, id);
                rs = this.get_item_sp.executeQuery();
                if (rs.next()) {
                    String string2 = rs.getString(field);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var7_6
                    this.release(null, rs);
                    return string2;
                }
                string = null;
            }
            this.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Item field " + field + " reading error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        ResultSet rs = null;
        try {
            HashMap<String, UsersAffiliation> result = new HashMap<String, UsersAffiliation>();
            Object object = this.get_user_affiliations_sp;
            synchronized (object) {
                this.get_user_affiliations_sp.setString(1, serviceJid.toString());
                this.get_user_affiliations_sp.setString(2, jid.toString());
                rs = this.get_user_affiliations_sp.executeQuery();
                while (rs.next()) {
                    String nodeName = rs.getString(1);
                    Affiliation affil = Affiliation.valueOf(rs.getString(2));
                    result.put(nodeName, new UsersAffiliation(jid, affil));
                }
            }
            object = result;
            this.release(null, rs);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("User affiliations reading error", e);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, UsersSubscription> getUserSubscriptions(BareJID serviceJid, BareJID jid) throws RepositoryException {
        ResultSet rs = null;
        try {
            HashMap<String, UsersSubscription> result = new HashMap<String, UsersSubscription>();
            Object object = this.get_user_subscriptions_sp;
            synchronized (object) {
                this.get_user_subscriptions_sp.setString(1, serviceJid.toString());
                this.get_user_subscriptions_sp.setString(2, jid.toString());
                rs = this.get_user_subscriptions_sp.executeQuery();
                while (rs.next()) {
                    String nodeName = rs.getString(1);
                    Subscription subscr = Subscription.valueOf(rs.getString(2));
                    String subscrId = rs.getString(3);
                    result.put(nodeName, new UsersSubscription(jid, subscrId, subscr));
                }
            }
            object = result;
            this.release(null, rs);
            return object;
        }
        catch (SQLException e) {
            try {
                throw new RepositoryException("User affiliations reading error", e);
            }
            catch (Throwable throwable) {
                this.release(null, rs);
                throw throwable;
            }
        }
    }

    private void checkSchema() {
        if (this.schemaOk) {
            return;
        }
        try {
            CallableStatement testCall = this.conn.prepareCall("{ call TigPubSubGetNodeId(?,?) }");
            testCall.setString(1, "tigase-pubsub");
            testCall.setString(2, "tigase-pubsub");
            testCall.execute();
            testCall.close();
            this.schemaOk = true;
        }
        catch (Exception ex) {
            String[] msg = new String[]{"", "  ---------------------------------------------", "  ERROR! Terminating the server process.", "  PubSub Component is not compatible with", "  database schema which exists in", "  " + this.db_conn, "  This component uses newer schema. To continue", "  use of currently deployed schema, please use", "  older version of PubSub Component.", "  To convert database to new schema please see:", "  https://projects.tigase.org/projects/tigase-pubsub/wiki/PubSub_database_schema_conversion"};
            if (XMPPServer.isOSGi()) {
                for (String line : msg) {
                    log.log(Level.SEVERE, line);
                }
            } else {
                for (String line : msg) {
                    System.out.println(line);
                }
            }
            log.log(Level.FINEST, "Exception during checkSchema: " + ex);
            System.exit(1);
        }
    }

    @Override
    public void init() throws RepositoryException {
        try {
            this.initRepo();
        }
        catch (SQLException e) {
            this.conn = null;
            throw new RepositoryException("Problem initializing jdbc connection: " + this.db_conn, e);
        }
        super.init();
    }

    private void initPreparedStatements() throws SQLException {
        String query;
        switch (this.database) {
            case derby: {
                query = "VALUES 1";
                break;
            }
            default: {
                query = "select 1";
            }
        }
        this.conn_valid_st = this.conn.prepareStatement(query);
        query = "{ call TigPubSubCreateNode(?, ?, ?, ?, ?, ?) }";
        this.create_node_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubRemoveNode(?) }";
        this.remove_node_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeId(?, ?) }";
        this.get_node_id_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetItem(?, ?) }";
        this.get_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubWriteItem(?, ?, ?, ?) }";
        this.write_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteItem(?, ?) }";
        this.delete_item_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeItemsIds(?) }";
        this.get_node_items_ids_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeItemsIdsSince(?,?) }";
        this.get_node_items_ids_since_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeItemsMeta(?) }";
        this.get_node_items_meta_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetAllNodes(?) }";
        this.get_all_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetRootNodes(?) }";
        this.get_root_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetChildNodes(?,?) }";
        this.get_child_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteAllNodes(?) }";
        this.delete_all_nodes_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeConfiguration(?, ?, ?) }";
        this.set_node_configuration_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeAffiliation(?, ?, ?) }";
        this.set_node_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeConfiguration(?) }";
        this.get_node_configuration_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeAffiliations(?) }";
        this.get_node_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetNodeSubscriptions(?) }";
        this.get_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubSetNodeSubscription(?, ?, ?, ?) }";
        this.set_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubDeleteNodeSubscription(?, ?) }";
        this.delete_node_subscriptions_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetUserAffiliations(?, ?) }";
        this.get_user_affiliations_sp = this.conn.prepareCall(query);
        query = "{ call TigPubSubGetUserSubscriptions(?, ?) }";
        this.get_user_subscriptions_sp = this.conn.prepareCall(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRepo() throws SQLException {
        String string = this.db_conn;
        synchronized (string) {
            String driverClass = null;
            switch (this.database) {
                case postgresql: {
                    driverClass = "org.postgresql.Driver";
                    break;
                }
                case mysql: {
                    driverClass = "com.mysql.jdbc.Driver";
                    break;
                }
                case derby: {
                    driverClass = "org.apache.derby.jdbc.EmbeddedDriver";
                    break;
                }
                case jtds: {
                    driverClass = "net.sourceforge.jtds.jdbc.Driver";
                    break;
                }
                case sqlserver: {
                    driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                    break;
                }
                default: {
                    driverClass = "net.sf.log4jdbc.sql.jdbcapi.DriverSpy";
                }
            }
            try {
                Class.forName(driverClass, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                log.log(Level.SEVERE, null, ex);
            }
            this.conn = DriverManager.getConnection(this.db_conn);
            this.checkSchema();
            this.initPreparedStatements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readNodeConfigFormData(BareJID serviceJid, long nodeId) throws RepositoryException {
        ResultSet rs = null;
        try {
            String string;
            this.checkConnection();
            CallableStatement callableStatement = this.get_node_configuration_sp;
            synchronized (callableStatement) {
                this.get_node_configuration_sp.setLong(1, nodeId);
                rs = this.get_node_configuration_sp.executeQuery();
                if (rs.next()) {
                    String string2 = rs.getString(1);
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl11 : MonitorExitStatement: MONITOREXIT : var5_4
                    this.release(null, rs);
                    return string2;
                }
                string = null;
            }
            this.release(null, rs);
            return string;
        }
        catch (Throwable throwable) {
            this.release(null, rs);
            throw throwable;
        }
        {
            catch (SQLException e) {
                throw new RepositoryException("Node subscribers reading error", e);
            }
        }
    }

    private void release(Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sqlEx) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFromRootCollection(BareJID serviceJid) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_all_nodes_sp;
            synchronized (callableStatement) {
                this.delete_all_nodes_sp.setString(1, serviceJid.toString());
                this.delete_all_nodes_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Removing root collection error", e);
        }
    }

    @Override
    public void removeFromRootCollection(BareJID serviceJid, long nodeId) throws RepositoryException {
        this.deleteNode(serviceJid, nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNodeSubscription(BareJID serviceJid, long nodeId, BareJID jid) throws RepositoryException {
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.delete_node_subscriptions_sp;
            synchronized (callableStatement) {
                this.delete_node_subscriptions_sp.setLong(1, nodeId);
                this.delete_node_subscriptions_sp.setString(2, jid.toString());
                this.delete_node_subscriptions_sp.execute();
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers fragment removing error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeAffiliation(BareJID serviceJid, long nodeId, UsersAffiliation affiliation) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_affiliations_sp;
            synchronized (callableStatement) {
                this.set_node_affiliations_sp.setLong(1, nodeId);
                this.set_node_affiliations_sp.setString(2, affiliation.getJid().toString());
                this.set_node_affiliations_sp.setString(3, affiliation.getAffiliation().name());
                if (this.db_conn != null) {
                    this.set_node_affiliations_sp.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
        finally {
            this.release(null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(BareJID serviceJid, long nodeId, String serializedData, Long collectionId) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_configuration_sp;
            synchronized (callableStatement) {
                this.set_node_configuration_sp.setLong(1, nodeId);
                this.set_node_configuration_sp.setString(2, serializedData);
                if (collectionId == null) {
                    this.set_node_configuration_sp.setNull(3, -5);
                } else {
                    this.set_node_configuration_sp.setLong(3, (long)collectionId);
                }
                if (this.db_conn != null) {
                    this.set_node_configuration_sp.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node configuration writing error", e);
        }
        finally {
            this.release(null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeSubscription(BareJID serviceJid, long nodeId, UsersSubscription subscription) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.set_node_subscriptions_sp;
            synchronized (callableStatement) {
                this.set_node_subscriptions_sp.setLong(1, nodeId);
                this.set_node_subscriptions_sp.setString(2, subscription.getJid().toString());
                this.set_node_subscriptions_sp.setString(3, subscription.getSubscription().name());
                this.set_node_subscriptions_sp.setString(4, subscription.getSubid());
                if (this.db_conn != null) {
                    this.set_node_subscriptions_sp.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Node subscribers writing error", e);
        }
        finally {
            this.release(null, rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(BareJID serviceJid, long nodeId, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        ResultSet rs = null;
        try {
            this.checkConnection();
            CallableStatement callableStatement = this.write_item_sp;
            synchronized (callableStatement) {
                this.write_item_sp.setLong(1, nodeId);
                this.write_item_sp.setString(2, id);
                this.write_item_sp.setString(3, publisher);
                this.write_item_sp.setString(4, item.toString());
                if (this.db_conn != null) {
                    this.write_item_sp.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new RepositoryException("Item writing error", e);
        }
        finally {
            this.release(null, rs);
        }
    }
}

