/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.ext.presence;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tigase.pubsub.Subscription;
import tigase.pubsub.modules.ext.presence.PresenceNotifierModule;
import tigase.pubsub.modules.ext.presence.PresencePerNodeExtension;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PresenceNodeSubscriptions
implements ISubscriptions {
    private final PresencePerNodeExtension extension;
    private final String nodeName;
    private final BareJID serviceJID;
    private final ISubscriptions subscriptions;

    public PresenceNodeSubscriptions(BareJID serviceJid, String nodeName, ISubscriptions subscriptions, PresenceNotifierModule presenceExtensionModule) {
        this.serviceJID = serviceJid;
        this.nodeName = nodeName;
        this.subscriptions = subscriptions;
        this.extension = presenceExtensionModule.getPresencePerNodeExtension();
    }

    @Override
    public String addSubscriberJid(BareJID jid, Subscription subscription) {
        return this.subscriptions.addSubscriberJid(jid, subscription);
    }

    @Override
    public void changeSubscription(BareJID jid, Subscription subscription) {
        this.subscriptions.changeSubscription(jid, subscription);
    }

    @Override
    public Subscription getSubscription(BareJID jid) {
        Subscription s = this.subscriptions.getSubscription(jid);
        if (s == Subscription.none) {
            Collection<Packet> ocs = this.extension.getPresence(this.serviceJID, this.nodeName, jid);
            for (Packet packet : ocs) {
                if (packet.getType() != null && packet.getType() != StanzaType.available) continue;
                return Subscription.subscribed;
            }
        }
        return s;
    }

    @Override
    public String getSubscriptionId(BareJID jid) {
        String id = this.subscriptions.getSubscriptionId(jid);
        if (id == null) {
            Collection<Packet> ocs = this.extension.getPresence(this.serviceJID, this.nodeName, jid);
            for (Packet packet : ocs) {
                if (packet.getType() != null && packet.getType() != StanzaType.available) continue;
                return "pr:" + packet.getStanzaFrom().getBareJID().hashCode();
            }
        }
        return id;
    }

    @Override
    public UsersSubscription[] getSubscriptions() {
        HashMap<BareJID, UsersSubscription> result = new HashMap<BareJID, UsersSubscription>();
        UsersSubscription[] o = this.subscriptions.getSubscriptions();
        if (o != null) {
            for (UsersSubscription usersSubscription : o) {
                result.put(usersSubscription.getJid(), usersSubscription);
            }
        }
        Collection<JID> occupants = this.extension.getNodeOccupants(this.serviceJID, this.nodeName);
        for (JID jid : occupants) {
            Packet pr;
            if (result.containsKey(jid.getBareJID()) || (pr = this.extension.getPresence(this.serviceJID, this.nodeName, jid)).getType() != null && pr.getType() != StanzaType.available) continue;
            result.put(jid.getBareJID(), new UsersSubscription(jid.getBareJID(), "pr:" + jid.getBareJID().hashCode(), Subscription.subscribed));
        }
        return result.values().toArray(new UsersSubscription[0]);
    }

    @Override
    public boolean isChanged() {
        return this.subscriptions.isChanged();
    }

    @Override
    public String serialize(Map<BareJID, UsersSubscription> fragment) {
        return this.subscriptions.serialize(fragment);
    }
}

