/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.UUID;
import tigase.component2.PacketWriter;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventType;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AbstractConfigCreateNode;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;

public class NodeCreateModule
extends AbstractConfigCreateNode {
    private static final Criteria CRIT_CREATE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"create"));
    private final PublishItemModule publishModule;

    public NodeCreateModule(PubSubConfig config, PacketWriter packetWriter, LeafNodeConfig defaultNodeConfig, PublishItemModule publishItemModule) {
        super(config, defaultNodeConfig, packetWriter);
        this.publishModule = publishItemModule;
    }

    public void addNodeCreateHandler(NodeCreateHandler handler) {
        this.getEventBus().addHandler(NodeCreateHandler.NodeCreateEvent.TYPE, handler);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#create-and-configure", "http://jabber.org/protocol/pubsub#collections", "http://jabber.org/protocol/pubsub#create-nodes", "http://jabber.org/protocol/pubsub#instant-nodes", "http://jabber.org/protocol/pubsub#multi-collection", "http://jabber.org/protocol/pubsub#access-authorize", "http://jabber.org/protocol/pubsub#access-open", "http://jabber.org/protocol/pubsub#access-presence", "http://jabber.org/protocol/pubsub#access-roster", "http://jabber.org/protocol/pubsub#access-whitelist"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_CREATE;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        long time1 = System.currentTimeMillis();
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element create = pubSub.getChild("create");
        Element configure = pubSub.getChild("configure");
        String nodeName = create.getAttributeStaticStr("node");
        try {
            Element x;
            boolean instantNode;
            boolean bl = instantNode = nodeName == null;
            if (instantNode) {
                nodeName = UUID.randomUUID().toString().replaceAll("-", "");
            }
            if (this.getRepository().getNodeConfig(toJid, nodeName) != null) {
                throw new PubSubException(element, Authorization.CONFLICT);
            }
            NodeType nodeType = NodeType.leaf;
            String collection = null;
            AbstractNodeConfig nodeConfig = new LeafNodeConfig(nodeName, this.defaultNodeConfig);
            if (configure != null && (x = configure.getChild("x", "jabber:x:data")) != null && "submit".equals(x.getAttributeStaticStr("type"))) {
                for (Element field : x.getChildren()) {
                    if (!"field".equals(field.getName())) continue;
                    String var = field.getAttributeStaticStr("var");
                    String val = null;
                    Element value = field.getChild("value");
                    if (value != null) {
                        val = value.getCData();
                    }
                    if ("pubsub#node_type".equals(var)) {
                        nodeType = val == null ? NodeType.leaf : NodeType.valueOf(val);
                    } else if ("pubsub#collection".equals(var)) {
                        collection = val;
                    }
                    nodeConfig.setValue(var, val);
                }
            }
            if (nodeType == NodeType.collection) {
                Form f = nodeConfig.getForm();
                nodeConfig = new CollectionNodeConfig(nodeConfig.getNodeName());
                nodeConfig.copyFromForm(f);
                nodeConfig.setNodeType(NodeType.collection);
            }
            CollectionNodeConfig colNodeConfig = null;
            if (collection != null) {
                AbstractNodeConfig absNodeConfig = this.getRepository().getNodeConfig(toJid, collection);
                if (absNodeConfig == null) {
                    throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
                }
                if (absNodeConfig.getNodeType() == NodeType.leaf) {
                    throw new PubSubException(element, Authorization.NOT_ALLOWED);
                }
                colNodeConfig = (CollectionNodeConfig)absNodeConfig;
            }
            if (nodeType != NodeType.leaf && nodeType != NodeType.collection) {
                throw new PubSubException(Authorization.NOT_ALLOWED);
            }
            this.getRepository().createNode(toJid, nodeName, packet.getStanzaFrom().getBareJID(), nodeConfig, nodeType, collection == null ? "" : collection);
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            IAffiliations nodeaAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            nodeSubscriptions.addSubscriberJid(packet.getStanzaFrom().getBareJID(), Subscription.subscribed);
            nodeaAffiliations.addAffiliation(packet.getStanzaFrom().getBareJID(), Affiliation.owner);
            this.getRepository().update(toJid, nodeName, nodeaAffiliations);
            this.getRepository().update(toJid, nodeName, nodeSubscriptions);
            if (colNodeConfig == null) {
                this.getRepository().addToRootCollection(toJid, nodeName);
            } else {
                colNodeConfig.addChildren(nodeName);
                this.getRepository().update(toJid, collection, colNodeConfig);
            }
            NodeCreateHandler.NodeCreateEvent event = new NodeCreateHandler.NodeCreateEvent(packet, nodeName);
            this.getEventBus().fire(event);
            Packet result = packet.okResult((Element)null, 0);
            if (collection != null) {
                ISubscriptions colNodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, collection);
                IAffiliations colNodeAffiliations = this.getRepository().getNodeAffiliations(toJid, collection);
                Element colE = new Element("collection", new String[]{"node"}, new String[]{collection});
                colE.addChild((XMLNodeIfc)new Element("associate", new String[]{"node"}, new String[]{nodeName}));
                this.publishModule.sendNotifications(colE, packet.getStanzaTo(), collection, nodeConfig, colNodeAffiliations, colNodeSubscriptions);
            }
            if (instantNode) {
                Element ps = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                Element cr = new Element("create", new String[]{"node"}, new String[]{nodeName});
                ps.addChild((XMLNodeIfc)cr);
                result.getElement().addChild((XMLNodeIfc)ps);
            }
            long time2 = System.currentTimeMillis();
            result.getElement().addChild((XMLNodeIfc)new Element("text", "Created in " + (time2 - time1) + " ms"));
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void removeNodeCreateHandler(NodeCreateHandler handler) {
        this.getEventBus().remove(handler);
    }

    public static interface NodeCreateHandler
    extends EventHandler {
        public void onNodeCreated(Packet var1, String var2);

        public static class NodeCreateEvent
        extends Event<NodeCreateHandler> {
            public static final EventType<NodeCreateHandler> TYPE = new EventType();
            private final String nodeName;
            private final Packet packet;

            public NodeCreateEvent(Packet packet, String nodeName) {
                super(TYPE);
                this.packet = packet;
                this.nodeName = nodeName;
            }

            @Override
            protected void dispatch(NodeCreateHandler handler) {
                handler.onNodeCreated(this.packet, this.nodeName);
            }
        }
    }
}

