/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.exceptions;

import tigase.component2.exceptions.ComponentException;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class PubSubException
extends ComponentException {
    private static final long serialVersionUID = 1L;
    private Authorization errorCondition;
    private Element item;
    private String message;
    private PubSubErrorCondition pubSubErrorCondition;
    private String xmlns = "urn:ietf:params:xml:ns:xmpp-stanzas";

    public PubSubException(Authorization errorCondition) {
        this(null, errorCondition, (String)null);
    }

    public PubSubException(Authorization errorCondition, PubSubErrorCondition pubSubErrorConditions) {
        this((Element)null, errorCondition, pubSubErrorConditions);
    }

    public PubSubException(Authorization errorCondition, PubSubErrorCondition pubSubErrorConditions, String message) {
        this((Element)null, errorCondition, pubSubErrorConditions);
        this.message = message;
    }

    public PubSubException(Authorization errorCondition, String message) {
        this(null, errorCondition, message);
    }

    public PubSubException(Authorization errorCondition, String message, Exception ex) {
        this(null, errorCondition, message, ex);
    }

    public PubSubException(Element item, Authorization errorCondition) {
        this(item, errorCondition, (String)null);
    }

    public PubSubException(Element item, Authorization errorCondition, PubSubErrorCondition pubSubErrorConditions) {
        this(item, errorCondition, (String)null);
        this.pubSubErrorCondition = pubSubErrorConditions;
    }

    public PubSubException(Element item, Authorization errorCondition, String message) {
        this(item, errorCondition, message, null);
    }

    public PubSubException(Element item, Authorization errorCondition, String message, Exception ex) {
        super(errorCondition);
        this.item = item;
        this.errorCondition = errorCondition;
        this.message = message;
    }

    @Override
    public String getCode() {
        return String.valueOf(this.errorCondition.getErrorCode());
    }

    @Override
    public Authorization getErrorCondition() {
        return this.errorCondition;
    }

    public Element getItem() {
        return this.item;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getName() {
        return this.errorCondition.getCondition();
    }

    @Override
    public String getType() {
        return this.errorCondition.getErrorType();
    }

    public Element makeElement() {
        return this.makeElement(true);
    }

    public Element makeElement(boolean insertOriginal) {
        Element answer = insertOriginal ? this.item.clone() : new Element(this.item.getName());
        answer.addAttribute("id", this.item.getAttributeStaticStr("id"));
        answer.addAttribute("type", "error");
        answer.addAttribute("to", this.item.getAttributeStaticStr("from"));
        answer.addAttribute("from", this.item.getAttributeStaticStr("to"));
        if (this.message != null) {
            Element text = new Element("text", this.message, new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-stanzas"});
            answer.addChild((XMLNodeIfc)text);
        }
        answer.addChild((XMLNodeIfc)this.makeErrorElement());
        if (this.pubSubErrorCondition != null) {
            answer.addChild((XMLNodeIfc)this.pubSubErrorCondition.getElement());
        }
        return answer;
    }

    public Element makeElement(Element sourceElement) {
        this.item = sourceElement;
        return this.makeElement(true);
    }

    public Element makeErrorElement() {
        Element error = new Element("error");
        error.setAttribute("code", String.valueOf(this.errorCondition.getErrorCode()));
        error.setAttribute("type", this.errorCondition.getErrorType());
        error.addChild((XMLNodeIfc)new Element(this.errorCondition.getCondition(), new String[]{"xmlns"}, new String[]{this.xmlns}));
        return error;
    }
}

