/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AccessModel;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.PublisherModel;
import tigase.pubsub.SendLastPublishedItem;
import tigase.xml.Element;

public abstract class AbstractNodeConfig {
    public static final String PUBSUB = "pubsub#";
    public static final String TIGASE = "tigase#";
    protected final Form form = new Form("form", null, null);
    private final String nodeName;

    public AbstractNodeConfig(String nodeName) {
        this.nodeName = nodeName;
        this.init();
    }

    public AbstractNodeConfig(String nodeName, AbstractNodeConfig config) {
        this.nodeName = nodeName;
        this.init();
        this.copyFrom(config);
    }

    public void add(Field f) {
        this.form.addField(f);
    }

    protected String[] asStrinTable(Enum<?>[] values) {
        String[] result = new String[values.length];
        int i = 0;
        for (Enum<?> v : values) {
            result[i++] = v.name();
        }
        return result;
    }

    public AbstractNodeConfig clone() throws CloneNotSupportedException {
        AbstractNodeConfig clone = this.getInstance(this.nodeName);
        clone.copyFrom(this);
        return clone;
    }

    public void copyFrom(AbstractNodeConfig c) {
        this.form.copyValuesFrom(c.form);
    }

    public void copyFromForm(Form f) {
        this.form.copyValuesFrom(f);
    }

    public String getBodyXslt() {
        return this.form.getAsString("pubsub#body_xslt");
    }

    public String getBodyXsltEmbedded() {
        String[] r = this.form.getAsStrings("pubsub#embedded_body_xslt");
        if (r == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String string : r) {
            sb.append(string);
        }
        return sb.toString();
    }

    public String[] getChildren() {
        return this.form.getAsStrings("pubsub#children");
    }

    public String getCollection() {
        String d = this.form.getAsString("pubsub#collection");
        return d == null ? "" : d;
    }

    public String[] getDomains() {
        String[] v = this.form.getAsStrings("pubsub#domains");
        return v == null ? new String[]{} : v;
    }

    public Form getForm() {
        return this.form;
    }

    public Element getFormElement() {
        return this.form.getElement();
    }

    protected abstract AbstractNodeConfig getInstance(String var1);

    public AccessModel getNodeAccessModel() {
        String tmp = this.form.getAsString("pubsub#access_model");
        if (tmp == null) {
            return null;
        }
        return AccessModel.valueOf(tmp);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public NodeType getNodeType() {
        String tmp = this.form.getAsString("pubsub#node_type");
        if (tmp == null) {
            return null;
        }
        return NodeType.valueOf(tmp);
    }

    public PublisherModel getPublisherModel() {
        String tmp = this.form.getAsString("pubsub#publish_model");
        if (tmp == null) {
            return null;
        }
        try {
            return PublisherModel.valueOf(tmp);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public String[] getRosterGroupsAllowed() {
        return this.form.getAsStrings("pubsub#roster_groups_allowed");
    }

    public SendLastPublishedItem getSendLastPublishedItem() {
        String s = this.form.getAsString("pubsub#send_last_published_item");
        try {
            return s == null ? SendLastPublishedItem.never : SendLastPublishedItem.valueOf(s);
        }
        catch (Exception e) {
            return SendLastPublishedItem.never;
        }
    }

    public String getTitle() {
        return this.form.getAsString("pubsub#title");
    }

    protected void init() {
        this.form.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#node_config"));
        this.form.addField(Field.fieldListSingle((String)"pubsub#node_type", null, null, null, (String[])new String[]{NodeType.leaf.name(), NodeType.collection.name()}));
        this.form.addField(Field.fieldTextSingle((String)"pubsub#title", (String)"", (String)"A friendly name for the node"));
        this.form.addField(Field.fieldBoolean((String)"pubsub#deliver_payloads", (Boolean)true, (String)"Whether to deliver payloads with event notifications"));
        this.form.addField(Field.fieldBoolean((String)"pubsub#notify_config", (Boolean)false, (String)"Notify subscribers when the node configuration changes"));
        this.form.addField(Field.fieldBoolean((String)"pubsub#persist_items", (Boolean)true, (String)"Persist items to storage"));
        this.form.addField(Field.fieldTextSingle((String)"pubsub#max_items", (String)"10", (String)"Max # of items to persist"));
        this.form.addField(Field.fieldTextSingle((String)"pubsub#collection", (String)"", (String)"The collection with which a node is affiliated"));
        this.form.addField(Field.fieldListSingle((String)"pubsub#access_model", (String)AccessModel.open.name(), (String)"Specify the subscriber model", null, (String[])this.asStrinTable(AccessModel.values())));
        this.form.addField(Field.fieldListSingle((String)"pubsub#publish_model", (String)PublisherModel.publishers.name(), (String)"Specify the publisher model", null, (String[])this.asStrinTable(PublisherModel.values())));
        this.form.addField(Field.fieldListSingle((String)"pubsub#send_last_published_item", (String)SendLastPublishedItem.on_sub.name(), (String)"When to send the last published item", null, (String[])this.asStrinTable(PublisherModel.values())));
        this.form.addField(Field.fieldTextMulti((String)"pubsub#domains", (String[])new String[0], (String)"The domains allowed to access this node (blank for any)"));
        this.form.addField(Field.fieldBoolean((String)"pubsub#presence_based_delivery", (Boolean)false, (String)"Whether to deliver notifications to available users only"));
        this.form.addField(Field.fieldBoolean((String)"tigase#presence_expired", (Boolean)false, (String)"Whether to subscription expired when subscriber going offline."));
        this.form.addField(Field.fieldTextMulti((String)"pubsub#embedded_body_xslt", (String[])new String[0], (String)"The XSL transformation which can be applied to payloads in order to generate an appropriate message body element."));
        this.form.addField(Field.fieldTextSingle((String)"pubsub#body_xslt", (String)"", (String)"The URL of an XSL transformation which can be applied to payloads in order to generate an appropriate message body element."));
        this.form.addField(Field.fieldTextMulti((String)"pubsub#roster_groups_allowed", (String[])new String[0], (String)"Roster groups allowed to subscribe"));
        this.form.addField(Field.fieldBoolean((String)"pubsub#notify_sub_aff_state", (Boolean)true, (String)"Notify subscribers when owner change their subscription or affiliation state"));
        this.form.addField(Field.fieldBoolean((String)"tigase#allow_view_subscribers", (Boolean)false, (String)"Allows get list of subscribers for each sybscriber"));
    }

    public boolean isAllowToViewSubscribers() {
        return this.form.getAsBoolean("tigase#allow_view_subscribers");
    }

    public boolean isCollectionSet() {
        return this.form.get("pubsub#collection") != null;
    }

    public boolean isDeliver_payloads() {
        return this.form.getAsBoolean("pubsub#deliver_payloads");
    }

    public boolean isDeliverPresenceBased() {
        return this.form.getAsBoolean("pubsub#presence_based_delivery");
    }

    public boolean isNotify_config() {
        return this.form.getAsBoolean("pubsub#notify_config");
    }

    public boolean isPresenceExpired() {
        Boolean x = this.form.getAsBoolean("tigase#presence_expired");
        return x == null ? false : x;
    }

    public boolean isTigaseNotifyChangeSubscriptionAffiliationState() {
        return this.form.getAsBoolean("pubsub#notify_sub_aff_state");
    }

    public void read(UserRepository repository, PubSubConfig config, String subnode) throws UserNotFoundException, TigaseDBException {
        if (repository == null) {
            return;
        }
        String[] keys = repository.getKeys(config.getServiceBareJID(), subnode);
        if (keys != null) {
            for (String key : keys) {
                String[] values = repository.getDataList(config.getServiceBareJID(), subnode, key);
                this.setValues(key, values);
            }
        }
    }

    public void reset() {
        this.form.clear();
        this.init();
    }

    public void setBodyXsltEmbedded(String xslt) {
        this.setValue("pubsub#embedded_body_xslt", xslt);
    }

    public void setCollection(String collectionNew) {
        this.setValue("pubsub#collection", collectionNew);
    }

    public void setDomains(String ... domains) {
        this.setValues("pubsub#domains", domains);
    }

    public void setNodeType(NodeType nodeType) {
        this.form.get("pubsub#node_type").setValues(new String[]{nodeType.name()});
    }

    public void setValue(String var, boolean data) {
        this.setValue(var, new Boolean(data));
    }

    public void setValue(String var, Object data) {
        Field f = this.form.get(var);
        if (f == null) {
            return;
        }
        if (data == null) {
            f.setValues(new String[0]);
        } else if (data instanceof String) {
            String str = (String)data;
            if (!(f.getType() != Field.FieldType.bool || "0".equals(str) || "1".equals(str) || "false".equals(str) || "true".equals(str))) {
                throw new RuntimeException("Boolean fields allows only '1', '0', 'true' and 'false' values");
            }
            f.setValues(new String[]{str});
        } else if (data instanceof Boolean && f.getType() == Field.FieldType.bool) {
            boolean b = (Boolean)data;
            f.setValues(new String[]{b ? "1" : "0"});
        } else if (data instanceof String[] && (f.getType() == Field.FieldType.list_multi || f.getType() == Field.FieldType.text_multi)) {
            String[] d = (String[])data;
            f.setValues(d);
        } else {
            throw new RuntimeException("Cannot match type " + data.getClass().getCanonicalName() + " to field type " + f.getType().name());
        }
    }

    private void setValues(String var, String[] data) {
        if (data == null || data.length > 1) {
            this.setValue(var, data);
        } else if (data.length == 0) {
            this.setValue(var, null);
        } else {
            this.setValue(var, data[0]);
        }
    }

    public void write(UserRepository repo, PubSubConfig config, String subnode) throws UserNotFoundException, TigaseDBException {
        if (repo == null) {
            return;
        }
        repo.setData(config.getServiceBareJID(), subnode, "configuration", this.form.getElement().toString());
    }
}

