/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.lang.reflect.Constructor;
import java.util.Queue;
import java.util.logging.Logger;
import tigase.db.UserRepository;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

public abstract class PubSubDAO
implements IPubSubDAO {
    protected static final Logger log = Logger.getLogger(PubSubDAO.class.getCanonicalName());
    private final SimpleParser parser = SingletonFactory.getParserInstance();
    private final UserRepository repository;

    protected PubSubDAO(UserRepository userRepository) {
        this.repository = userRepository;
    }

    @Override
    public void destroy() {
    }

    @Override
    public String[] getBuddyGroups(BareJID owner, BareJID buddy) throws RepositoryException {
        try {
            return this.repository.getDataList(owner, "roster/" + buddy, "groups");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy groups error", e);
        }
    }

    @Override
    public String getBuddySubscription(BareJID owner, BareJID buddy) throws RepositoryException {
        try {
            return this.repository.getData(owner, "roster/" + buddy, "subscription");
        }
        catch (Exception e) {
            throw new RepositoryException("Getting buddy subscription status error", e);
        }
    }

    @Override
    public BareJID[] getUserRoster(BareJID owner) throws RepositoryException {
        try {
            String[] tmp = this.repository.getSubnodes(owner, "roster");
            BareJID[] result = new BareJID[tmp.length];
            for (int i = 0; i < tmp.length; ++i) {
                result[i] = BareJID.bareJIDInstanceNS((String)tmp[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw new RepositoryException("Getting user roster error", e);
        }
    }

    @Override
    public void init() throws RepositoryException {
    }

    protected Element itemDataToElement(char[] data) {
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        return (Element)q.element();
    }

    @Override
    public AbstractNodeConfig parseConfig(String nodeName, String data) throws RepositoryException {
        try {
            Form cnfForm = this.parseConfigForm(data);
            if (cnfForm == null) {
                return null;
            }
            NodeType type = NodeType.valueOf(cnfForm.getAsString("pubsub#node_type"));
            Class cl = null;
            switch (type) {
                case collection: {
                    cl = CollectionNodeConfig.class;
                    break;
                }
                case leaf: {
                    cl = LeafNodeConfig.class;
                    break;
                }
                default: {
                    throw new RepositoryException("Unknown node type " + (Object)((Object)type));
                }
            }
            CollectionNodeConfig nc = this.getNodeConfig(cl, nodeName, cnfForm);
            return nc;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    protected Form parseConfigForm(String cnfData) {
        if (cnfData == null) {
            return null;
        }
        char[] data = cnfData.toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        if (q != null && q.size() > 0) {
            Form form = new Form((Element)q.element());
            return form;
        }
        return null;
    }

    protected <T extends AbstractNodeConfig> T getNodeConfig(Class<T> nodeConfigClass, String nodeName, Form configForm) throws RepositoryException {
        try {
            Constructor<T> constructor = nodeConfigClass.getConstructor(String.class);
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)constructor.newInstance(nodeName);
            nodeConfig.copyFromForm(configForm);
            return (T)nodeConfig;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }
}

