/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserRepository;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.RepositoryException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

public class PubSubDAOPool
extends PubSubDAO {
    private static final Logger log = Logger.getLogger(PubSubDAOPool.class.getName());
    private final Map<BareJID, LinkedBlockingQueue<PubSubDAO>> pools = new HashMap<BareJID, LinkedBlockingQueue<PubSubDAO>>();

    public PubSubDAOPool(UserRepository userRepository, PubSubConfig config) {
        super(userRepository, config);
    }

    public void addDao(BareJID domain, PubSubDAO dao) {
        LinkedBlockingQueue<PubSubDAO> ee = this.pools.get(domain);
        if (ee == null) {
            ee = new LinkedBlockingQueue();
            this.pools.put(domain, ee);
        }
        ee.offer(dao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addToRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.addToRootCollection(serviceJid, nodeName);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.createNode(serviceJid, nodeName, ownerJid, nodeConfig, nodeType, collection);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteItem(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.deleteItem(serviceJid, nodeName, id);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNode(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.deleteNode(serviceJid, nodeName);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    @Override
    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getItem(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Element element = dao.getItem(serviceJid, nodeName, id);
                return element;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getItemCreationDate(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Date date = dao.getItemCreationDate(serviceJid, nodeName, id);
                return date;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getItemsIds(serviceJid, nodeName);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getItemUpdateDate(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                Date date = dao.getItemUpdateDate(serviceJid, nodeName, id);
                return date;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeAffiliations getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                NodeAffiliations nodeAffiliations = dao.getNodeAffiliations(serviceJid, nodeName);
                return nodeAffiliations;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNodesList(BareJID serviceJid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getNodesList(serviceJid);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeSubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                NodeSubscriptions nodeSubscriptions = dao.getNodeSubscriptions(serviceJid, nodeName);
                return nodeSubscriptions;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    protected String getPoolDetails(BareJID serviceJid) {
        LinkedBlockingQueue<PubSubDAO> ee;
        String result = "";
        if (this.pools.containsKey(serviceJid)) {
            result = result + serviceJid + " pool ";
            ee = this.pools.get(serviceJid);
        } else {
            result = result + "default pool ";
            ee = this.pools.get(null);
        }
        result = result + "has " + ee.size() + " element(s).";
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getRootNodes(BareJID serviceJid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String[] stringArray = dao.getRootNodes(serviceJid);
                return stringArray;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    @Override
    public void init() throws RepositoryException {
    }

    protected void offerDao(BareJID serviceJid, PubSubDAO dao) {
        LinkedBlockingQueue<PubSubDAO> ee = this.pools.containsKey(serviceJid) ? this.pools.get(serviceJid) : this.pools.get(null);
        ee.offer(dao);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String readNodeConfigFormData(BareJID serviceJid, String nodeName) throws TigaseDBException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                String string = dao.readNodeConfigFormData(serviceJid, nodeName);
                return string;
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        }
        log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFromRootCollection(BareJID serviceJid) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.removeAllFromRootCollection(serviceJid);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromRootCollection(BareJID serviceJid, String nodeName) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.removeFromRootCollection(serviceJid, nodeName);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriptions(BareJID serviceJid, String nodeName, int changedIndex) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.removeSubscriptions(serviceJid, nodeName, changedIndex);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    public PubSubDAO takeDao(BareJID serviceJid) {
        try {
            LinkedBlockingQueue<PubSubDAO> ee = this.pools.containsKey(serviceJid) ? this.pools.get(serviceJid) : this.pools.get(null);
            return ee.take();
        }
        catch (InterruptedException ex) {
            log.log(Level.WARNING, "Couldn't obtain PubSub DAO from the pool", ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAffiliations(BareJID serviceJid, String nodeName, String serializedData) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateAffiliations(serviceJid, nodeName, serializedData);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNodeConfig(BareJID serviceJid, String nodeName, String serializedData) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateNodeConfig(serviceJid, nodeName, serializedData);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSubscriptions(BareJID serviceJid, String nodeName, int changedIndex, String serializedData) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.updateSubscriptions(serviceJid, nodeName, changedIndex, serializedData);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeItem(BareJID serviceJid, String nodeName, long timeInMilis, String id, String publisher, Element item) throws RepositoryException {
        PubSubDAO dao = this.takeDao(serviceJid);
        if (dao != null) {
            try {
                dao.writeItem(serviceJid, nodeName, timeInMilis, id, publisher, item);
            }
            finally {
                this.offerDao(serviceJid, dao);
            }
        } else {
            log.warning("dao is NULL, pool empty? - " + this.getPoolDetails(serviceJid));
        }
    }
}

