/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules.commands;

import java.util.Calendar;
import java.util.Date;
import tigase.adhoc.AdHocCommand;
import tigase.adhoc.AdHocCommandException;
import tigase.adhoc.AdHocResponse;
import tigase.adhoc.AdhHocRequest;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.util.DateTimeFormatter;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class RetrieveItemsCommand
implements AdHocCommand {
    private final PubSubConfig config;
    private final DateTimeFormatter dtf = new DateTimeFormatter();
    private final IPubSubRepository repository;
    private final UserRepository userRepo;

    public RetrieveItemsCommand(PubSubConfig config, IPubSubRepository repository, UserRepository userRepo) {
        this.repository = repository;
        this.config = config;
        this.userRepo = userRepo;
    }

    @Override
    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.config.isAdmin(request.getSender())) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Element data = request.getCommand().getChild("x", "jabber:x:data");
            if (request.getAction() != null && "cancel".equals(request.getAction())) {
                response.cancelSession();
            } else if (data == null) {
                Form form = new Form("result", "Retrieve items", null);
                form.addField(Field.fieldTextSingle((String)"tigase-pubsub#node-name", (String)"", (String)"Node name"));
                form.addField(Field.fieldTextSingle((String)"tigase-pubsub#timestamp", (String)this.dtf.formatDateTime(new Date()), (String)"Items since"));
                response.getElements().add(form.getElement());
                response.startSession();
            } else {
                Form form = new Form(data);
                if ("submit".equals(form.getType())) {
                    String[] allItems;
                    Calendar timestamp;
                    Boolean rebuild = form.getAsBoolean("tigase-pubsub#delete-all");
                    String nodeName = form.getAsString("tigase-pubsub#node-name");
                    String timeStr = form.getAsString("tigase-pubsub#timestamp");
                    Calendar calendar = timestamp = timeStr == null || timeStr.trim().length() == 0 ? null : this.dtf.parseDateTime(timeStr);
                    if (nodeName == null) {
                        throw new AdHocCommandException(Authorization.BAD_REQUEST, "Empty node name.");
                    }
                    if (timestamp == null) {
                        throw new AdHocCommandException(Authorization.BAD_REQUEST, "Invalid timestamp.");
                    }
                    Element f = new Element("x", new String[]{"xmlns"}, new String[]{"jabber:x:data"});
                    f.addChild((XMLNodeIfc)new Element("title", "Items"));
                    Element reported = new Element("reported");
                    reported.addChild((XMLNodeIfc)new Element("field", new String[]{"var"}, new String[]{"id"}));
                    f.addChild((XMLNodeIfc)reported);
                    IItems nodeItems = this.repository.getNodeItems(request.getIq().getTo().getBareJID(), nodeName);
                    for (String id : allItems = nodeItems.getItemsIds()) {
                        Date dt = nodeItems.getItemCreationDate(id);
                        if (dt.before(timestamp.getTime())) continue;
                        Element i = new Element("item");
                        Element fi = new Element("field", new String[]{"var"}, new String[]{"id"});
                        fi.addChild((XMLNodeIfc)new Element("value", id));
                        i.addChild((XMLNodeIfc)fi);
                        f.addChild((XMLNodeIfc)i);
                    }
                    response.getElements().add(f);
                }
                response.completeSession();
            }
        }
        catch (AdHocCommandException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    @Override
    public String getName() {
        return "Retrieve items";
    }

    @Override
    public String getNode() {
        return "retrieve-items";
    }
}

