/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.xmpp.BareJID;

public class Node {
    private boolean affNeedsWriting = false;
    private boolean conNeedsWriting = false;
    private long creationTime = System.currentTimeMillis();
    private boolean deleted = false;
    private String name;
    private NodeAffiliations nodeAffiliations;
    private AbstractNodeConfig nodeConfig;
    private NodeSubscriptions nodeSubscriptions;
    private BareJID serviceJid;
    private boolean subNeedsWriting = false;

    public Node(BareJID serviceJid, AbstractNodeConfig nodeConfig, NodeAffiliations nodeAffiliations, NodeSubscriptions nodeSubscriptions) {
        this.serviceJid = serviceJid;
        this.nodeConfig = nodeConfig;
        this.nodeAffiliations = nodeAffiliations;
        this.nodeSubscriptions = nodeSubscriptions;
        this.name = nodeConfig.getNodeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void affiliationsMerge() {
        Node node = this;
        synchronized (node) {
            this.nodeAffiliations.merge();
            this.affNeedsWriting = true;
        }
    }

    public boolean affiliationsNeedsWriting() {
        return this.affNeedsWriting;
    }

    public void affiliationsSaved() {
        this.affNeedsWriting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configCopyFrom(AbstractNodeConfig nodeConfig) {
        Node node = this;
        synchronized (node) {
            this.nodeConfig.copyFrom(nodeConfig);
            this.conNeedsWriting = true;
        }
    }

    public boolean configNeedsWriting() {
        return this.conNeedsWriting;
    }

    public void configSaved() {
        this.conNeedsWriting = false;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getName() {
        return this.name;
    }

    public NodeAffiliations getNodeAffiliations() {
        return this.nodeAffiliations;
    }

    public AbstractNodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    public NodeSubscriptions getNodeSubscriptions() {
        return this.nodeSubscriptions;
    }

    public BareJID getServiceJid() {
        return this.serviceJid;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean needsWriting() {
        return this.subNeedsWriting || this.affNeedsWriting || this.conNeedsWriting;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscriptionsMerge() {
        Node node = this;
        synchronized (node) {
            this.nodeSubscriptions.merge();
            this.subNeedsWriting = true;
        }
    }

    public boolean subscriptionsNeedsWriting() {
        return this.subNeedsWriting;
    }

    public void subscriptionsSaved() {
        this.subNeedsWriting = false;
    }
}

