/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;

public class PurgeItemsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"purge"));
    private final PublishItemModule publishModule;

    public PurgeItemsModule(PubSubConfig config, PacketWriter packetWriter, PublishItemModule publishModule) {
        super(config, packetWriter);
        this.publishModule = publishModule;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#purge-nodes"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element pubSub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
        Element purge = pubSub.getChild("purge");
        String nodeName = purge.getAttributeStaticStr("node");
        try {
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(packet.getElement(), Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeType() == NodeType.collection) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "purge-nodes"));
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            UsersAffiliation affiliation = nodeAffiliations.getSubscriberAffiliation(packet.getStanzaFrom().getBareJID());
            if (!affiliation.getAffiliation().isPurgeNode()) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
            if (!leafNodeConfig.isPersistItem()) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "persistent-items"));
            }
            ArrayList<Packet> result = new ArrayList<Packet>();
            result.add(packet.okResult((Element)null, 0));
            IItems nodeItems = this.getRepository().getNodeItems(toJid, nodeName);
            String[] itemsToDelete = nodeItems.getItemsIds();
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            result.addAll(this.publishModule.prepareNotification(new Element("purge", new String[]{"node"}, new String[]{nodeName}), packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
            this.log.info("Purging node " + nodeName);
            if (itemsToDelete != null) {
                for (String id : itemsToDelete) {
                    nodeItems.deleteItem(id);
                }
            }
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

