/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.script.Bindings;
import tigase.adhoc.AdHocScriptCommandManager;
import tigase.component2.AbstractComponent;
import tigase.component2.PacketWriter;
import tigase.conf.Configurable;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.modules.AdHocConfigCommandModule;
import tigase.pubsub.modules.DefaultConfigModule;
import tigase.pubsub.modules.DiscoverInfoModule;
import tigase.pubsub.modules.DiscoverItemsModule;
import tigase.pubsub.modules.JabberVersionModule;
import tigase.pubsub.modules.ManageAffiliationsModule;
import tigase.pubsub.modules.ManageSubscriptionModule;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.pubsub.modules.NodeCreateModule;
import tigase.pubsub.modules.NodeDeleteModule;
import tigase.pubsub.modules.PendingSubscriptionModule;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.PurgeItemsModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.modules.RetrieveAffiliationsModule;
import tigase.pubsub.modules.RetrieveItemsModule;
import tigase.pubsub.modules.RetrieveSubscriptionsModule;
import tigase.pubsub.modules.SubscribeNodeModule;
import tigase.pubsub.modules.UnsubscribeNodeModule;
import tigase.pubsub.modules.XmppPingModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.modules.commands.DefaultConfigCommand;
import tigase.pubsub.modules.commands.DeleteAllNodesCommand;
import tigase.pubsub.modules.commands.ReadAllNodesCommand;
import tigase.pubsub.modules.commands.RebuildDatabaseCommand;
import tigase.pubsub.modules.ext.presence.PresenceNodeSubscriptions;
import tigase.pubsub.modules.ext.presence.PresenceNotifierModule;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.PubSubDAO;
import tigase.pubsub.repository.PubSubDAOJDBC;
import tigase.pubsub.repository.PubSubDAOPool;
import tigase.pubsub.repository.PubSubRepositoryWrapper;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PubSubComponent
extends AbstractComponent<PubSubConfig>
implements Configurable,
DisableDisco {
    public static final String ADMINS_KEY = "admin";
    private static final String COMPONENT = "component";
    public static final String DEFAULT_LEAF_NODE_CONFIG_KEY = "default-node-config";
    private static final String MAX_CACHE_SIZE = "pubsub-repository-cache-size";
    protected static final String PUBSUB_REPO_CLASS_PROP_KEY = "pubsub-repo-class";
    protected static final String PUBSUB_REPO_POOL_SIZE_PROP_KEY = "pubsub-repo-pool-size";
    protected static final String PUBSUB_REPO_URL_PROP_KEY = "pubsub-repo-url";
    private AdHocConfigCommandModule adHocCommandsModule;
    protected LeafNodeConfig defaultNodeConfig;
    private PubSubDAO directPubSubRepository;
    private Integer maxRepositoryCacheSize;
    private PendingSubscriptionModule pendingSubscriptionModule;
    private PresenceCollectorModule presenceCollectorModule;
    private PresenceNotifierModule presenceNotifierModule;
    private PublishItemModule publishNodeModule;
    protected IPubSubRepository pubsubRepository;
    private AdHocScriptCommandManager scriptCommandManager = new AdHocScriptCommandManagerImpl(this);
    protected UserRepository userRepository;
    private XsltTool xslTransformer;

    @Override
    protected PubSubConfig createComponentConfigInstance(AbstractComponent<?> abstractComponent) {
        PubSubConfig componentConfig = new PubSubConfig(abstractComponent);
        return componentConfig;
    }

    protected IPubSubRepository createPubSubRepository(PubSubDAO directRepository) {
        PubSubRepositoryWrapper wrapper = new PubSubRepositoryWrapper(new CachedPubSubRepository(directRepository, this.maxRepositoryCacheSize)){

            @Override
            public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
                return new PresenceNodeSubscriptions(serviceJid, nodeName, super.getNodeSubscriptions(serviceJid, nodeName), PubSubComponent.this.presenceNotifierModule);
            }
        };
        return wrapper;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        String repo_class = "tigase.db.jdbc.JDBCRepository";
        String repo_uri = "jdbc:derby:tigase-derbydb;create=true";
        String conf_db = null;
        if (params.get("--user-db") != null) {
            conf_db = (String)params.get("--user-db");
        }
        if (conf_db != null) {
            if (conf_db.equals("mysql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:mysql://localhost/tigase?user=root&password=mypass";
            }
            if (conf_db.equals("pgsql")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:postgresql://localhost/tigase?user=tigase";
            }
            if (conf_db.equals("sqlserver")) {
                repo_class = "tigase.db.jdbc.JDBCRepository";
                repo_uri = "jdbc:sqlserver://localhost:1433;databaseName=tigasedb;user=tigase;password=tigase;schema=dbo";
            }
        }
        if (params.get("--user-db-uri") != null) {
            repo_uri = (String)params.get("--user-db-uri");
        }
        props.put(PUBSUB_REPO_CLASS_PROP_KEY, repo_class);
        props.put(PUBSUB_REPO_URL_PROP_KEY, repo_uri);
        props.put(MAX_CACHE_SIZE, "2000");
        String[] admins = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@" + this.getDefHostName()};
        props.put(ADMINS_KEY, admins);
        return props;
    }

    protected void init() {
        PacketWriter writer = this.getWriter();
        this.xslTransformer = new XsltTool();
        if (!this.isRegistered(PresenceCollectorModule.class)) {
            this.presenceCollectorModule = this.registerModule(new PresenceCollectorModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(PublishItemModule.class)) {
            this.publishNodeModule = this.registerModule(new PublishItemModule((PubSubConfig)this.componentConfig, writer, this.xslTransformer, this.presenceCollectorModule));
        }
        if (!this.isRegistered(RetractItemModule.class)) {
            this.registerModule(new RetractItemModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        if (!this.isRegistered(PendingSubscriptionModule.class)) {
            this.pendingSubscriptionModule = this.registerModule(new PendingSubscriptionModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(ManageSubscriptionModule.class)) {
            this.registerModule(new ManageSubscriptionModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(SubscribeNodeModule.class)) {
            this.registerModule(new SubscribeNodeModule((PubSubConfig)this.componentConfig, writer, this.pendingSubscriptionModule, this.publishNodeModule));
        }
        if (!this.isRegistered(NodeCreateModule.class)) {
            this.registerModule(new NodeCreateModule((PubSubConfig)this.componentConfig, writer, this.defaultNodeConfig, this.publishNodeModule));
        }
        if (!this.isRegistered(NodeDeleteModule.class)) {
            this.registerModule(new NodeDeleteModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        if (!this.isRegistered(DefaultConfigModule.class)) {
            this.registerModule(new DefaultConfigModule((PubSubConfig)this.componentConfig, this.defaultNodeConfig, writer));
        }
        if (!this.isRegistered(NodeConfigModule.class)) {
            this.registerModule(new NodeConfigModule((PubSubConfig)this.componentConfig, writer, this.defaultNodeConfig, this.publishNodeModule));
        }
        if (!this.isRegistered(UnsubscribeNodeModule.class)) {
            this.registerModule(new UnsubscribeNodeModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(ManageAffiliationsModule.class)) {
            this.registerModule(new ManageAffiliationsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(RetrieveItemsModule.class)) {
            this.registerModule(new RetrieveItemsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(PurgeItemsModule.class)) {
            this.registerModule(new PurgeItemsModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        if (!this.isRegistered(JabberVersionModule.class)) {
            this.registerModule(new JabberVersionModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(AdHocConfigCommandModule.class)) {
            this.adHocCommandsModule = this.registerModule(new AdHocConfigCommandModule((PubSubConfig)this.componentConfig, writer, this.scriptCommandManager));
        }
        if (!this.isRegistered(DiscoverInfoModule.class)) {
            this.registerModule(new DiscoverInfoModule((PubSubConfig)this.componentConfig, writer, this.modulesManager));
        }
        if (!this.isRegistered(DiscoverItemsModule.class)) {
            this.registerModule(new DiscoverItemsModule((PubSubConfig)this.componentConfig, writer, this.adHocCommandsModule));
        }
        if (!this.isRegistered(RetrieveAffiliationsModule.class)) {
            this.registerModule(new RetrieveAffiliationsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(RetrieveSubscriptionsModule.class)) {
            this.registerModule(new RetrieveSubscriptionsModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(XmppPingModule.class)) {
            this.registerModule(new XmppPingModule((PubSubConfig)this.componentConfig, writer));
        }
        if (!this.isRegistered(PresenceNotifierModule.class)) {
            this.presenceNotifierModule = this.registerModule(new PresenceNotifierModule((PubSubConfig)this.componentConfig, writer, this.publishNodeModule));
        }
        this.pubsubRepository.init();
    }

    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(COMPONENT, (Object)this);
    }

    public void initialize(String[] admins, PubSubDAO pubSubDAO, IPubSubRepository createPubSubRepository, LeafNodeConfig defaultNodeConfig) throws UserNotFoundException, TigaseDBException, RepositoryException {
        ((PubSubConfig)this.componentConfig).setAdmins(admins);
        if (pubSubDAO != null) {
            pubSubDAO.init();
        }
        this.directPubSubRepository = pubSubDAO;
        this.pubsubRepository = this.createPubSubRepository(pubSubDAO);
        this.defaultNodeConfig = defaultNodeConfig;
        this.defaultNodeConfig.read(this.userRepository, (PubSubConfig)this.componentConfig, DEFAULT_LEAF_NODE_CONFIG_KEY);
        this.defaultNodeConfig.write(this.userRepository, (PubSubConfig)this.componentConfig, DEFAULT_LEAF_NODE_CONFIG_KEY);
        ((PubSubConfig)this.componentConfig).setPubSubRepository(this.pubsubRepository);
        this.init();
        DefaultConfigCommand configCommand = new DefaultConfigCommand((PubSubConfig)this.componentConfig, this.userRepository);
        configCommand.addDefaultNodeConfigurationChangedHandler(new DefaultConfigCommand.DefaultNodeConfigurationChangedHandler(){

            @Override
            public void onDefaultConfigurationChanged(Packet packet, PubSubConfig config) {
                PubSubComponent.this.onChangeDefaultNodeConfig();
            }
        });
        this.adHocCommandsModule.register(new RebuildDatabaseCommand((PubSubConfig)this.componentConfig, this.directPubSubRepository));
        this.adHocCommandsModule.register(configCommand);
        this.adHocCommandsModule.register(new DeleteAllNodesCommand((PubSubConfig)this.componentConfig, this.directPubSubRepository, this.userRepository));
        this.adHocCommandsModule.register(new ReadAllNodesCommand((PubSubConfig)this.componentConfig, this.directPubSubRepository, this.pubsubRepository));
    }

    public boolean isSubdomain() {
        return true;
    }

    public void onChangeDefaultNodeConfig() {
        try {
            this.defaultNodeConfig.read(this.userRepository, (PubSubConfig)this.componentConfig, DEFAULT_LEAF_NODE_CONFIG_KEY);
            this.log.info("Node " + this.getComponentId() + " read default node configuration.");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Reading default config error", e);
        }
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        String maxCache;
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (this.pubsubRepository != null) {
            this.pubsubRepository.destroy();
        }
        if (this.directPubSubRepository != null) {
            this.directPubSubRepository.destroy();
        }
        if ((maxCache = (String)props.get(MAX_CACHE_SIZE)) != null) {
            try {
                this.maxRepositoryCacheSize = Integer.valueOf(maxCache);
                props.put(MAX_CACHE_SIZE, this.maxRepositoryCacheSize.toString());
            }
            catch (Exception e) {
                this.maxRepositoryCacheSize = null;
                props.put(MAX_CACHE_SIZE, "off");
            }
        }
        this.userRepository = (UserRepository)props.get("shared-user-repo");
        if (this.userRepository == null) {
            this.userRepository = (UserRepository)props.get("shared-user-repo");
        }
        try {
            PubSubDAO dao;
            String cls_name = (String)props.get(PUBSUB_REPO_CLASS_PROP_KEY);
            String res_uri = (String)props.get(PUBSUB_REPO_URL_PROP_KEY);
            if (this.userRepository == null) {
                this.userRepository = RepositoryFactory.getUserRepository((String)cls_name, (String)res_uri, null);
                this.userRepository.initRepository(res_uri, null);
                this.log.config("Initialized " + cls_name + " as pubsub repository: " + res_uri);
            }
            int dao_pool_size = 1;
            try {
                dao_pool_size = Integer.parseInt((String)props.get(PUBSUB_REPO_POOL_SIZE_PROP_KEY));
            }
            catch (Exception e) {
                dao_pool_size = 1;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("PubSubDAO pool size: " + dao_pool_size);
            }
            if (dao_pool_size > 1) {
                PubSubDAOPool dao_pool = new PubSubDAOPool(this.userRepository, (PubSubConfig)this.componentConfig);
                for (int i = 0; i < dao_pool_size; ++i) {
                    if (cls_name.equals("tigase.pubsub.repository.PubSubDAOJDBC")) {
                        dao_pool.addDao(new PubSubDAOJDBC(this.userRepository, (PubSubConfig)this.componentConfig, res_uri));
                        continue;
                    }
                    dao_pool.addDao(new PubSubDAO(this.userRepository, (PubSubConfig)this.componentConfig));
                }
                dao = dao_pool;
            } else {
                dao = cls_name.equals("tigase.pubsub.repository.PubSubDAOJDBC") ? new PubSubDAOJDBC(this.userRepository, (PubSubConfig)this.componentConfig, res_uri) : new PubSubDAO(this.userRepository, (PubSubConfig)this.componentConfig);
            }
            this.initialize((String[])props.get(ADMINS_KEY), dao, null, new LeafNodeConfig("default"));
        }
        catch (Exception e) {
            this.log.severe("Can't initialize pubsub repository: " + e);
            e.printStackTrace();
        }
    }

    private class AdHocScriptCommandManagerImpl
    implements AdHocScriptCommandManager {
        private final PubSubComponent component;

        public AdHocScriptCommandManagerImpl(PubSubComponent component) {
            this.component = component;
        }

        @Override
        public List<Element> getCommandListItems(JID senderJid, JID toJid) {
            return this.component.getScriptItems("http://jabber.org/protocol/commands", toJid, senderJid);
        }

        @Override
        public List<Packet> process(Packet packet) {
            ArrayDeque results = new ArrayDeque();
            if (this.component.processScriptCommand(packet, results)) {
                return new ArrayList<Packet>(results);
            }
            return null;
        }
    }
}

