/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.HashMap;
import java.util.Map;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.pubsub.utils.FragmentedMap;
import tigase.util.JIDUtils;

public class NodeSubscriptions
implements ISubscriptions {
    protected static final String DELIMITER = ";";
    public static final int MAX_FRAGMENT_SIZE = 10000;
    private boolean changed = false;
    protected final FragmentedMap<String, UsersSubscription> subs = new FragmentedMap(10000);

    public static NodeSubscriptions create() {
        NodeSubscriptions s = new NodeSubscriptions();
        return s;
    }

    protected NodeSubscriptions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addSubscriberJid(String jid, Subscription subscription) {
        String subid = Utils.createUID(jid);
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        FragmentedMap<String, UsersSubscription> fragmentedMap = this.subs;
        synchronized (fragmentedMap) {
            this.subs.put(bareJid, s);
        }
        this.changed = true;
        return subid;
    }

    @Override
    public void changeSubscription(String jid, Subscription subscription) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
            this.changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UsersSubscription get(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        FragmentedMap<String, UsersSubscription> fragmentedMap = this.subs;
        synchronized (fragmentedMap) {
            UsersSubscription s = this.subs.get(bareJid);
            return s;
        }
    }

    public FragmentedMap<String, UsersSubscription> getFragmentedMap() {
        return this.subs;
    }

    @Override
    public Subscription getSubscription(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            return s.getSubscription();
        }
        return Subscription.none;
    }

    @Override
    public String getSubscriptionId(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            return s.getSubid();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsersSubscription[] getSubscriptions() {
        FragmentedMap<String, UsersSubscription> fragmentedMap = this.subs;
        synchronized (fragmentedMap) {
            return this.subs.getAllValues().toArray(new UsersSubscription[0]);
        }
    }

    public Map<String, UsersSubscription> getSubscriptionsMap() {
        return this.subs.getMap();
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(String data) {
        HashMap<String, UsersSubscription> parsed = new HashMap<String, UsersSubscription>();
        String[] tokens = data.split(DELIMITER);
        int c = 0;
        String jid = null;
        String subid = null;
        String state = null;
        for (String t : tokens) {
            if (c == 2) {
                state = t;
                ++c;
            } else if (c == 1) {
                subid = t;
                ++c;
            } else if (c == 0) {
                jid = t;
                ++c;
            }
            if (c != 3) continue;
            UsersSubscription b = new UsersSubscription(jid, subid, Subscription.valueOf(state));
            parsed.put(jid, b);
            jid = null;
            subid = null;
            state = null;
            c = 0;
        }
        FragmentedMap<String, UsersSubscription> fragmentedMap = this.subs;
        synchronized (fragmentedMap) {
            this.subs.addFragment(parsed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBy(ISubscriptions nodeSubscriptions) {
        FragmentedMap<String, UsersSubscription> fragmentedMap = this.subs;
        synchronized (fragmentedMap) {
            if (nodeSubscriptions instanceof NodeSubscriptions) {
                NodeSubscriptions ns = (NodeSubscriptions)nodeSubscriptions;
                this.changed = true;
                this.subs.clear();
                for (UsersSubscription a : ns.subs.getAllValues()) {
                    this.subs.put(a.getJid().toString(), a);
                }
            } else {
                throw new RuntimeException("!!!!!!!!!!!!!!!!!!!" + nodeSubscriptions.getClass());
            }
        }
    }

    public void resetChangedFlag() {
        this.changed = false;
    }

    @Override
    public String serialize(Map<String, UsersSubscription> fragment) {
        StringBuilder sb = new StringBuilder();
        for (UsersSubscription s : fragment.values()) {
            if (s.getSubscription() == Subscription.none) continue;
            sb.append(s.getJid());
            sb.append(DELIMITER);
            sb.append(s.getSubid());
            sb.append(DELIMITER);
            sb.append(s.getSubscription().name());
            sb.append(DELIMITER);
        }
        return sb.toString();
    }
}

