/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.PublisherModel;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PresenceCollectorModule;
import tigase.pubsub.modules.XsltTool;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PublishItemModule
extends AbstractModule {
    public static final String[] SUPPORTED_PEP_XMLNS = new String[]{"http://jabber.org/protocol/mood", "http://jabber.org/protocol/geoloc", "http://jabber.org/protocol/activity", "http://jabber.org/protocol/tune"};
    private static final Criteria CRIT_PUBLISH = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"publish"));
    private long idCounter = 0L;
    private final Set<String> pepNodes = new HashSet<String>();
    private final PresenceCollectorModule presenceCollector;
    private final XsltTool xslTransformer;

    public PublishItemModule(PubSubConfig config, IPubSubRepository pubsubRepository, XsltTool xsltTool, PresenceCollectorModule presenceCollector) {
        super(config, pubsubRepository);
        this.xslTransformer = xsltTool;
        this.presenceCollector = presenceCollector;
        for (String xmlns : SUPPORTED_PEP_XMLNS) {
            this.pepNodes.add(xmlns);
        }
    }

    protected void beforePrepareNotification(AbstractNodeConfig nodeConfig, ISubscriptions nodesSubscriptions) {
        if (nodeConfig.isPresenceExpired()) {
            // empty if block
        }
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#publish"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_PUBLISH;
    }

    protected List<String> getParents(BareJID serviceJid, String nodeName) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(serviceJid, nodeName);
        String cn = nodeConfig.getCollection();
        while (cn != null && !"".equals(cn)) {
            result.add(cn);
            AbstractNodeConfig nc = this.repository.getNodeConfig(serviceJid, cn);
            cn = nc.getCollection();
        }
        return result;
    }

    protected String[] getValidBuddies(String jid) throws RepositoryException {
        ArrayList<String> result = new ArrayList<String>();
        BareJID id = BareJID.bareJIDInstanceNS((String)jid);
        String[] rosterJids = this.repository.getUserRoster(id);
        if (rosterJids != null) {
            for (String j : rosterJids) {
                String sub = this.repository.getBuddySubscription(id, j);
                if (sub == null || !sub.equals("both") && !sub.equals("from")) continue;
                result.add(j);
            }
        }
        return result.toArray(new String[0]);
    }

    public boolean isPEPNodeName(String nodeName) {
        return this.pepNodes.contains(nodeName);
    }

    private List<Element> makeItemsToSend(Element publish) {
        ArrayList<Element> items = new ArrayList<Element>();
        for (Element si : publish.getChildren()) {
            if (!"item".equals(si.getName())) continue;
            items.add(si);
        }
        return items;
    }

    private List<Packet> pepProcess(Packet packet, Element pubSub, Element publish) throws RepositoryException {
        JID senderJid = packet.getStanzaFrom();
        Element item = publish.getChild("item");
        Element items = new Element("items", new String[]{"node"}, new String[]{publish.getAttributeStaticStr("node")});
        items.addChild((XMLNodeIfc)item);
        String[] subscribers = this.getValidBuddies(senderJid.getBareJID().toString());
        List<Packet> result = this.prepareNotification(subscribers, items, senderJid, null, publish.getAttributeStaticStr("node"), null);
        result.add(packet.okResult((Element)null, 0));
        result.addAll(this.prepareNotification(new String[]{senderJid.toString()}, items, senderJid, null, publish.getAttributeStaticStr("node"), null));
        return result;
    }

    public List<Packet> prepareNotification(Element itemToSend, JID jidFrom, String publisherNodeName, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodesSubscriptions) throws RepositoryException {
        return this.prepareNotification(itemToSend, jidFrom, publisherNodeName, null, nodeConfig, nodeAffiliations, nodesSubscriptions);
    }

    public List<Packet> prepareNotification(Element itemToSend, JID jidFrom, String publisherNodeName, Map<String, String> headers, AbstractNodeConfig nodeConfig, IAffiliations nodeAffiliations, ISubscriptions nodesSubscriptions) throws RepositoryException {
        this.beforePrepareNotification(nodeConfig, nodesSubscriptions);
        List<String> tmp = this.getActiveSubscribers(nodeConfig, nodeAffiliations, nodesSubscriptions);
        boolean updateSubscriptions = false;
        if (nodeConfig.isPresenceExpired()) {
            Iterator<String> it = tmp.iterator();
            while (it.hasNext()) {
                String jid = it.next();
                boolean available = this.presenceCollector.isJidAvailable(jid);
                UsersAffiliation afi = nodeAffiliations.getSubscriberAffiliation(jid);
                if (afi != null && (available || afi.getAffiliation() != Affiliation.member)) continue;
                it.remove();
                nodesSubscriptions.changeSubscription(jid, Subscription.none);
                updateSubscriptions = true;
                if (!this.log.isLoggable(Level.FINE)) continue;
                this.log.fine("Subscriptione expired. Node: " + nodeConfig.getNodeName() + ", jid: " + jid);
            }
        }
        if (updateSubscriptions) {
            this.repository.update(jidFrom.getBareJID(), nodeConfig.getNodeName(), nodesSubscriptions);
        }
        String[] subscribers = tmp.toArray(new String[0]);
        if (nodeConfig.isDeliverPresenceBased()) {
            ArrayList<String> s = new ArrayList<String>();
            for (String jid : subscribers) {
                for (String subjid : this.presenceCollector.getAllAvailableResources(jid)) {
                    s.add(subjid);
                }
            }
            subscribers = s.toArray(new String[0]);
        }
        return this.prepareNotification(subscribers, itemToSend, jidFrom, nodeConfig, publisherNodeName, headers);
    }

    public List<Packet> prepareNotification(String[] subscribers, Element itemToSend, JID jidFrom, AbstractNodeConfig nodeConfig, String publisherNodeName, Map<String, String> headers) {
        ArrayList<Packet> result = new ArrayList<Packet>();
        List<Element> body = null;
        if (this.xslTransformer != null && nodeConfig != null) {
            try {
                body = this.xslTransformer.transform(itemToSend, nodeConfig);
            }
            catch (Exception e) {
                body = null;
                this.log.log(Level.WARNING, "Problem with generating BODY", e);
            }
        }
        for (String jidStr : subscribers) {
            JID jid = JID.jidInstanceNS((String)jidStr);
            Packet packet = Message.getMessage((JID)jidFrom, (JID)jid, null, null, null, null, (String)String.valueOf(++this.idCounter));
            Element message = packet.getElement();
            if (body != null) {
                message.addChildren(body);
            }
            Element event = new Element("event", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#event"});
            event.addChild((XMLNodeIfc)itemToSend);
            message.addChild((XMLNodeIfc)event);
            if (headers != null && headers.size() > 0) {
                Element headElem = new Element("headers", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/shim"});
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    Element h = new Element("header", entry.getValue(), new String[]{"name"}, new String[]{entry.getKey()});
                    headElem.addChild((XMLNodeIfc)h);
                }
                message.addChild((XMLNodeIfc)headElem);
            }
            result.add(packet);
        }
        return result;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element publish = pubSub.getChild("publish");
        String nodeName = publish.getAttributeStaticStr("node");
        try {
            if (this.isPEPNodeName(nodeName)) {
                return this.pepProcess(packet, pubSub, publish);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeType() == NodeType.collection) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "publish"));
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(toJid, nodeName);
            UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(element.getAttributeStaticStr("from"));
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(toJid, nodeName);
            PublisherModel publisherModel = nodeConfig.getPublisherModel();
            if (!senderAffiliation.getAffiliation().isPublishItem() && (publisherModel == PublisherModel.publishers || publisherModel == PublisherModel.subscribers && nodeSubscriptions.getSubscription(element.getAttributeStaticStr("from")) != Subscription.subscribed)) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
            List<Element> itemsToSend = this.makeItemsToSend(publish);
            ArrayList<Packet> result = new ArrayList<Packet>();
            Packet resultIq = packet.okResult((Element)null, 0);
            result.add(resultIq);
            if (leafNodeConfig.isPersistItem()) {
                Element resPubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                resultIq.getElement().addChild((XMLNodeIfc)resPubsub);
                Element resPublish = new Element("publish", new String[]{"node"}, new String[]{nodeName});
                resPubsub.addChild((XMLNodeIfc)resPublish);
                for (Element item : itemsToSend) {
                    String id = item.getAttributeStaticStr("id");
                    if (id == null) {
                        id = Utils.createUID();
                        item.setAttribute("id", id);
                    }
                    resPublish.addChild((XMLNodeIfc)new Element("item", new String[]{"id"}, new String[]{id}));
                }
            }
            Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
            items.addChildren(itemsToSend);
            result.addAll(this.prepareNotification(items, packet.getStanzaTo(), nodeName, this.repository.getNodeConfig(toJid, nodeName), nodeAffiliations, nodeSubscriptions));
            List<String> parents = this.getParents(toJid, nodeName);
            if (parents != null && parents.size() > 0) {
                for (String collection : parents) {
                    HashMap<String, String> headers = new HashMap<String, String>();
                    headers.put("Collection", collection);
                    AbstractNodeConfig colNodeConfig = this.repository.getNodeConfig(toJid, collection);
                    ISubscriptions colNodeSubscriptions = this.repository.getNodeSubscriptions(toJid, collection);
                    IAffiliations colNodeAffiliations = this.repository.getNodeAffiliations(toJid, collection);
                    result.addAll(this.prepareNotification(items, packet.getStanzaTo(), nodeName, headers, colNodeConfig, colNodeAffiliations, colNodeSubscriptions));
                }
            }
            if (leafNodeConfig.isPersistItem()) {
                IItems nodeItems = this.repository.getNodeItems(toJid, nodeName);
                for (Element item : itemsToSend) {
                    String id = item.getAttributeStaticStr("id");
                    nodeItems.writeItem(System.currentTimeMillis(), id, element.getAttributeStaticStr("from"), item);
                }
                if (leafNodeConfig.getMaxItems() != null) {
                    this.trimItems(nodeItems, leafNodeConfig.getMaxItems());
                }
            }
            return result;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void trimItems(IItems nodeItems, Integer maxItems) throws RepositoryException {
        String[] ids = nodeItems.getItemsIds();
        if (ids == null || ids.length <= maxItems) {
            return;
        }
        ArrayList<Item> items = new ArrayList<Item>();
        for (String id : ids) {
            Date updateDate = nodeItems.getItemUpdateDate(id);
            if (updateDate == null) continue;
            Item i = new Item(id, updateDate);
            items.add(i);
        }
        Collections.sort(items, new Comparator<Item>(){

            @Override
            public int compare(Item o1, Item o2) {
                return o2.updateDate.compareTo(o1.updateDate);
            }
        });
        for (int i = maxItems.intValue(); i < items.size(); ++i) {
            Item it = (Item)items.get(i);
            nodeItems.deleteItem(it.id);
        }
    }

    private static class Item {
        final String id;
        final Date updateDate;

        Item(String id, Date date) {
            this.updateDate = date;
            this.id = id;
        }
    }
}

