/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.Module;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class PresenceCollectorModule
implements Module {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final Map<String, Set<String>> resources = new HashMap<String, Set<String>>();

    public synchronized boolean addJid(String jid) {
        if (jid == null) {
            return false;
        }
        boolean added = false;
        String bareJid = JIDUtils.getNodeID((String)jid);
        String resource = JIDUtils.getNodeResource((String)jid);
        if (resource != null) {
            Set<String> resources = this.resources.get(bareJid);
            if (resources == null) {
                resources = new HashSet<String>();
                this.resources.put(bareJid, resources);
            }
            added = resources.add(resource);
            this.log.finest("Contact " + jid + " is collected.");
        }
        return added;
    }

    public List<String> getAllAvailableJids() {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : this.resources.entrySet()) {
            for (String reource : entry.getValue()) {
                result.add(entry.getKey() + "/" + reource);
            }
        }
        return result;
    }

    public List<String> getAllAvailableResources(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        ArrayList<String> result = new ArrayList<String>();
        Set<String> resources = this.resources.get(bareJid);
        if (resources != null) {
            for (String reource : resources) {
                result.add(bareJid + "/" + reource);
            }
        }
        return result;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#presence-notifications"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isJidAvailable(String jid) {
        String bareJid = JIDUtils.getNodeID((String)jid);
        Set<String> resources = this.resources.get(bareJid);
        return resources != null && resources.size() > 0;
    }

    private Packet preparePresence(Packet presence, String type) {
        JID to = presence.getTo();
        if (to != null) {
            JID jid = to.copyWithoutResource();
            Element p = new Element("presence", new String[]{"to", "from"}, new String[]{jid.toString(), to.toString()});
            if (type != null) {
                p.setAttribute("type", type);
            }
            return new Presence(p, jid, presence.getStanzaTo());
        }
        return null;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        StanzaType type = packet.getType();
        JID jid = packet.getStanzaFrom();
        JID toJid = packet.getStanzaTo();
        ArrayList<Packet> result = new ArrayList<Packet>();
        if (type == null) {
            boolean added = this.addJid(jid.toString());
            if (added) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from"}, new String[]{jid.toString(), toJid.toString()}), toJid, jid);
                result.add((Packet)p);
            }
        } else if (type == StanzaType.unavailable) {
            this.removeJid(jid.toString());
            Presence p = new Presence(new Element("presence", new String[]{"to", "from", "type"}, new String[]{jid.toString(), toJid.toString(), "unavailable"}), toJid, jid);
            result.add((Packet)p);
        } else if (type == StanzaType.available) {
            this.log.finest("Contact " + jid + " wants to subscribe PubSub");
            Packet presence = this.preparePresence(packet, "subscribed");
            if (presence != null) {
                result.add(presence);
            }
            if ((presence = this.preparePresence(packet, "subscribe")) != null) {
                result.add(presence);
            }
        } else if (type == StanzaType.unsubscribe || type == StanzaType.unsubscribed) {
            this.log.finest("Contact " + jid + " wants to unsubscribe PubSub");
            Packet presence = this.preparePresence(packet, "unsubscribed");
            if (presence != null) {
                result.add(presence);
            }
            if ((presence = this.preparePresence(packet, "unsubscribe")) != null) {
                result.add(presence);
            }
        }
        return result.size() == 0 ? null : result;
    }

    protected synchronized boolean removeJid(String jid) {
        if (jid == null) {
            return false;
        }
        String bareJid = JIDUtils.getNodeID((String)jid);
        String resource = JIDUtils.getNodeResource((String)jid);
        boolean removed = false;
        if (resource == null) {
            this.resources.remove(bareJid);
        } else {
            Set<String> resources = this.resources.get(bareJid);
            if (resources != null) {
                removed = resources.remove(resource);
                this.log.finest("Contact " + jid + " is removed from collection.");
                if (resources.size() == 0) {
                    this.resources.remove(bareJid);
                }
            }
        }
        return removed;
    }
}

