/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.SubscribeNodeModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Message;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PendingSubscriptionModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"message").add((Criteria)ElementCriteria.name((String)"x", (String[])new String[]{"xmlns", "type"}, (String[])new String[]{"jabber:x:data", "submit"})).add((Criteria)ElementCriteria.name((String)"field", (String[])new String[]{"var"}, (String[])new String[]{"FORM_TYPE"})).add((Criteria)ElementCriteria.name((String)"value", (String)"http://jabber.org/protocol/pubsub#subscribe_authorization", null, null));

    public PendingSubscriptionModule(PubSubConfig config, IPubSubRepository pubsubRepository) {
        super(config, pubsubRepository);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#get-pending"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public List<Packet> process(Packet message, PacketWriter packetWriter) throws PubSubException {
        try {
            UsersAffiliation senderAffiliation;
            BareJID toJid = message.getStanzaTo().getBareJID();
            Element element = message.getElement();
            Form x = new Form(element.getChild("x", "jabber:x:data"));
            String subId = x.getAsString("pubsub#subid");
            String node = x.getAsString("pubsub#node");
            String subscriberJid = x.getAsString("pubsub#subscriber_jid");
            Boolean allow = x.getAsBoolean("pubsub#allow");
            if (allow == null) {
                return null;
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(toJid, node);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(toJid, node);
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(toJid, node);
            String jid = message.getAttributeStaticStr("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)jid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(jid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            String userSubId = nodeSubscriptions.getSubscriptionId(subscriberJid);
            if (subId != null && !subId.equals(userSubId)) {
                throw new PubSubException(element, Authorization.NOT_ACCEPTABLE, PubSubErrorCondition.INVALID_SUBID);
            }
            Subscription subscription = nodeSubscriptions.getSubscription(subscriberJid);
            if (subscription != Subscription.pending) {
                return null;
            }
            Affiliation affiliation = nodeAffiliations.getSubscriberAffiliation(jid).getAffiliation();
            if (allow.booleanValue()) {
                subscription = Subscription.subscribed;
                affiliation = Affiliation.member;
                nodeSubscriptions.changeSubscription(subscriberJid, subscription);
                nodeAffiliations.changeAffiliation(subscriberJid, affiliation);
            } else {
                subscription = Subscription.none;
                nodeSubscriptions.changeSubscription(subscriberJid, subscription);
            }
            if (nodeSubscriptions.isChanged()) {
                this.repository.update(toJid, node, nodeSubscriptions);
            }
            if (nodeAffiliations.isChanged()) {
                this.repository.update(toJid, node, nodeAffiliations);
            }
            Packet msg = Message.getMessage((JID)message.getStanzaTo(), (JID)JID.jidInstance((String)subscriberJid), null, null, null, null, (String)Utils.createUID(subscriberJid));
            msg.getElement().addChild((XMLNodeIfc)SubscribeNodeModule.makeSubscription(node, subscriberJid, subscription, null));
            return PendingSubscriptionModule.makeArray(msg);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public List<Packet> sendAuthorizationRequest(String nodeName, JID fromJid, String subID, String subscriberJid, IAffiliations nodeAffiliations) throws RepositoryException {
        Form x = new Form("form", "PubSub subscriber request", "To approve this entity's subscription request, click the OK button. To deny the request, click the cancel button.");
        x.addField(Field.fieldHidden((String)"FORM_TYPE", (String)"http://jabber.org/protocol/pubsub#subscribe_authorization"));
        x.addField(Field.fieldHidden((String)"pubsub#subid", (String)subID));
        x.addField(Field.fieldTextSingle((String)"pubsub#node", (String)nodeName, (String)"Node ID"));
        x.addField(Field.fieldJidSingle((String)"pubsub#subscriber_jid", (String)subscriberJid, (String)"UsersSubscription Address"));
        x.addField(Field.fieldBoolean((String)"pubsub#allow", (Boolean)Boolean.FALSE, (String)"Allow this JID to subscribe to this pubsub node?"));
        ArrayList<Packet> result = new ArrayList<Packet>();
        UsersAffiliation[] affiliations = nodeAffiliations.getAffiliations();
        if (affiliations != null) {
            for (UsersAffiliation affiliation : affiliations) {
                if (affiliation.getAffiliation() != Affiliation.owner) continue;
                Packet message = Message.getMessage((JID)fromJid, (JID)JID.jidInstanceNS((String)affiliation.getJid()), null, null, null, null, (String)Utils.createUID(affiliation.getJid()));
                message.getElement().addChild((XMLNodeIfc)x.getElement());
                result.add(message);
            }
        }
        return result;
    }
}

