/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractModule;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.NodeConfigListener;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;

public class NodeDeleteModule
extends AbstractModule {
    private static final Criteria CRIT_DELETE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"delete"));
    private final ArrayList<NodeConfigListener> nodeConfigListeners = new ArrayList();
    private final PublishItemModule publishModule;

    public NodeDeleteModule(PubSubConfig config, IPubSubRepository pubsubRepository, PublishItemModule publishItemModule) {
        super(config, pubsubRepository);
        this.publishModule = publishItemModule;
    }

    public void addNodeConfigListener(NodeConfigListener listener) {
        this.nodeConfigListeners.add(listener);
    }

    protected void fireOnNodeDeleted(String nodeName) {
        for (NodeConfigListener listener : this.nodeConfigListeners) {
            listener.onNodeDeleted(nodeName);
        }
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#delete-nodes"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_DELETE;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
        Element delete = pubSub.getChild("delete");
        String nodeName = delete.getAttributeStaticStr("node");
        try {
            CollectionNodeConfig cnc;
            String[] childrenNodes;
            UsersAffiliation senderAffiliation;
            if (nodeName == null) {
                throw new PubSubException(element, Authorization.NOT_ALLOWED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(toJid, nodeName);
            String jid = element.getAttributeStaticStr("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)jid)) && !(senderAffiliation = nodeAffiliations.getSubscriberAffiliation(jid)).getAffiliation().isDeleteNode()) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            List<Packet> resultArray = NodeDeleteModule.makeArray(packet.okResult((Element)null, 0));
            if (nodeConfig.isNotify_config()) {
                ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(toJid, nodeName);
                Element del = new Element("delete", new String[]{"node"}, new String[]{nodeName});
                resultArray.addAll(this.publishModule.prepareNotification(del, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
            }
            String parentNodeName = nodeConfig.getCollection();
            CollectionNodeConfig parentCollectionConfig = null;
            if (parentNodeName != null && !parentNodeName.equals("")) {
                parentCollectionConfig = (CollectionNodeConfig)this.repository.getNodeConfig(toJid, parentNodeName);
                if (parentCollectionConfig != null) {
                    parentCollectionConfig.removeChildren(nodeName);
                }
            } else {
                this.repository.removeFromRootCollection(toJid, nodeName);
            }
            if (nodeConfig instanceof CollectionNodeConfig && (childrenNodes = (cnc = (CollectionNodeConfig)nodeConfig).getChildren()) != null && childrenNodes.length > 0) {
                for (String childNodeName : childrenNodes) {
                    AbstractNodeConfig childNodeConfig = this.repository.getNodeConfig(toJid, childNodeName);
                    if (childNodeConfig != null) {
                        childNodeConfig.setCollection(parentNodeName);
                        this.repository.update(toJid, childNodeName, childNodeConfig);
                    }
                    if (parentCollectionConfig != null) {
                        parentCollectionConfig.addChildren(childNodeName);
                        continue;
                    }
                    this.repository.addToRootCollection(toJid, childNodeName);
                }
            }
            if (parentCollectionConfig != null) {
                this.repository.update(toJid, parentNodeName, parentCollectionConfig);
            }
            this.log.fine("Delete node [" + nodeName + "]");
            this.repository.deleteNode(toJid, nodeName);
            this.fireOnNodeDeleted(nodeName);
            return resultArray;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void removeNodeConfigListener(NodeConfigListener listener) {
        this.nodeConfigListeners.remove(listener);
    }
}

