/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PacketWriter;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AbstractConfigCreateNode;
import tigase.pubsub.modules.NodeConfigListener;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.util.JIDUtils;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.StanzaType;

public class NodeConfigModule
extends AbstractConfigCreateNode {
    private static final Criteria CRIT_CONFIG = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"configure"));
    private final ArrayList<NodeConfigListener> nodeConfigListeners = new ArrayList();
    private final PublishItemModule publishModule;

    public NodeConfigModule(PubSubConfig config, IPubSubRepository pubsubRepository, LeafNodeConfig defaultNodeConfig, PublishItemModule publishItemModule) {
        super(config, pubsubRepository, defaultNodeConfig);
        this.publishModule = publishItemModule;
    }

    protected static String[] diff(String[] a, String[] b) {
        HashSet<String> r = new HashSet<String>();
        for (String $a : a) {
            r.add($a);
        }
        for (String $a : b) {
            r.add($a);
        }
        for (String $a : b) {
            r.remove($a);
        }
        return r.toArray(new String[0]);
    }

    public static void parseConf(AbstractNodeConfig conf, Element configure) throws PubSubException {
        Element x = configure.getChild("x", "jabber:x:data");
        Form foo = new Form(x);
        if (x != null && "submit".equals(x.getAttributeStaticStr("type"))) {
            for (Field field : conf.getForm().getAllFields()) {
                String var = field.getVar();
                Field cf = foo.get(var);
                if (cf == null) continue;
                field.setValues(cf.getValues());
            }
        }
    }

    public void addNodeConfigListener(NodeConfigListener listener) {
        this.nodeConfigListeners.add(listener);
    }

    private Element createAssociateNotification(String collectionNodeName, String associatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild((XMLNodeIfc)new Element("associate", new String[]{"node"}, new String[]{associatedNodeName}));
        return colE;
    }

    private Element createDisassociateNotification(String collectionNodeName, String disassociatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild((XMLNodeIfc)new Element("disassociate", new String[]{"node"}, new String[]{disassociatedNodeName}));
        return colE;
    }

    protected void fireOnNodeConfigChange(String nodeName) {
        for (NodeConfigListener listener : this.nodeConfigListeners) {
            listener.onNodeConfigChanged(nodeName);
        }
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#config-node"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_CONFIG;
    }

    protected boolean isIn(String node, String[] children) {
        if (node == null | children == null) {
            return false;
        }
        for (String x : children) {
            if (!x.equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Packet> process(Packet packet, PacketWriter packetWriter) throws PubSubException {
        try {
            UsersAffiliation senderAffiliation;
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element element = packet.getElement();
            Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element configure = pubSub.getChild("configure");
            String nodeName = configure.getAttributeStaticStr("node");
            StanzaType type = packet.getType();
            String id = element.getAttributeStaticStr("id");
            if (nodeName == null) {
                throw new PubSubException(element, Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.repository.getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.repository.getNodeAffiliations(toJid, nodeName);
            String jid = element.getAttributeStaticStr("from");
            if (!this.config.isAdmin(JIDUtils.getNodeID((String)jid)) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(jid)).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            Packet result = packet.okResult((Element)null, 0);
            List<Packet> resultArray = NodeConfigModule.makeArray(result);
            ISubscriptions nodeSubscriptions = this.repository.getNodeSubscriptions(toJid, nodeName);
            if (type == StanzaType.get) {
                Element rPubSub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
                Element rConfigure = new Element("configure", new String[]{"node"}, new String[]{nodeName});
                Element f = nodeConfig.getFormElement();
                rConfigure.addChild((XMLNodeIfc)f);
                rPubSub.addChild((XMLNodeIfc)rConfigure);
                result.getElement().addChild((XMLNodeIfc)rPubSub);
            } else if (type == StanzaType.set) {
                String[] children = nodeConfig.getChildren() == null ? new String[]{} : Arrays.copyOf(nodeConfig.getChildren(), nodeConfig.getChildren().length);
                String collectionOld = nodeConfig.getCollection() == null ? "" : nodeConfig.getCollection();
                NodeConfigModule.parseConf(nodeConfig, configure);
                if (!collectionOld.equals(nodeConfig.getCollection())) {
                    ISubscriptions colNodeSubscriptions;
                    IAffiliations colNodeAffiliations;
                    AbstractNodeConfig colNodeConfig;
                    if (collectionOld.equals("")) {
                        colNodeConfig = this.repository.getNodeConfig(toJid, nodeConfig.getCollection());
                        if (colNodeConfig == null) {
                            throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#1) Node '" + nodeConfig.getCollection() + "' doesn't exists");
                        }
                        if (!(colNodeConfig instanceof CollectionNodeConfig)) {
                            throw new PubSubException(Authorization.NOT_ALLOWED, "(#1) Node '" + nodeConfig.getCollection() + "' is not collection node");
                        }
                        ((CollectionNodeConfig)colNodeConfig).addChildren(nodeName);
                        this.repository.update(toJid, colNodeConfig.getNodeName(), colNodeConfig);
                        this.repository.removeFromRootCollection(toJid, nodeName);
                        colNodeAffiliations = this.repository.getNodeAffiliations(toJid, colNodeConfig.getNodeName());
                        colNodeSubscriptions = this.repository.getNodeSubscriptions(toJid, colNodeConfig.getNodeName());
                        Element associateNotification = this.createAssociateNotification(colNodeConfig.getNodeName(), nodeName);
                        resultArray.addAll(this.publishModule.prepareNotification(associateNotification, packet.getStanzaTo(), nodeName, nodeConfig, colNodeAffiliations, colNodeSubscriptions));
                    }
                    if (nodeConfig.getCollection().equals("")) {
                        colNodeConfig = this.repository.getNodeConfig(toJid, collectionOld);
                        if (colNodeConfig != null && colNodeConfig instanceof CollectionNodeConfig) {
                            ((CollectionNodeConfig)colNodeConfig).removeChildren(nodeName);
                            this.repository.update(toJid, colNodeConfig.getNodeName(), colNodeConfig);
                        }
                        this.repository.addToRootCollection(toJid, nodeName);
                        colNodeAffiliations = this.repository.getNodeAffiliations(toJid, colNodeConfig.getNodeName());
                        colNodeSubscriptions = this.repository.getNodeSubscriptions(toJid, colNodeConfig.getNodeName());
                        Element disassociateNotification = this.createDisassociateNotification(collectionOld, nodeName);
                        resultArray.addAll(this.publishModule.prepareNotification(disassociateNotification, packet.getStanzaTo(), nodeName, nodeConfig, colNodeAffiliations, colNodeSubscriptions));
                    }
                }
                if (nodeConfig instanceof CollectionNodeConfig) {
                    AbstractNodeConfig nc;
                    String[] addedChildNodes;
                    String[] removedChildNodes = NodeConfigModule.diff(children == null ? new String[]{} : children, nodeConfig.getChildren() == null ? new String[]{} : nodeConfig.getChildren());
                    for (String ann : addedChildNodes = NodeConfigModule.diff(nodeConfig.getChildren() == null ? new String[]{} : nodeConfig.getChildren(), children == null ? new String[]{} : children)) {
                        nc = this.repository.getNodeConfig(toJid, ann);
                        if (nc == null) {
                            throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#2) Node '" + ann + "' doesn't exists");
                        }
                        if (nc.getCollection().equals("")) {
                            this.repository.removeFromRootCollection(toJid, nc.getNodeName());
                        } else {
                            AbstractNodeConfig cnc = this.repository.getNodeConfig(toJid, nc.getCollection());
                            if (cnc == null) {
                                throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#3) Node '" + nc.getCollection() + "' doesn't exists");
                            }
                            if (!(cnc instanceof CollectionNodeConfig)) {
                                throw new PubSubException(Authorization.NOT_ALLOWED, "(#2) Node '" + nc.getCollection() + "' is not collection node");
                            }
                            ((CollectionNodeConfig)cnc).removeChildren(nc.getNodeName());
                            this.repository.update(toJid, cnc.getNodeName(), cnc);
                        }
                        nc.setCollection(nodeName);
                        this.repository.update(toJid, nc.getNodeName(), nc);
                        Element associateNotification = this.createAssociateNotification(nodeName, ann);
                        resultArray.addAll(this.publishModule.prepareNotification(associateNotification, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
                    }
                    for (String rnn : removedChildNodes) {
                        nc = this.repository.getNodeConfig(toJid, rnn);
                        if (nc != null) {
                            nc.setCollection("");
                            this.repository.update(toJid, nc.getNodeName(), nc);
                        }
                        if (rnn == null || rnn.length() == 0) continue;
                        Element disassociateNotification = this.createDisassociateNotification(nodeName, rnn);
                        resultArray.addAll(this.publishModule.prepareNotification(disassociateNotification, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
                    }
                }
                this.repository.update(toJid, nodeName, nodeConfig);
                if (nodeConfig.isNotify_config()) {
                    Element configuration = new Element("configuration", new String[]{"node"}, new String[]{nodeName});
                    resultArray.addAll(this.publishModule.prepareNotification(configuration, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions));
                }
            } else {
                throw new PubSubException(element, Authorization.BAD_REQUEST);
            }
            return resultArray;
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void removeNodeConfigListener(NodeConfigListener listener) {
        this.nodeConfigListeners.remove(listener);
    }
}

